package com.ejianc.business.profinance.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 项目资金计划-公司机关欠款情况
 *
 * @author baipengyan
 */
@TableName("ejc_profinance_plan_overdraft")
public class PlanOverdraftEntity extends BaseEntity {
	private static final long serialVersionUID = -1130629087864935582L;

	@TableField(value = "content")
	private String content; // 内容
	@TableField(value = "payable_mny")
	private BigDecimal payableMny; // 应缴金额
	@TableField(value = "paid_mny")
	private BigDecimal paidMny; // 已缴金额
	@TableField(value = "overdraft_mny")
	private BigDecimal overdraftMny; // 欠款金额
	@TableField(value = "paid_mny_scale")
	private BigDecimal paidMnyScale; // 已缴金额比例(%)
	@TableField(value = "overdraft_memo")
	private String overdraftMemo; // 备注
	@TableField(value = "plan_id")
	private Long planId; // 项目资金计划id


	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public BigDecimal getPayableMny() {
		return payableMny;
	}

	public void setPayableMny(BigDecimal payableMny) {
		this.payableMny = payableMny;
	}

	public BigDecimal getPaidMny() {
		return paidMny;
	}

	public void setPaidMny(BigDecimal paidMny) {
		this.paidMny = paidMny;
	}

	public BigDecimal getOverdraftMny() {
		return overdraftMny;
	}

	public void setOverdraftMny(BigDecimal overdraftMny) {
		this.overdraftMny = overdraftMny;
	}

	public BigDecimal getPaidMnyScale() {
		return paidMnyScale;
	}

	public void setPaidMnyScale(BigDecimal paidMnyScale) {
		this.paidMnyScale = paidMnyScale;
	}

	public String getOverdraftMemo() {
		return overdraftMemo;
	}

	public void setOverdraftMemo(String overdraftMemo) {
		this.overdraftMemo = overdraftMemo;
	}

	public Long getPlanId() {
		return planId;
	}

	public void setPlanId(Long planId) {
		this.planId = planId;
	}

}
