package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Service("paymentApply")
public class PaymentApplyBpmServiceImpl implements ICommonBusinessService {

    @Autowired
	private IPaymentApplyService service;


	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		// 付款申请日期校验
//        PaymentApplyEntity paymentApplyEntity = service.selectById(billId);
//        if (paymentApplyEntity == null) {
//            return CommonResponse.error("查询不到该单据信息！");
//        }
//        // 打印结算单日志
//        logger.info("付款申请提交前回调，付款申请信息：{}", JSON.toJSONString(paymentApplyEntity));
//
//        CommonResponse<PaymentApplyVO> result = service.queryUnusedPaymentApply(paymentApplyEntity.getPaymentType(), paymentApplyEntity.getProjectId(), paymentApplyEntity.getSupplierId(), paymentApplyEntity.getApplyDate());
//        if (result.isSuccess()){
//			return CommonResponse.success("付款申请-提交前回调成功！");
//		}else {
//			return CommonResponse.error(result.getMsg());
//		}
		return CommonResponse.success("付款申请-提交前回调成功！");
	}

	/**
	 * 终审审核完回调
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PaymentApplyEntity entity = service.selectById(billId);
		if (entity==null){

		}
		entity.setActualApplyMny(entity.getApprovalMny());
		service.saveOrUpdate(entity,false);
		return CommonResponse.success("付款申请终审回调成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 撤回、弃审回调方法
	 *
	 * @param billId
	 * @param state
	 * @param billTypeCode
	 * @return
	 */
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		logger.info("付款申请单据billId-{}, state-{}, billTypeCode-{}撤回前校验", billId, state, billTypeCode);
		//已关闭的申请不能撤回
		PaymentApplyEntity paymentApplyEntity = service.selectById(billId);
		if (paymentApplyEntity == null) {
			return CommonResponse.error("查询不到该单据信息！");
		}
		logger.info("撤回前付款申请实体信息为：{}", JSONObject.toJSONString(paymentApplyEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
		//有合同付款申请 撤回校验
		if (paymentApplyEntity.getPaymentContractFlag()==0){
			//查询当前合同是否存在自由态的单据
			QueryWrapper<PaymentApplyEntity> listQuery = new QueryWrapper<>();
			listQuery.eq("contract_id", paymentApplyEntity.getContractId());
			listQuery.eq("bill_state",BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
			int resultCount = service.count(listQuery);
			if (resultCount > 0) {
				return CommonResponse.error("当前合同已存在自由态的付款申请 不能弃审/撤回！");
			}
		}
		//已关闭的不能弃审
		if (null != paymentApplyEntity.getCloseState() && paymentApplyEntity.getCloseState().equals(1)) {
			return CommonResponse.error("当前单据已关闭，不能弃审/撤回！");
		}
		//已付款的不能弃审
		if (null != paymentApplyEntity.getPaymentStatus() && paymentApplyEntity.getPaymentStatus().equals(2)){
			return CommonResponse.error("当前单据已付款，不能弃审！");
		}
		// 调用PM付款申请弃审/关闭接口
		if (paymentApplyEntity.getActualMny()!=null){
			if (paymentApplyEntity.getActualMny().compareTo(BigDecimal.ZERO)==1){
				return CommonResponse.error("当前付款单已存在实际支付金额无法弃审");
			}
		}
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

}
