package com.ejianc.business.profinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.mapper.SalaryPayApplyDetailMapper;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.profinance.mapper.SalaryDetailMapper;
import com.ejianc.business.profinance.bean.SalaryDetailEntity;
import com.ejianc.business.profinance.service.ISalaryDetailService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工人工资单子实体
 * 
 * @author generator
 * 
 */
@Service("salaryDetailService")
public class SalaryDetailServiceImpl extends BaseServiceImpl<SalaryDetailMapper, SalaryDetailEntity> implements ISalaryDetailService{
    @Autowired
    private SalaryDetailMapper SalaryDetailMapper;

    @Override
    public List<Long> selectUseGlodonSalaryIds(HashSet<Long> sourceSalaryIds) {
        return SalaryDetailMapper.selectUseGlodonSalaryIds(sourceSalaryIds);
    }

    /**
     * 工资支付申请支付成功后回写工人工资单子表数据
     * @param salaryPayApplyDetailVOList
     */
    @Override
    public void writeBackSalaryDetail(List<SalaryPayApplyDetailVO> salaryPayApplyDetailVOList) {
        Map<Long, BigDecimal> salaryDetailMap = new HashMap<>();
        List<Long> sourceIdList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailVOList)){
            for (SalaryPayApplyDetailVO applyDetail : salaryPayApplyDetailVOList) {
                sourceIdList.add(applyDetail.getSourceId());
                salaryDetailMap.put(applyDetail.getSourceId(), applyDetail.getWorkerActualPaidTaxMny());
            }
        }
        QueryWrapper<SalaryDetailEntity> salaryDetailEntityQueryWrapper = new QueryWrapper<>();
        salaryDetailEntityQueryWrapper.in("id", sourceIdList);
        List<SalaryDetailEntity> salaryDetailEntityList = super.list(salaryDetailEntityQueryWrapper);
        //修改工资单子表实际支付金额
        if (CollectionUtils.isNotEmpty(salaryDetailEntityList)){
            for (SalaryDetailEntity salaryDetailEntity : salaryDetailEntityList) {
                salaryDetailEntity.setActualSalaryMny(salaryDetailMap.get(salaryDetailEntity.getId()));
                //设置欠发=应发-实发
                salaryDetailEntity.setOweSalaryMny(salaryDetailEntity.getSalaryMny().subtract(salaryDetailEntity.getActualSalaryMny()));
                salaryDetailEntity.setPayday(new Date());
            }
        }
        super.saveOrUpdateBatch(salaryDetailEntityList);
    }

    @Override
    public void modifyWorkerRemainderTaxMny(List<SalaryPayApplyDetailVO> detailVOList) {
        /*
         * 通过工资支付申请子表的sourceId获取相对应的工资单，然后修改他们的剩余可发金额（加上对应工资申请单的本期申请金额）
         */
        List<Long> ids = detailVOList.stream().map(item -> item.getSourceId()).collect(Collectors.toList());
        Map<Long, BigDecimal> salaryDetailMap = new HashMap<>();
        for (SalaryPayApplyDetailVO salaryPayApplyDetailVO : detailVOList) {
            salaryDetailMap.put(salaryPayApplyDetailVO.getSourceId(), salaryPayApplyDetailVO.getWorkerApplyTaxMny());
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<SalaryDetailEntity> salaryDetailList = super.queryList(param, false);
        if (CollectionUtils.isNotEmpty(salaryDetailList)){
            for (SalaryDetailEntity salaryDetailEntity : salaryDetailList) {
                BigDecimal workerRemainderTaxMny = null != salaryDetailMap.get(salaryDetailEntity.getId()) ? salaryDetailMap.get(salaryDetailEntity.getId()) : BigDecimal.ZERO;
                salaryDetailEntity.setWorkerRemainderTaxMny(salaryDetailEntity.getWorkerRemainderTaxMny().add(workerRemainderTaxMny));
            }
        }
        super.saveOrUpdateBatch(salaryDetailList);
    }
}
