package com.ejianc.business.receipt.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.receipt.bean.ReceiptRegisterEntity;
import com.ejianc.business.receipt.vo.ReceiptRegisterVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 收款登记主实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface ReceiptRegisterMapper extends BaseCrudMapper<ReceiptRegisterEntity> {
    List<ReceiptRegisterVO> queryPageList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<Map<String, Object>> queryContractRecInfo(@Param(value = "curStartDate") String curStartDate, @Param(value = "curEndDate") String curEndDate,
                                                   @Param(value = "lastYearStartDate") String lastYearStartDate, @Param(value = "lastYearEndDate") String lastYearEndDate,
                                                   @Param(value = "contractIds") List<Long> contractIds, @Param("groupByFields") String groupByFields,
                                                   @Param(value = "curYear") String curYear);
}
