package com.ejianc.business.receipt.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.receipt.bean.ReceiptRegisterEntity;
import com.ejianc.business.receipt.vo.ReceiptRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 收款登记主实体
 * 
 * @author generator
 * 
 */
public interface IReceiptRegisterService extends IBaseService<ReceiptRegisterEntity> {

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    String saveImportExcel(HttpServletRequest request, List<ReceiptRegisterVO> importVOS);

    Map<String, BigDecimal> queryReceiptMny(Long contractId,Long projectId);

    String validateContract(Long contractId,Long id);

    BigDecimal getTotalColumnInfo(QueryParam param, boolean isEs);

    void autoPMReceipt();

    /**
     *  查询指定合同
     *  1、在指定范围内产生收款登记的总金额
     *  2、上一年度收款金额
     *  3、合同开工收款登记总金额
     *
     * @param curStartDate 本期开始日期
     * @param curEndDate 本期结束日期
     * @param lastYearStartDate 上一年度开始日期
     * @param lastYearEndDate 上一年度结束日期
     * @param contractIds   合同Id列表
     * @param curYear
     * @return
     */
    List<Map<String, Object>> queryContractRecInfo(String curStartDate, String curEndDate, String lastYearStartDate, String lastYearEndDate, List<Long> contractIds, String groupFields, String curYear);
}
