/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.odd.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.profinance.odd.bean.OddAllocationEntity;
import com.ejianc.business.profinance.odd.service.IOddAllocationService;
import com.ejianc.business.profinance.odd.vo.ImportOddAllocationVO;
import com.ejianc.business.profinance.odd.vo.OddAllocationVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"oddAllocation"})
@Api(value="\u96f6\u661f\u8d39\u7528\u5206\u914d\u4e3b\u8868", tags={"\u96f6\u661f\u8d39\u7528\u5206\u914d\u4e3b\u8868"})
public class OddAllocationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IExecutionApi executionApi;
    private static final String BILL_CODE = "ODD_ALLOCATION";
    @Autowired
    private IOddAllocationService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OddAllocationVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OddAllocationVO saveOrUpdateVO) {
        OddAllocationEntity entity = (OddAllocationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OddAllocationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(OddAllocationEntity::getOddFeeId, (Object)entity.getOddFeeId());
            lambdaQueryWrapper.notIn(OddAllocationEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            List list = this.service.list((Wrapper)lambdaQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                throw new BusinessException("\u8be5\u96f6\u661f\u8d39\u7528\u5355\u53f7\u4e0b\u6709\u672a\u751f\u6548\u7684\u96f6\u661f\u8d39\u7528\u5206\u914d\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
            }
        }
        entity.setRelationFlag("0");
        entity.setProportionFlag("0");
        this.service.saveOrUpdate((Object)entity, false);
        this.service.saveCost(entity, 0);
        OddAllocationVO vo = (OddAllocationVO)BeanMapper.map((Object)((Object)entity), OddAllocationVO.class);
        this.service.pushSettleToCost(vo);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OddAllocationVO> queryDetail(@RequestParam Long id) {
        OddAllocationEntity entity = (OddAllocationEntity)((Object)this.service.selectById(id));
        OddAllocationVO vo = (OddAllocationVO)BeanMapper.map((Object)((Object)entity), OddAllocationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u5173\u8054\u4fdd\u5b58\u63a5\u53e3")
    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OddAllocationVO> pushCost(@RequestBody OddAllocationVO OddAllocationVO2) {
        return this.service.pushCost(OddAllocationVO2);
    }

    @ApiOperation(value="\u6821\u9a8c\u552f\u4e00")
    @RequestMapping(value={"/checkOddFee"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkOddFee(@RequestParam Long oddFeeId, Long id) {
        List list;
        Boolean flag = true;
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(OddAllocationEntity::getOddFeeId, (Object)oddFeeId);
        lambdaQueryWrapper.notIn(OddAllocationEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        if (null != id) {
            lambdaQueryWrapper.ne(BaseEntity::getId, (Object)id);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.service.list((Wrapper)lambdaQueryWrapper)))) {
            flag = false;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)flag);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddAllocationVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List oddAllocationEntities = this.service.list((Wrapper)new QueryWrapper().in((Object)"id", ids));
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        for (OddAllocationEntity entity : oddAllocationEntities) {
            OddAllocationVO oddAllocationVO = (OddAllocationVO)BeanMapper.map((Object)this.service.selectById(entity.getId()), OddAllocationVO.class);
            ExecutionVO executionVO = this.service.settleCost(oddAllocationVO, "");
            totalExecutionVOList.add(executionVO.getTotalVO());
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(oddAllocationVO.getId());
            this.logger.info("\u5220\u9664\u5b9e\u9645\u6210\u672c\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (stringCommonResponse.isSuccess()) continue;
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        if (ListUtil.isNotEmpty(totalExecutionVOList)) {
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e\u7ed3\u679c---:{}", (Object)JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25," + response.getMsg());
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OddAllocationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("oddFeeCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("noContractFeeTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OddAllocationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("oddFeeCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("noContractFeeTypeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List oddAllocationVOS = new ArrayList();
        HashMap beans = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            oddAllocationVOS = BeanMapper.mapList((Iterable)list, OddAllocationVO.class);
            for (OddAllocationVO oddAllocationVO : oddAllocationVOS) {
                if (null != oddAllocationVO.getBillDate()) {
                    oddAllocationVO.setBillDateStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)oddAllocationVO.getBillDate()));
                }
                if (null != oddAllocationVO.getEmployeeDate()) {
                    oddAllocationVO.setEmployeeDateStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)oddAllocationVO.getEmployeeDate()));
                }
                if (null != oddAllocationVO.getHappenDate()) {
                    oddAllocationVO.setHappenDateStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)oddAllocationVO.getHappenDate()));
                }
                oddAllocationVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)oddAllocationVO.getBillState()).getDescription());
            }
        }
        beans.put("records", oddAllocationVOS);
        ExcelExport.getInstance().export("OddAllocation-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refOddAllocationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OddAllocationVO>> refOddAllocationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OddAllocationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"OddAllocation-import.xlsx", (String)"\u96f6\u661f\u8d39\u7528\u5206\u914d-\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }

    @RequestMapping(value={"/saveImportExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<ImportOddAllocationVO> importVOS) {
        return CommonResponse.success((String)this.service.saveImportExcel(request, importVOS));
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody OddAllocationVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @GetMapping(value={"/allOddAllocationPushTargetCost"})
    @ResponseBody
    public CommonResponse<String> allOddAllocationPushTargetCost(@RequestParam(value="projectId", required=false) Long projectId) {
        List oddAllocationEntityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"id"});
        if (null != projectId) {
            queryWrapper.eq((Object)"project_id", (Object)projectId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(oddAllocationEntityList = this.service.list((Wrapper)queryWrapper)))) {
            for (OddAllocationVO oddAllocationVO : BeanMapper.mapList((Iterable)oddAllocationEntityList, OddAllocationVO.class)) {
                this.service.pushSettleToCost(oddAllocationVO);
            }
        }
        this.logger.info("\u96f6\u661f\u8d39\u7528\u5206\u914d\u63a8\u9001\u76ee\u6807\u6210\u672c\u6570\u636e{}\u6761", (Object)oddAllocationEntityList.size());
        return CommonResponse.success((String)"\u96f6\u661f\u8d39\u7528\u5206\u914d\u63a8\u9001\u76ee\u6807\u6210\u672c\u6570\u636e\u6210\u529f\uff01");
    }
}

