/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.profinance.bean.SalaryDetailEntity;
import com.ejianc.business.profinance.bean.SalaryEntity;
import com.ejianc.business.profinance.mapper.SalaryMapper;
import com.ejianc.business.profinance.service.ISalaryService;
import com.ejianc.business.profinance.vo.ImportSalaryDetailVO;
import com.ejianc.business.profinance.vo.SalaryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="salaryService")
public class SalaryServiceImpl
extends BaseServiceImpl<SalaryMapper, SalaryEntity>
implements ISalaryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "WORKER_SALARY";

    @Override
    public SalaryVO insertOrUpdate(SalaryVO salaryVO) {
        SalaryEntity entity = (SalaryEntity)((Object)BeanMapper.map((Object)salaryVO, SalaryEntity.class));
        if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)salaryVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u5de5\u4eba\u5de5\u8d44\u5355\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5de5\u8d44\u5355\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
        } else if (this.checkSameBillCode((SalaryVO)BeanMapper.map((Object)((Object)entity), SalaryVO.class))) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        if (CollectionUtils.isNotEmpty(entity.getSalaryDetailList())) {
            for (SalaryDetailEntity salaryDetailEntity : entity.getSalaryDetailList()) {
                salaryDetailEntity.setSalaryBillCode(entity.getBillCode());
            }
        }
        super.saveOrUpdate((Object)entity, false);
        SalaryVO vo = (SalaryVO)BeanMapper.map((Object)super.selectById((Serializable)entity.getId()), SalaryVO.class);
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<ImportSalaryDetailVO> successList = new ArrayList<ImportSalaryDetailVO>();
        ArrayList<ImportSalaryDetailVO> errorList = new ArrayList<ImportSalaryDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 22) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ImportSalaryDetailVO salaryDetailVO = new ImportSalaryDetailVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    salaryDetailVO.setErrorMessage("\u5de5\u4eba\u59d3\u540d\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(0)).length() > 20 || ((String)datas.get(0)).length() == 1) {
                    salaryDetailVO.setErrorMessage("\u5de5\u4eba\u59d3\u540d\u586b\u5199\u957f\u5ea6\u4e3a2~20\u5b57");
                } else {
                    salaryDetailVO.setWorkerName(((String)datas.get(0)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    salaryDetailVO.setErrorMessage("\u5de5\u79cd\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(1)).length() > 20) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u5de5\u79cd\u957f\u5ea6\u4e3a1~20\u5b57");
                } else {
                    salaryDetailVO.setWorkType(((String)datas.get(1)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    salaryDetailVO.setErrorMessage("\u8eab\u4efd\u8bc1\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(2)).length() > 18) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u8eab\u4efd\u8bc1\u53f7\u957f\u5ea6\u6700\u5927\u4e3a18\u4f4d");
                } else {
                    salaryDetailVO.setWorkerIdCard(((String)datas.get(2)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    salaryDetailVO.setErrorMessage("\u961f\u4f0d\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(3)).length() > 20) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u961f\u4f0d\u540d\u79f0\u957f\u5ea6\u4e3a1~20\u5b57");
                } else {
                    salaryDetailVO.setTeamName(((String)datas.get(3)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    salaryDetailVO.setErrorMessage("\u73ed\u7ec4\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(4)).length() > 20) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u73ed\u7ec4\u540d\u79f0\u957f\u5ea6\u4e3a1~20\u5b57");
                } else {
                    salaryDetailVO.setGroupName(((String)datas.get(4)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    try {
                        salaryDetailVO.setPersonalWorkingDayOfMonth(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u4e2a\u4eba\u5de5\u65e5\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    salaryDetailVO.setErrorMessage("\u4e2a\u4eba\u5de5\u65e5\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    salaryDetailVO.setErrorMessage("\u8ba1\u91cf\u65b9\u5f0f\u4e3a\u5fc5\u586b\u9879");
                } else {
                    switch ((String)datas.get(6)) {
                        case "\u6309\u5929": {
                            salaryDetailVO.setMeasureType(Integer.valueOf(0));
                            break;
                        }
                        case "\u8ba1\u4ef6": {
                            salaryDetailVO.setMeasureType(Integer.valueOf(1));
                            break;
                        }
                        case "\u6309\u5c0f\u65f6": {
                            salaryDetailVO.setMeasureType(Integer.valueOf(2));
                            break;
                        }
                        case "\u6309\u6708": {
                            salaryDetailVO.setMeasureType(Integer.valueOf(3));
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        salaryDetailVO.setWorkNum(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u5de5\u4f5c\u91cf\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    salaryDetailVO.setErrorMessage("\u5de5\u4f5c\u91cf\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    try {
                        salaryDetailVO.setPrice(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u5355\u4ef7\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    salaryDetailVO.setErrorMessage("\u5355\u4ef7\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    try {
                        salaryDetailVO.setWorkingDayOfMonth(new BigDecimal((String)datas.get(9)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u73ed\u7ec4\u5de5\u65e5\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    salaryDetailVO.setErrorMessage("\u73ed\u7ec4\u5de5\u65e5\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    try {
                        salaryDetailVO.setTotalSalary(new BigDecimal((String)datas.get(10)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u5de5\u8d44\u603b\u989d\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    salaryDetailVO.setErrorMessage("\u5de5\u8d44\u603b\u989d\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                    try {
                        salaryDetailVO.setOtherDeduct(new BigDecimal((String)datas.get(11)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u5176\u4ed6\u6263\u6b3e\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12)))) {
                    try {
                        salaryDetailVO.setAward(new BigDecimal((String)datas.get(12)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u5956\u52b1\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13)))) {
                    try {
                        salaryDetailVO.setApprovalSalaryMny(new BigDecimal((String)datas.get(13)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u6838\u5b9a\u5de5\u8d44\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    salaryDetailVO.setErrorMessage("\u6838\u5b9a\u5de5\u8d44\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14)))) {
                    try {
                        salaryDetailVO.setDeductMny(new BigDecimal((String)datas.get(14)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u9884\u652f\u5de5\u8d44\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15)))) {
                    try {
                        salaryDetailVO.setSalaryMny(new BigDecimal((String)datas.get(15)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u5e94\u53d1\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    salaryDetailVO.setErrorMessage("\u5e94\u53d1\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(16)))) {
                    try {
                        salaryDetailVO.setProposedPaymentMny(new BigDecimal((String)datas.get(16)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u62df\u652f\u4ed8\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    salaryDetailVO.setProposedPaymentMny(BigDecimal.ZERO);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(17)))) {
                    salaryDetailVO.setErrorMessage("\u94f6\u884c\u5361\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(17)).trim().length() > 19) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u94f6\u884c\u5361\u53f7\u957f\u5ea6\u6700\u5927\u4e3a19\u4f4d");
                } else {
                    salaryDetailVO.setAccountNum(((String)datas.get(17)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(18)))) {
                    salaryDetailVO.setErrorMessage("\u5f00\u6237\u884c\u957f\u5ea6\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(18)).length() > 30) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u5f00\u6237\u884c\u957f\u5ea6\u4e3a0~30\u5b57");
                } else {
                    salaryDetailVO.setBankName(((String)datas.get(18)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(19)))) {
                    salaryDetailVO.setErrorMessage("\u5f00\u6237\u884c\u7701\u4efd\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(19)).length() > 50) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u5f00\u6237\u884c\u7701\u4efd\u957f\u5ea6\u4e3a0~50\u5b57");
                } else {
                    salaryDetailVO.setBankProvince(((String)datas.get(19)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(20)))) {
                    if (((String)datas.get(20)).length() > 500) {
                        salaryDetailVO.setErrorMessage("\u8054\u884c\u53f7\u957f\u5ea6\u4e3a0~500\u5b57");
                    } else {
                        salaryDetailVO.setInterBankNum(((String)datas.get(20)).trim());
                    }
                }
                if (((String)datas.get(21)).length() > 100) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u5907\u6ce8\u957f\u5ea6\u4e3a0~100\u5b57");
                }
                salaryDetailVO.setMemo((String)datas.get(21));
                if (StringUtils.isBlank((CharSequence)salaryDetailVO.getErrorMessage())) {
                    successList.add(salaryDetailVO);
                    continue;
                }
                errorList.add(salaryDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    private boolean checkSameBillCode(SalaryVO salaryVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SalaryEntity::getBillCode, (Object)salaryVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != salaryVO.getId() && salaryVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)salaryVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }
}

