package com.ejianc.business.profinance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 工人工资单子实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_profinance_salary_detail")
public class SalaryDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="salary_id")
    private Long salaryId; // 工人工资单主表id
    @TableField(value="salary_bill_code")
    private String salaryBillCode; // 工人工资单主表单据编码
    @TableField(value="worker_id")
    private Long workerId; // 工人id
    @TableField(value="worker_name")
    private String workerName; // 工人
    @TableField(value="work_type_code")
    private String workTypeCode; // 工种编码
    @TableField(value="work_type")
    private String workType; // 工种
    @TableField(value="worker_id_card")
    private String workerIdCard; // 工人身份证号（已脱敏）
    @TableField(value="worker_id_card_sensitive")
    private String workerIdCardSensitive; // 工人身份证号（未脱敏）
    @TableField(value="team_id")
    private Long teamId; // 队伍id
    @TableField(value="team_code")
    private String teamCode; // 队伍编码
    @TableField(value="team_name")
    private String teamName; // 队伍名称
    @TableField(value="group_id")
    private Long groupId; // 班组id
    @TableField(value="group_code")
    private String groupCode; // 班组编码
    @TableField(value="group_name")
    private String groupName; // 班组名称
    @TableField(value="measure_type")
    private Integer measureType; // 计量方式 （0:计日，1计件 2：按小时 3：按月）
    @TableField(value="work_num")
    private BigDecimal workNum; // 工作量
    @TableField(value="work_day_count")
    private BigDecimal workDayCount; // 系统出勤日
    @TableField(value="working_day_of_month")
    private BigDecimal workingDayOfMonth; // 工日
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="deduct_mny")
    private BigDecimal deductMny; // 借扣款费用--改为预支工资
    @TableField(value="award")
    private BigDecimal award; // 奖励
    @TableField(value="salary_mny")
    private BigDecimal salaryMny; // 工资总额：工作量*单价+奖励-借扣款
    @TableField(value="actual_salary_mny")
    private BigDecimal actualSalaryMny; // 实发工资
    @TableField(value="actual_price")
    private BigDecimal actualPrice; // 实际单价
    @TableField(value="payday")
    private Date payday; // 发放（工资）日期
    @TableField(value="account_id")
    private Long accountId; // 银行账户id
    @TableField(value="account_num")
    private String accountNum; // 银行账/卡号
    @TableField(value="account_name")
    private String accountName; // 账户名称
    @TableField(value="bank_name")
    private String bankName; // 开户行
    @TableField(value="bank_province")
    private String bankProvince; // 开户行省份
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="source_id")
    private Long sourceId; // 单据来源id
    @TableField(value="source_type")
    private Integer sourceType; // 数据来源方式 （0-同步劳务实名系统新增 1-直接新增）
    @TableField(value="source_salary_id")
    private Long sourceSalaryId; // 来源单据的主表id
    @TableField(value = "belong_month")
    private Date belongMonth; // 所属年月
    @TableField(value = "worker_remainder_tax_mny")
    private BigDecimal workerRemainderTaxMny; // 欠发金额（剩余可发金额）
    @TableField(value = "total_salary")
    private BigDecimal totalSalary; // 工资总额
    @TableField(value = "personal_working_day_of_month")
    private BigDecimal personalWorkingDayOfMonth; // 个人工日
    @TableField(value = "approval_salary_mny")
    private BigDecimal approvalSalaryMny; // 核定工资金额=核定工资=工资总额-其他扣款+奖励
    @TableField(value = "other_deduct")
    private BigDecimal otherDeduct; // 其他扣款
    @TableField(value = "owe_salary_mny")
    private BigDecimal oweSalaryMny; // 欠发 = 应发-实发
    @TableField(value="inter_bank_num")
    private String interBankNum; // 联行号
    @TableField(value="glodon_project_id")
    private Long glodonProjectId; // 一建广联达项目id
    @TableField(value="glodon_project_name")
    private String glodonProjectName; // 一建广联达项目名称
    @TableField(value = "proposed_payment_mny")
    private BigDecimal proposedPaymentMny; // 拟支付金额
    @TableField(value = "worker_phone")
    private String workerPhone; //电话号码


    public Long getSalaryId() {
        return salaryId;
    }

    public void setSalaryId(Long salaryId) {
        this.salaryId = salaryId;
    }

    public String getSalaryBillCode() {
        return salaryBillCode;
    }

    public void setSalaryBillCode(String salaryBillCode) {
        this.salaryBillCode = salaryBillCode;
    }

    public Long getWorkerId() {
        return workerId;
    }

    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }
    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }
    public String getWorkTypeCode() {
        return workTypeCode;
    }

    public void setWorkTypeCode(String workTypeCode) {
        this.workTypeCode = workTypeCode;
    }
    public String getWorkType() {
        return workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }
    public String getWorkerIdCard() {
        return workerIdCard;
    }

    public void setWorkerIdCard(String workerIdCard) {
        this.workerIdCard = workerIdCard;
    }
    public String getWorkerIdCardSensitive() {
        return workerIdCardSensitive;
    }

    public void setWorkerIdCardSensitive(String workerIdCardSensitive) {
        this.workerIdCardSensitive = workerIdCardSensitive;
    }
    public Long getTeamId() {
        return teamId;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }
    public String getTeamCode() {
        return teamCode;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }
    public String getGroupCode() {
        return groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }
    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
    public Integer getMeasureType() {
        return measureType;
    }

    public void setMeasureType(Integer measureType) {
        this.measureType = measureType;
    }
    public BigDecimal getWorkNum() {
        return workNum;
    }

    public void setWorkNum(BigDecimal workNum) {
        this.workNum = workNum;
    }
    public BigDecimal getWorkDayCount() {
        return workDayCount;
    }

    public void setWorkDayCount(BigDecimal workDayCount) {
        this.workDayCount = workDayCount;
    }
    public BigDecimal getWorkingDayOfMonth() {
        return workingDayOfMonth;
    }

    public void setWorkingDayOfMonth(BigDecimal workingDayOfMonth) {
        this.workingDayOfMonth = workingDayOfMonth;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getDeductMny() {
        return deductMny;
    }

    public void setDeductMny(BigDecimal deductMny) {
        this.deductMny = deductMny;
    }
    public BigDecimal getAward() {
        return award;
    }

    public void setAward(BigDecimal award) {
        this.award = award;
    }
    public BigDecimal getSalaryMny() {
        return salaryMny;
    }

    public void setSalaryMny(BigDecimal salaryMny) {
        this.salaryMny = salaryMny;
    }
    public BigDecimal getActualSalaryMny() {
        return actualSalaryMny;
    }

    public void setActualSalaryMny(BigDecimal actualSalaryMny) {
        this.actualSalaryMny = actualSalaryMny;
    }
    public BigDecimal getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(BigDecimal actualPrice) {
        this.actualPrice = actualPrice;
    }
    public Date getPayday() {
        return payday;
    }

    public void setPayday(Date payday) {
        this.payday = payday;
    }
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getBankProvince() {
        return bankProvince;
    }

    public void setBankProvince(String bankProvince) {
        this.bankProvince = bankProvince;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceSalaryId() {
        return sourceSalaryId;
    }

    public void setSourceSalaryId(Long sourceSalaryId) {
        this.sourceSalaryId = sourceSalaryId;
    }

    public Date getBelongMonth() {
        return belongMonth;
    }

    public void setBelongMonth(Date belongMonth) {
        this.belongMonth = belongMonth;
    }

    public BigDecimal getWorkerRemainderTaxMny() {
        return workerRemainderTaxMny;
    }

    public void setWorkerRemainderTaxMny(BigDecimal workerRemainderTaxMny) {
        this.workerRemainderTaxMny = workerRemainderTaxMny;
    }

    public BigDecimal getTotalSalary() {
        return totalSalary;
    }

    public void setTotalSalary(BigDecimal totalSalary) {
        this.totalSalary = totalSalary;
    }

    public BigDecimal getPersonalWorkingDayOfMonth() {
        return personalWorkingDayOfMonth;
    }

    public void setPersonalWorkingDayOfMonth(BigDecimal personalWorkingDayOfMonth) {
        this.personalWorkingDayOfMonth = personalWorkingDayOfMonth;
    }

    public BigDecimal getApprovalSalaryMny() {
        return approvalSalaryMny;
    }

    public void setApprovalSalaryMny(BigDecimal approvalSalaryMny) {
        this.approvalSalaryMny = approvalSalaryMny;
    }

    public BigDecimal getOtherDeduct() {
        return otherDeduct;
    }

    public void setOtherDeduct(BigDecimal otherDeduct) {
        this.otherDeduct = otherDeduct;
    }

    public BigDecimal getOweSalaryMny() {
        return oweSalaryMny;
    }

    public void setOweSalaryMny(BigDecimal oweSalaryMny) {
        this.oweSalaryMny = oweSalaryMny;
    }

    public String getInterBankNum() {
        return interBankNum;
    }

    public void setInterBankNum(String interBankNum) {
        this.interBankNum = interBankNum;
    }

    public Long getGlodonProjectId() {
        return glodonProjectId;
    }

    public void setGlodonProjectId(Long glodonProjectId) {
        this.glodonProjectId = glodonProjectId;
    }

    public String getGlodonProjectName() {
        return glodonProjectName;
    }

    public void setGlodonProjectName(String glodonProjectName) {
        this.glodonProjectName = glodonProjectName;
    }

    public BigDecimal getProposedPaymentMny() {
        return proposedPaymentMny;
    }

    public void setProposedPaymentMny(BigDecimal proposedPaymentMny) {
        this.proposedPaymentMny = proposedPaymentMny;
    }

    public String getWorkerPhone() {
        return workerPhone;
    }

    public void setWorkerPhone(String workerPhone) {
        this.workerPhone = workerPhone;
    }
}
