/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.SalaryEntity;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.profinance.service.ISalaryService;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.profinance.vo.SalaryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/salaryApi/"})
public class SalaryApi
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISalaryService service;
    @Autowired
    private ISalaryPayApplyService salaryPayApplyService;

    @GetMapping(value={"salaryApplyInfoByContractId"})
    public CommonResponse<ContractPaymentResultVO> querySalaryApplyInfoByContractId(@RequestParam Long contractId) {
        ContractPaymentResultVO resp = new ContractPaymentResultVO();
        StringBuilder sql = new StringBuilder();
        sql.append("id as id, bill_code as billCode, bill_state as billState, ").append("org_id as orgId, org_code as orgCode, org_name as orgName, ").append("parent_org_id as parentOrgId, parent_org_code as parentOrgCode, parent_org_name as parentOrgName, ").append("contract_id as contractId, contract_name as contractName, contract_code as contractName, ").append("contract_category_id as contractCategoryId, contract_category_name as contractCategoryName, ").append("project_id as projectId, project_code as projectCode, project_name as projectName, ").append("apply_date as applyDate, memo as memo, pay_reason as paymentReason, ").append("apply_tax_mny as applyMny,apply_tax_mny as approvalMny, actual_paid_tax_mny as actualMny, 5 as paymentType, 1 as paymentContractFlag, apply_name as employeeName");
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.select(new String[]{sql.toString()});
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        listQuery.eq((Object)"is_repeat_bill", (Object)0);
        listQuery.orderByDesc((Object[])new String[]{"pay_date", "create_time"});
        List salaryPayList = BeanMapper.mapList((Iterable)this.salaryPayApplyService.listMaps((Wrapper)listQuery), PaymentApplyVO.class);
        QueryWrapper countQuery = new QueryWrapper();
        countQuery.select(new String[]{sql.toString()});
        countQuery.select(new String[]{"sum(apply_tax_mny) as totalApplyTaxMny, sum(apply_tax_mny) as totalApproveTaxMny, sum(ifnull(actual_paid_tax_mny,0)) as totalPaidTaxMny, contract_tax_mny as contractTaxMny, contract_id as contractId"});
        countQuery.eq((Object)"contract_id", (Object)contractId);
        countQuery.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        countQuery.eq((Object)"is_repeat_bill", (Object)0);
        Map countMap = this.salaryPayApplyService.getMap((Wrapper)countQuery);
        resp.setContractId(contractId);
        resp.setTotalActualMny(BigDecimal.ZERO);
        resp.setTotalApplyMny(BigDecimal.ZERO);
        resp.setTotalApprovalMny(BigDecimal.ZERO);
        resp.setPaymentRate(BigDecimal.ZERO);
        resp.setPaymentApplyList(salaryPayList);
        if (null != countMap) {
            if (null != countMap.get("totalApplyTaxMny")) {
                resp.setTotalApplyMny(new BigDecimal(countMap.get("totalApplyTaxMny").toString()));
            }
            if (null != countMap.get("totalApproveTaxMny")) {
                resp.setTotalApprovalMny(new BigDecimal(countMap.get("totalApproveTaxMny").toString()));
            }
            if (null != countMap.get("totalPaidTaxMny")) {
                resp.setTotalActualMny(new BigDecimal(countMap.get("totalPaidTaxMny").toString()));
            }
            if (null != countMap.get("contractTaxMny")) {
                resp.setContractTaxMny(new BigDecimal(countMap.get("contractTaxMny").toString()));
            }
            resp.setPaymentRate(resp.getTotalActualMny().divide(resp.getContractTaxMny(), 8, 5).multiply(new BigDecimal(100)));
        }
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"querySalaryList"})
    CommonResponse<List<SalaryVO>> querySalaryList(@RequestParam(value="contractId") Long contractId, @RequestParam(value="settleType") Integer settleType, @RequestParam(value="settleDate") String settleDate) {
        this.logger.info("\u67e5\u8be2\u5de5\u4eba\u5de5\u8d44\u5355\u6761\u4ef6\uff1acontractId - ", (Object)contractId);
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        if (0 == settleType) {
            listQuery.le((Object)"belong_month", (Object)settleDate);
            listQuery.isNull((Object)"settle_id");
        }
        listQuery.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        listQuery.orderByDesc((Object)"belong_month");
        List salaryEntityList = this.service.list((Wrapper)listQuery);
        List salaryVOList = BeanMapper.mapList((Iterable)salaryEntityList, SalaryVO.class);
        this.logger.info("\u67e5\u8be2\u5de5\u4eba\u5de5\u8d44\u5355\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)salaryVOList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return CommonResponse.success((String)"\u67e5\u8be2\u5de5\u4eba\u5de5\u8d44\u5355\u5355\u6210\u529f\uff01", (Object)salaryVOList);
    }

    @PostMapping(value={"writeSalarySettleId"})
    CommonResponse<String> writeSalarySettleId(@RequestParam(value="salaryIds") List<Long> salaryIds, @RequestParam(value="settleId", required=false) String settleId) {
        this.logger.info("\u67e5\u8be2\u5de5\u4eba\u5de5\u8d44\u5355\u5217\u8868\u6761\u4ef6\uff1asalaryIds - {}", (Object)JSONObject.toJSONString(salaryIds));
        this.logger.info("\u67e5\u8be2\u5de5\u4eba\u5de5\u8d44\u5355\u5217\u8868\u6761\u4ef6\uff1asettleId - {}", (Object)settleId);
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.in((Object)"id", salaryIds);
        List salaryEntityList = this.service.list((Wrapper)listQuery);
        if (CollectionUtils.isNotEmpty((Collection)salaryEntityList)) {
            for (SalaryEntity salaryEntity : salaryEntityList) {
                if (StringUtils.isBlank((CharSequence)settleId)) {
                    salaryEntity.setSettleId(null);
                    continue;
                }
                salaryEntity.setSettleId(Long.valueOf(settleId));
            }
        }
        this.service.saveOrUpdateBatch(salaryEntityList);
        return CommonResponse.success((String)("\u56de\u5199\u5de5\u4eba\u5de5\u8d44\u5355\u7ed3\u7b97id\u6210\u529f\uff0c\u5de5\u4eba\u5de5\u8d44\u5355\u6761\u6570\uff1a" + salaryEntityList.size() + ""));
    }
}

