/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.mapper.SalaryDetailMapper;
import com.ejianc.business.profinance.mapper.SalaryPayApplyDetailMapper;
import com.ejianc.business.profinance.service.IPayrollRegisterService;
import com.ejianc.business.profinance.service.ISalaryDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="salaryPayApplyDetailService")
public class SalaryPayApplyDetailServiceImpl
extends BaseServiceImpl<SalaryPayApplyDetailMapper, SalaryPayApplyDetailEntity>
implements ISalaryPayApplyDetailService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SalaryPayApplyDetailMapper payApplyDetailMapper;
    @Autowired
    ISalaryPayApplyService salaryPayApplyService;
    @Autowired
    ISalaryDetailService salaryDetailService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private SalaryDetailMapper salaryDetailMapper;
    @Autowired
    private IPayrollRegisterService payrollRegisterService;

    @Override
    public void updatePayStateByIds(List<Long> idList, Integer payState, Date payDate) {
        this.payApplyDetailMapper.updatePayStateByIds(idList, payState, payDate);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirmPayResult(List<SalaryPayApplyDetailVO> detailVOList) {
        ArrayList<SalaryPayApplyEntity> mainEntityUpdateList = new ArrayList<SalaryPayApplyEntity>();
        ArrayList<SalaryPayApplyDetailEntity> subEntityUpdateList = new ArrayList<SalaryPayApplyDetailEntity>();
        SalaryPayApplyEntity oldMainEntity = null;
        ArrayList<Long> oldIds = new ArrayList<Long>();
        SalaryPayApplyEntity mainEntity = (SalaryPayApplyEntity)((Object)this.salaryPayApplyService.selectById(detailVOList.get(0).getPid()));
        BigDecimal curTotalActualPaidTaxMny = mainEntity.getActualPaidTaxMny();
        BigDecimal curTotalActualPaidTMny = mainEntity.getActualPaidMny();
        BigDecimal curTotalActualPaidTax = mainEntity.getActualPaidTax();
        if (null == curTotalActualPaidTaxMny) {
            curTotalActualPaidTaxMny = BigDecimal.ZERO;
        }
        if (null == curTotalActualPaidTMny) {
            curTotalActualPaidTMny = BigDecimal.ZERO;
        }
        if (null == curTotalActualPaidTax) {
            curTotalActualPaidTax = BigDecimal.ZERO;
        }
        Integer workerPayState = detailVOList.get(0).getWorkerPayState();
        Date workerPayDate = detailVOList.get(0).getWorkerPayDate();
        Integer isRepeatBill = detailVOList.get(0).getWorkerIsRepeatBill();
        Long pid = detailVOList.get(0).getPid();
        List<Long> ids = detailVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", ids);
        List salaryPayApplyDetailEntityList = this.payApplyDetailMapper.selectList((Wrapper)wrapper);
        HashMap<String, SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityMap = new HashMap<String, SalaryPayApplyDetailEntity>();
        HashMap<String, SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityMapOld = new HashMap<String, SalaryPayApplyDetailEntity>();
        if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailEntityList)) {
            for (SalaryPayApplyDetailEntity item : salaryPayApplyDetailEntityList) {
                if (item.getIdOld() != null) {
                    salaryPayApplyDetailEntityMapOld.put(item.getIdOld().toString(), item);
                }
                if (workerPayState == 1) {
                    BigDecimal workerApplyTaxMny = item.getWorkerApplyTaxMny();
                    workerApplyTaxMny = workerApplyTaxMny == null ? BigDecimal.ZERO : workerApplyTaxMny;
                    item.setWorkerActualPaidTaxMny(workerApplyTaxMny);
                    item.setWorkerActualPaidMny(workerApplyTaxMny);
                    item.setWorkerActualPaidTax(BigDecimal.ZERO);
                    curTotalActualPaidTaxMny = curTotalActualPaidTaxMny.add(item.getWorkerActualPaidTaxMny());
                    curTotalActualPaidTMny = curTotalActualPaidTMny.add(item.getWorkerActualPaidMny());
                    curTotalActualPaidTax = curTotalActualPaidTax.add(item.getWorkerActualPaidTax());
                    item.setWorkerPayDate(workerPayDate);
                }
                item.setWorkerPayState(workerPayState);
                subEntityUpdateList.add(item);
                salaryPayApplyDetailEntityMap.put(item.getId().toString(), item);
            }
            mainEntity.setActualPaidTaxMny(curTotalActualPaidTaxMny);
            mainEntity.setActualPaidMny(curTotalActualPaidTMny);
            mainEntity.setActualPaidTax(curTotalActualPaidTax);
            mainEntityUpdateList.add(mainEntity);
            if (workerPayState == 1) {
                SalaryPayApplyVO generatePayrollRegisterVO = (SalaryPayApplyVO)BeanMapper.map((Object)((Object)mainEntity), SalaryPayApplyVO.class);
                generatePayrollRegisterVO.setSalaryList(BeanMapper.mapList((Iterable)salaryPayApplyDetailEntityList, SalaryPayApplyDetailVO.class));
                generatePayrollRegisterVO.setContractCode(mainEntity.getContractCode());
                generatePayrollRegisterVO.setContractId(mainEntity.getContractId());
                BigDecimal actualTotalPaidTaxMny = BigDecimal.ZERO;
                List salaryPayApplyDetailVOList = generatePayrollRegisterVO.getSalaryList();
                ArrayList<SalaryPayApplyDetailVO> generatePayrollRegisterDetailVOList = new ArrayList<SalaryPayApplyDetailVO>();
                if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailVOList)) {
                    for (SalaryPayApplyDetailVO salaryPayApplyDetail : salaryPayApplyDetailVOList) {
                        if (!ids.contains(salaryPayApplyDetail.getId())) continue;
                        actualTotalPaidTaxMny = actualTotalPaidTaxMny.add(salaryPayApplyDetail.getWorkerActualPaidTaxMny());
                        generatePayrollRegisterDetailVOList.add(salaryPayApplyDetail);
                    }
                }
                generatePayrollRegisterVO.setSalaryList(generatePayrollRegisterDetailVOList);
                this.payrollRegisterService.generatePayrollRegister(generatePayrollRegisterVO, actualTotalPaidTaxMny);
                this.salaryDetailService.writeBackSalaryDetail(generatePayrollRegisterDetailVOList);
            }
        }
        if (isRepeatBill == 1) {
            List idsOld = detailVOList.stream().map(SalaryPayApplyDetailVO::getIdOld).collect(Collectors.toList());
            QueryWrapper wrapperOld = new QueryWrapper();
            wrapperOld.in((Object)"id", idsOld);
            List salaryPayApplyDetailEntityListOld = this.payApplyDetailMapper.selectList((Wrapper)wrapperOld);
            if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailEntityListOld)) {
                oldMainEntity = (SalaryPayApplyEntity)((Object)this.salaryPayApplyService.selectById(detailVOList.get(0).getPid()));
                BigDecimal oldTotalActualPaidTaxMny = oldMainEntity.getActualPaidTaxMny();
                BigDecimal oldTotalActualPaidTMny = oldMainEntity.getActualPaidMny();
                BigDecimal oldTotalActualPaidTax = oldMainEntity.getActualPaidTax();
                if (null == oldTotalActualPaidTaxMny) {
                    oldTotalActualPaidTaxMny = BigDecimal.ZERO;
                }
                if (null == oldTotalActualPaidTMny) {
                    oldTotalActualPaidTMny = BigDecimal.ZERO;
                }
                if (null == oldTotalActualPaidTax) {
                    oldTotalActualPaidTax = BigDecimal.ZERO;
                }
                for (SalaryPayApplyDetailEntity item : salaryPayApplyDetailEntityListOld) {
                    SalaryPayApplyDetailEntity salaryPayApplyDetailEntity = (SalaryPayApplyDetailEntity)((Object)salaryPayApplyDetailEntityMapOld.get(item.getId().toString()));
                    if (salaryPayApplyDetailEntity == null) continue;
                    BigDecimal workerApplyTaxMny = salaryPayApplyDetailEntity.getWorkerApplyTaxMny();
                    workerApplyTaxMny = workerApplyTaxMny == null ? BigDecimal.ZERO : workerApplyTaxMny;
                    item.setWorkerApplyTaxMny(workerApplyTaxMny);
                    Integer workerPayState1 = salaryPayApplyDetailEntity.getWorkerPayState();
                    if (workerPayState1 == 1) {
                        item.setWorkerPayState(1);
                    }
                    item.setWorkerActualPaidTaxMny(salaryPayApplyDetailEntity.getWorkerActualPaidTaxMny());
                    item.setWorkerActualPaidMny(salaryPayApplyDetailEntity.getWorkerActualPaidMny());
                    item.setWorkerActualPaidTax(salaryPayApplyDetailEntity.getWorkerApplyTax());
                    subEntityUpdateList.add(item);
                    oldIds.add(item.getId());
                    oldTotalActualPaidTaxMny = curTotalActualPaidTaxMny.add(item.getWorkerActualPaidTaxMny());
                    oldTotalActualPaidTMny = curTotalActualPaidTMny.add(item.getWorkerActualPaidMny());
                    oldTotalActualPaidTax = curTotalActualPaidTax.add(item.getWorkerActualPaidTax());
                }
                oldMainEntity.setActualPaidTaxMny(oldTotalActualPaidTaxMny);
                oldMainEntity.setActualPaidMny(oldTotalActualPaidTMny);
                oldMainEntity.setActualPaidTax(oldTotalActualPaidTax);
                mainEntityUpdateList.add(oldMainEntity);
            }
        }
        this.judgeIfAllSalaryApplyDetailPaid(mainEntity, ids, workerPayState);
        if (mainEntity.getIsRepeatBill() == 1) {
            this.judgeIfAllSalaryApplyDetailPaid(oldMainEntity, oldIds, workerPayState);
        }
        if (CollectionUtils.isNotEmpty(mainEntityUpdateList)) {
            this.salaryPayApplyService.saveOrUpdateBatch(mainEntityUpdateList, mainEntityUpdateList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(subEntityUpdateList)) {
            super.saveOrUpdateBatch(subEntityUpdateList, subEntityUpdateList.size(), false);
        }
    }

    private void judgeIfAllSalaryApplyDetailPaid(SalaryPayApplyEntity mainEntity, List<Long> ids, Integer payState) {
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"sum( IF ( worker_pay_state = 0, 1, 0 ) ) AS totalWaitNum, sum( IF ( worker_pay_state = 1, 1,0 ) ) AS totalSucNum, sum( IF ( worker_pay_state = 3, 1,0 ) ) AS totalFailNum"});
        query.eq((Object)"pid", (Object)mainEntity.getId());
        query.notIn((Object)"id", ids);
        Map payStateNum = super.getMap((Wrapper)query);
        Integer totalWaitNum = null != payStateNum && null != payStateNum.get("totalWaitNum") ? Integer.valueOf(payStateNum.get("totalWaitNum").toString()) : 0;
        Integer totalSucNum = null != payStateNum && null != payStateNum.get("totalSucNum") ? Integer.valueOf(payStateNum.get("totalSucNum").toString()) : 0;
        Integer totalFailNum = null != payStateNum && null != payStateNum.get("totalFailNum") ? Integer.valueOf(payStateNum.get("totalFailNum").toString()) : 0;
        Integer curPayState = totalWaitNum > 0 || payState == 1 && totalFailNum == 0 || payState == 3 && totalSucNum > 0 ? 2 : payState;
        mainEntity.setPayState(curPayState);
    }

    @Override
    public List<SalaryPayApplyDetailEntity> queryByPid(Long pid) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"pid", (Object)pid)).eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return this.payApplyDetailMapper.selectList((Wrapper)wrapper);
    }
}

