package com.ejianc.business.profinance.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.business.profinance.bean.PMPayEntity;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.common.enums.BillHandleTypeEnum;
import com.ejianc.business.profinance.common.service.IBillHandleResultService;
import com.ejianc.business.profinance.common.service.ICommonBillHandleResultService;
import com.ejianc.business.profinance.common.vo.BillHandleResultVO;
import com.ejianc.business.profinance.enums.PaymentTypeEnum;
import com.ejianc.business.profinance.mapper.PMPayMapper;
import com.ejianc.business.profinance.service.IPMPayService;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.vo.PMPayVO;
import com.ejianc.business.profinance.vo.PaymentRegisterVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.tradematerial.finance.api.IPayMentApi;
import com.ejianc.business.tradematerial.finance.vo.IncomeRegisterVO;
import com.ejianc.business.tradematerial.finance.vo.PaymentApplyVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.*;

/**
 * PM支付主实体
 *
 * @author generator
 */
@Service("pMPayService")
public class PMPayServiceImpl extends BaseServiceImpl<PMPayMapper, PMPayEntity> implements IPMPayService, ICommonBillHandleResultService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private IPaymentApplyService paymentApplyService;

    @Autowired
    private IPMPayApplyApi pmPayApplyApi;

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private IPaymentRegisterService registerService;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IBillHandleResultService billHandleResultService;

    @Autowired
    private IPayMentApi payMentApi;

    private final String OPERATE = "PROFINANCE_PAY_RESULT";
    private long retryInterval = 5000;
    private final int maxRetryTime = 10;
    private static final String REGISTER_BILL_CODE = "PAYMENT_REGISTER";//此处需要根据实际修改

    private final String tenantRootAuth = "TENANT_ROOT_AUTH::";

    @Override
    public void sendMessage(PMPayVO pmPayVO) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody(pmPayVO);
        logger.info("接收一建财务系统的付款信息：{}", JSONObject.toJSONString(pmPayVO));
        rabbitTemplate.convertAndSend(PMPayVO.PAY_RESULT_MESSAGE, mqMessage);
    }

    @Override
    public boolean recordBillHandleResult(BillHandleResultVO billHandleResultVO) {
        logger.info("从队列中收到支付通知单结果信息：{}", JSONObject.toJSONString(billHandleResultVO));
        //只处理失败的，因为成功的状态在核销成功后会直接更新
        if(BillHandleResultVO.HANDLE_CODE_FAIL.equals(billHandleResultVO.getHandleResultCode())) {
            PMPayVO pmPayVO = JSONObject.parseObject(billHandleResultVO.getBillDataJson(), PMPayVO.class);
            PMPayEntity entity = selectById(pmPayVO.getId());
            logger.info("根据预核销数据-{} 查询到匹配的待核销记录-{}", billHandleResultVO.getBillDataJson(), null != entity ? JSONObject.toJSONString(entity) : null);
            entity.setPaidFlag(PMPayVO.PAID_FLAG_HANDLE_FAIL);
            entity.setPayResultMessage(billHandleResultVO.getHandleResultMsg());

            super.saveOrUpdate(entity, false);
        }

        return true;
    }

    /**
     * 获取用户登录信息
     *
     * @param tenantId
     * @return
     */
    public String getAuthority(Long tenantId) {
        String authority = cacheManager.get(tenantRootAuth + tenantId.toString());

        if(StringUtils.isBlank(authority)) {
            try {
                Map<String, Object> params = new HashMap<>();
                params.put("tenantId", tenantId);
                logger.info("baseHost " + BASE_HOST);

                Map<String, String> headers = new HashMap<>();
                headers.put("Content-Type", "application/json;charset=UTF-8");

                String back = HttpTookit.get(BASE_HOST + "ejc-idm-web/user/context/getBytenantid", params, headers);
                JSONObject jsonBack = JSONObject.parseObject(back);
                if (jsonBack.get("data") != null) {
                    JSONObject data = (JSONObject) jsonBack.get("data");
                    logger.info("data  " + data.toJSONString());
                    if (data.get("userContext") != null) {
                        JSONObject userContext = (JSONObject) data.get("userContext");
                        authority = "userType=" + userContext.getString("userType") + ";userCode="
                                + userContext.getString("userCode") +
                                ";orgId=" + userContext.getString("orgId") +
                                ";tenantid=" + userContext.getString("tenantid") + ";token="
                                + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints")
                                + ";u_usercode=" + userContext.getString("u_usercode") + ";userId="
                                + userContext.getString("userId");

                        cacheManager.setex(tenantRootAuth + tenantId.toString(), authority, 25 * 60);
                    }
                }
            } catch (Exception e) {
                logger.error("模拟登录异常: ", e);
                return null;
            }
        }
        return authority;
    }

    /**
     * @param payResultMsg 财务付款/退款通知单
     *    处理逻辑：
     *      1、按照合同Id、项目Id、供应商Id、收款方Id四个字段作为维度，查询对应的付款申请单；
     *        其中若为付款核销时，则按照申请单申请时间正序查询；若为退款处理，则按照付款申请单申请时间，倒序查询已做付款的申请单；
     *      2、若有匹配的付款申请单，则执行核销/退款操作，当待分配金额为0时，推出循环，更新涉及到的付款单
     *      3、将本次付款核销/退款生成付款登记记录
     *      4、记录本次通知单处理结果
     *
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handPayResult(String payResultMsg) {
        logger.info("从消息队列中获取到待处理的付款结果：{}", payResultMsg);
        PMPayVO payResultVO = JSONObject.parseObject(payResultMsg, PMPayVO.class);

        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append("一建财务付款结果通知单：[id-").append(payResultVO.getId()).append("]中间表核销处理");

        logger.info("处理付款数据-{}前加锁", JSONObject.toJSONString(payResultVO));
        // 根据数据维度获取锁，维度：项目ID、供应商ID、合同登记ID、收款单位ID
        String redisKey = payResultVO.getProjectId() + "::" + payResultVO.getSupplyId() + "::" + payResultVO.getContractId() + "::" + payResultVO.getPayeeId();
        logger.info("对保存操作添加Redis锁，redisKey-{}", redisKey);

        Jedis jedis = jedisPool.getResource();
        logger.info("从jedisPool获取jedis对象，jedis对象-{}", jedis);
        boolean lock = getLock(redisKey, jedis);
        if(!lock) {
            logger.info("键-{}尝试获取锁失败,将付款结果-{}重新放入队列进行处理", redisKey, payResultMsg);
            sendMessage(payResultVO);
            return;
        }

        try {
            //通过四个维度 和 实际支付金额大于申请金额 筛选出对应的付款申请单，按申请时间正序排列
            //四个维度项目id、合同id、供应商id、收款单位id
            if (null != payResultVO) {
                QueryParam registerQuery = new QueryParam();
                QueryWrapper<PaymentApplyEntity> listQuery = new QueryWrapper<>();
                logger.info("调用PM付款申请的核销接口---ejc-profinance项目---payResultServiceImpl类---handPayResult方法---begin------------->");

                logger.info("通过付款结果四个维度 项目id-projectId {}，合同id-contractId {}，" +
                        "供应商id-supplierId {}，收款单位id-payeeId {} 查询对应的付款申请。", payResultVO.getProjectId(), payResultVO.getContractId(),
                        payResultVO.getSupplyId(), payResultVO.getPayeeId());

                if("-1".equals(payResultVO.getContractId().toString())) {
                    listQuery.isNull("contract_id");
                } else {
                    listQuery.eq("contract_id", payResultVO.getContractId());
                }

                BigDecimal payMnyActual = payResultVO.getPayMnyActual();
                boolean isRefund = payMnyActual.compareTo(BigDecimal.ZERO) < 0;
                //定义分支 金额为负数  查询已付金额大于0 并根据申请时间倒叙查询到对应的申请单 并充帐掉金额

                listQuery.eq("project_id", payResultVO.getProjectId());
                listQuery.eq("supplier_id", payResultVO.getSupplyId());
                listQuery.eq("payee_id", payResultVO.getPayeeId());
                listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
                if(isRefund) {
                    listQuery.ge("actual_mny", BigDecimal.ZERO);
                    //退款时，需要按照核销的相反逻辑将对应已核销的单据查询出来
                    listQuery.orderByDesc("apply_date");
                } else {
                    listQuery.orderByAsc("apply_date");
                }
                List<PaymentApplyEntity> paymentApplyList = paymentApplyService.list(listQuery);
                logger.info("通过付款结果四个维度 查出相应付款申请 {} 条", paymentApplyList.size());

                //modify by cj 根据纬度，查询对应已生效付款登记总金额
                registerQuery.getParams().put("project_id", new Parameter(QueryParam.EQ, payResultVO.getProjectId()));
                registerQuery.getParams().put("supplier_id", new Parameter(QueryParam.EQ, payResultVO.getProjectId()));
                registerQuery.getParams().put("project_id", new Parameter(QueryParam.EQ, payResultVO.getProjectId()));
                registerQuery.getParams().put("project_id", new Parameter(QueryParam.EQ, payResultVO.getProjectId()));

                //查询出付款申请单实付总金额 - 付款登记总金额 的差额
                BigDecimal totalActualPayAndRegisterDiffMny = registerService.getAcutalPayAndRegisterDiffMny(payResultVO.getProjectId(), payResultVO.getSupplyId(),
                        payResultVO.getPayeeId(), payResultVO.getContractId());
                logger.info("通过付款结果四个维度 项目id-projectId {}，合同id-contractId {}，" +
                                "供应商id-supplierId {}，收款单位id-payeeId {}统计，查询出付款申请单实付总金额 - 付款登记总金额 的差额：{}", payResultVO.getProjectId(), payResultVO.getContractId(),
                        payResultVO.getSupplyId(), payResultVO.getPayeeId(), totalActualPayAndRegisterDiffMny);

                //冲账时 付款登记实付金额要扣除的金额
                BigDecimal payRegisterAddMny = BigDecimal.ZERO;

                List<PaymentApplyEntity> updateList = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(paymentApplyList)) {
                    BigDecimal actualPaidMny = payResultVO.getPayMnyActual();

                    BigDecimal remainAbleMny = null; //付款单剩余可核销/退款金额
                    if(isRefund) {
                        if(totalActualPayAndRegisterDiffMny.compareTo(BigDecimal.ZERO) > 0) {
                            //若申请实付金额 大于 登记总金额，那么核销时，付款申请单实付按照接收到的核销金额做记录，付款登记则按照 核销金额扣除该差额后的金额 做记录
                            payRegisterAddMny = totalActualPayAndRegisterDiffMny;
                            logger.info("通过付款结果四个维度 项目id-projectId {}，合同id-contractId {}，" +
                                            "供应商id-supplierId {}，收款单位id-payeeId {}统计，付款单实付大于登记总金额，付款登记冲账金额为：{} + {}", payResultVO.getProjectId(), payResultVO.getContractId(),
                                    payResultVO.getSupplyId(), payResultVO.getPayeeId(), actualPaidMny, payRegisterAddMny);
                        } else if(totalActualPayAndRegisterDiffMny.compareTo(BigDecimal.ZERO) < 0) {
                            //若申请金额 小于 登记总金额，那么核销时。付款单按照 核销金额扣除差额后的金额做记录，付款登记则按照接收到的核销金额做记录
                            actualPaidMny = actualPaidMny.subtract(totalActualPayAndRegisterDiffMny);
                            logger.info("通过付款结果四个维度 项目id-projectId {}，合同id-contractId {}，" +
                                            "供应商id-supplierId {}，收款单位id-payeeId {}统计，付款单实付大于登记总金额，付款实际冲账金额调整为：{}", payResultVO.getProjectId(), payResultVO.getContractId(),
                                    payResultVO.getSupplyId(), payResultVO.getPayeeId(), actualPaidMny);
                        }

                        //退款
                        for (PaymentApplyEntity paymentApply : paymentApplyList) {

                            updateList.add(paymentApply);
                            logger.info("付款申请单-[{}] 执行退款操作", JSONObject.toJSONString(paymentApply, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                            //付款单剩余可退款金额 = 已支付金额
                            if(actualPaidMny.abs().compareTo(paymentApply.getActualMny()) < 0) {
                                logger.info("付款单申请金额：{}，实付金额：{}, 本次退款金额: {}", paymentApply.getApprovalMny(), paymentApply.getActualMny(), actualPaidMny.abs());
                                paymentApply.setActualMny(paymentApply.getActualMny().add(actualPaidMny));
                                logger.info("付款申请执行退款操作完成，终止循环！");
                                break;
                            } else {
                                //将已支付全部退款
                                logger.info("付款单申请金额：{}，实付金额：{}, 本次退款金额: {}", paymentApply.getApprovalMny(), paymentApply.getActualMny(), paymentApply.getActualMny());
                                //设置为未支付
                                paymentApply.setPaymentStatus(1);
                                actualPaidMny = actualPaidMny.add(paymentApply.getActualMny());
                                paymentApply.setActualMny(BigDecimal.ZERO);
                            }
                        }

                    } else {
                        //正常付款
                        //每个付款单剩余可核销
                        for (PaymentApplyEntity paymentApply : paymentApplyList) {

                            if(null == paymentApply.getActualMny()) {
                                paymentApply.setActualMny(BigDecimal.ZERO);
                            } else if(paymentApply.getActualMny().compareTo(paymentApply.getApprovalMny()) >= 0) {
                                logger.info("付款单-{}已支付金额-{}等于批复金额-{}，跳过此付款单的核销处理！", paymentApply.getId().toString(), paymentApply.getActualMny(), paymentApply.getApprovalMny());
                                continue;
                            }
                            //付款单剩余可支付金额 = 付款申请单批复金额 - 已支付金额
                            remainAbleMny = paymentApply.getApprovalMny().subtract(paymentApply.getActualMny());

                            //设置为已支付
                            paymentApply.setPaymentStatus(2);
                            updateList.add(paymentApply);
                            //给数据的实际付款金额赋值
                            //给付款申请单分发实付款金额
                            logger.info("给付款申请单执行核销操作，付款申请单{}", JSONObject.toJSONString(paymentApply, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                            if (actualPaidMny.compareTo(remainAbleMny) == 1) {
                                logger.info("付款单申请金额：{}，实付金额：{}, 本次增加实付金额: {}", paymentApply.getApprovalMny(), paymentApply.getActualMny(), remainAbleMny);
                                paymentApply.setActualMny(paymentApply.getApprovalMny());
                                actualPaidMny = actualPaidMny.subtract(remainAbleMny);
                            } else {
                                logger.info("付款单申请金额：{}，实付金额：{}，本次增加实付金额: {}", paymentApply.getApprovalMny(), paymentApply.getActualMny(), actualPaidMny);
                                paymentApply.setActualMny(paymentApply.getActualMny().add(actualPaidMny));
                                actualPaidMny = BigDecimal.ZERO;
                                break;
                            }
                        }
                    }

                    if(actualPaidMny.compareTo(BigDecimal.ZERO) != 0) {
                        billHandleResultService.sendHandleResult(payResultMsg, payResultVO.getId().toString(), BillHandleTypeEnum.付款申请单.getTypeCode(),
                                BillHandleResultVO.HANDLE_CODE_FAIL, "注意：该付款申请单金额未全部处理！！！", false);
                    }


                    //TODO  updateList 判空
                    if(CollectionUtils.isEmpty(updateList)) {
                        logger.error("待核销付款-{}没有可用于核销的付款申请单！", payResultMsg);
                        msgBuilder.append("失败，没有可用于核销的付款申请单！");
                    } else {
                        //更新付款单信息
                        paymentApplyService.saveOrUpdateBatch(updateList, updateList.size(), false);

                        //调付款申请pm服务
                        PMPayApplyVO pmPayApplyVO = new PMPayApplyVO();
                        pmPayApplyVO.setProjectId(payResultVO.getProjectId().toString());
                        pmPayApplyVO.setSupplierId(payResultVO.getSupplyId().toString());
                        pmPayApplyVO.setContractRegisterId(payResultVO.getContractId().toString());
                        pmPayApplyVO.setPayeeId(payResultVO.getPayeeId().toString());
                        pmPayApplyVO.setPayMnyActual(payResultVO.getPayMnyActual());
                        pmPayApplyVO.setIsContract("-1".equals(payResultVO.getContractId().toString()) ? 0 : 1);

                        logger.info("开始调用PM付款申请单核销接口，接口参数VO-{}", JSONObject.toJSONString(payResultVO));
                        CommonResponse<PMPayApplyVO> res = pmPayApplyApi.writeOff(pmPayApplyVO);

                        PMPayEntity payResultEntity = BeanMapper.map(payResultVO, PMPayEntity.class);
                        logger.info("调用PM付款申请单核销接口---ejc-profinance项目---payResultServiceImpl类---handPayResult方法---end，接口返回结果-{}", JSONObject.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                        //当前付款结果payResult的付款记录信息payResultMessage赋值，付款成功、付款失败
                        if (res.isSuccess()) {
                            logger.info("付款申请单核销成功！设置付款记录单付款结果信息 付款成功");
                            //设置为已核销
                            payResultEntity.setPaidFlag(1);
                            payResultEntity.setPayResultMessage("付款核销成功!");
                            super.saveOrUpdate(payResultEntity);
                        } else {
                            logger.error("付款申请单-{}核销失败，设置更新中间表数据信息失败，错误信息{}",payResultEntity.getId(), res.getMsg());

                            //记录处理结果
                            msgBuilder.append("失败，更新中间表数据信息失败，返回错误信息：" + res.getMsg());
                            billHandleResultService.sendHandleResult(payResultMsg, payResultVO.getId().toString(), BillHandleTypeEnum.付款申请单.getTypeCode(),
                                    BillHandleResultVO.HANDLE_CODE_FAIL, msgBuilder.toString());

                            throw new BusinessException("付款申请单-"+payResultEntity.getId()+"核销失败, 更新中间表数据失败！");
                        }

                        //生成付款登记
                        generatePayRecord(paymentApplyList.get(0), payResultVO, payResultVO.getPayMnyActual().add(payRegisterAddMny));

                        //记录处理结果
                        msgBuilder.append("成功！");
                    }
                    billHandleResultService.sendHandleResult(payResultMsg, payResultVO.getId().toString(), BillHandleTypeEnum.付款申请单.getTypeCode(),
                            BillHandleResultVO.HANDLE_CODE_SUC, msgBuilder.toString(), false);
                } else {
                    logger.error("待核销付款-{}没有可用于核销的付款申请单！", payResultMsg);
                    billHandleResultService.sendHandleResult(payResultMsg, payResultVO.getId().toString(), BillHandleTypeEnum.付款申请单.getTypeCode(),
                            BillHandleResultVO.HANDLE_CODE_FAIL, "没有可用于核销的付款申请单!");
                }
            }
        } catch (Exception e) {
            logger.error("处理付款结果异常：{}", JSONObject.toJSONString(payResultVO), e);
            //记录处理结果
            msgBuilder.append("异常，异常信息：" + e.getMessage());
            billHandleResultService.sendHandleResult(payResultMsg, payResultVO.getId().toString(), BillHandleTypeEnum.付款申请单.getTypeCode(),
                    BillHandleResultVO.HANDLE_CODE_FAIL, msgBuilder.toString());

            if (e.getMessage()==null){
                throw new BusinessException("付款申请单-" + payResultVO.getId() + "核销失败, 更新中间表数据失败！");
            }else {
                throw new BusinessException("付款申请单-" + payResultVO.getId() +e.getMessage());
            }
        } finally {
            logger.info("redisKey-{}进行Redis锁释放", redisKey);
            unLock(jedis, true, redisKey, OPERATE);
        }
    }

    public String getPayType(Integer payType) {
        switch (payType) {
            case 1:
                return "预付款";
            case 2:
                return "诉讼款";
            case 3:
                return "零星材料费用";
            case 4:
                return "临时设备费用";
            default:
                return "正常付款";
        }
    }

    private void generatePayRecord(PaymentApplyEntity entity, PMPayVO payResultVO, BigDecimal actualPayMny) {
        String authority = getAuthority(payResultVO.getTenantId());
        try {
            if(StringUtils.isBlank(authority)) {
                logger.error("根据付款申请单- [{}], 支付结果-[{}], 获取模拟登录失败，无法生成付款登记单！", JSONObject.toJSONString(entity), JSONObject.toJSONString(payResultVO));
                return;
            }

            InvocationInfoProxy.setTenantid(payResultVO.getTenantId());
            String key = "userCode";
            int idx = authority.indexOf(";" + key + "=");
            if (idx >= 0) {
                String tmp = authority.substring(idx + 1);
                InvocationInfoProxy.setUsercode(tmp.substring(0, tmp.indexOf(";")).replace(key + "=", ""));
            }
            InvocationInfoProxy.setExtendAttribute("authority", authority);

            //登记单
            PaymentRegisterEntity register = BeanMapper.map(entity, PaymentRegisterEntity.class);
            //本次付款金额
            register.setPayMny(null != actualPayMny ? actualPayMny : payResultVO.getPayMnyActual());
            register.setPaymentDate(null != payResultVO.getPushTime() ? payResultVO.getPushTime() : new Date());
            //已付款金额 付款申请单 是一个付款申请信息 和多个付款申请构成的
            register.setFeeTypeId(Long.parseLong(PaymentTypeEnum.正常付款.getCode()));
            register.setFeeTypeName(PaymentTypeEnum.正常付款.getDescription());
            register.setPaymentReason(payResultVO.getId().toString());
            register.setAccountId(null);
            register.setSourceType("付款申请");
            register.setSourceBillType(PaymentRegisterVO.SOURCE_BILL_TYPE_PAYMENT_APPLY);
            register.setAccountName(null);
            register.setId(null);

            //无合同付款时，记录付款费用类型
            if(null == entity.getContractId() || entity.getContractId().equals(-1L)) {
                register.setFeeTypeName(null != entity.getPaymentType() ? getPayType(entity.getPaymentType()) : "正常付款");
            }

            BillCodeParam billCodeParam = BillCodeParam.build(REGISTER_BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(register,PaymentRegisterVO.class));

            Map<String, String> reqParams = JSONObject.parseObject(JSONObject.toJSONString(billCodeParam), Map.class);
            Map<String, String> headers = new HashMap<>();
            headers.put("authority", authority);
            headers.put("Content-Type", "application/json;charset=UTF-8");

            logger.info("支付结果核销，生成付款登记编码参数：{}", JSONObject.toJSONString(billCodeParam));
            String url = BASE_HOST + "ejc-support-web/api/billCodeApi/generateBillCode";
            String codeRespStr = HttpTookit.postByJson(url, JSONObject.toJSONString(reqParams), headers, 10000, 10000);
            logger.info("获取付款登记编码结果：{}", codeRespStr);
            CommonResponse codeResp = JSONObject.parseObject(codeRespStr, CommonResponse.class);
            if(!codeResp.isSuccess()) {
                logger.error("生成付款登记失败，自动生成付款登记单编码失败: {}", codeRespStr);
                return;
            }

            register.setBillCode(codeResp.getData().toString());
            register.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            register.setCreateUserCode(entity.getCreateUserCode());
            register.setCreateTime(null != payResultVO.getPushTime() ? payResultVO.getPushTime() : new Date());
            logger.info("付款登记信息-{}，付款申请单信息{}",JSONObject.toJSONString(register), JSONObject.toJSONString(entity));
            registerService.saveOrUpdate(register);
            //需要生成商贸公司的付款申请单，收款单
            if (entity.getPurchaseMethod() != null && entity.getPurchaseMethod()==2){//是代采的合同
                PaymentApplyVO paymentApplyVO = addTradeConvert(entity);
                payMentApi.saveOrUpdateApi(paymentApplyVO);//生成付款申请
                IncomeRegisterVO incomeRegisterVO = addTradeIncomeConvert(entity);
                payMentApi.saveOrUpdate(incomeRegisterVO);//生成收款登记
            }
        } catch (Exception e) {
            logger.error("根据付款申请单- [{}], 支付结果-[{}], 生成付款登记单异常！", JSONObject.toJSONString(entity), JSONObject.toJSONString(payResultVO), e);
        }
    }

    public boolean getLock(String key, Jedis jedis) {
        int retryTime = 0;
        boolean lock = false;
        while(!lock && retryTime <= maxRetryTime) {
            try {
                if(retryTime >0 ){
                    logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                    Thread.sleep(retryTime * retryInterval);
                }
                retryTime++;
                // 在数据维度层面进行加锁
                lock = RedisTool.tryLock(jedis, key, OPERATE, 600);
                if(lock) {
                    return true;
                }
            } catch (Exception e) {
                logger.error("根据键-{}获取reids锁异常", JSONObject.toJSONString(key));
                return false;
            }
        }
        return false;
    }

    // 解锁
    public void unLock(Jedis jedis, boolean locked, String key, String operate) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, operate);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }



    public IncomeRegisterVO addTradeIncomeConvert(PaymentApplyEntity entity) {
        IncomeRegisterVO paymentApplyVO = BeanMapper.map(entity, IncomeRegisterVO.class);
        //新增逻辑处理
        paymentApplyVO.setId(null);
        paymentApplyVO.setBillState(1);
        paymentApplyVO.setCreateUserCode(null);
        paymentApplyVO.setCreateTime(null);
        paymentApplyVO.setUpdateUserCode(null);
        paymentApplyVO.setUpdateTime(null);
        paymentApplyVO.setBillCode(null);
        return paymentApplyVO;
    }
    public com.ejianc.business.tradematerial.finance.vo.PaymentApplyVO addTradeConvert(PaymentApplyEntity entity) {
        com.ejianc.business.tradematerial.finance.vo.PaymentApplyVO paymentApplyVO = BeanMapper.map(entity, com.ejianc.business.tradematerial.finance.vo.PaymentApplyVO.class);
        //新增逻辑处理
        paymentApplyVO.setId(null);
        paymentApplyVO.setBillState(1);
        paymentApplyVO.setCreateUserCode(null);
        paymentApplyVO.setCreateTime(null);
        paymentApplyVO.setUpdateUserCode(null);
        paymentApplyVO.setUpdateTime(null);
        paymentApplyVO.setBillCode(null);
        paymentApplyVO.setApplyMny(paymentApplyVO.getActualMny());//申请金额为实付金额
        paymentApplyVO.setApprovalMny(paymentApplyVO.getActualMny());//批复金额为实付金额
        paymentApplyVO.setActualMny(BigDecimal.ZERO);//实付金额为0
        return paymentApplyVO;
    }
}

