package com.ejianc.business.profinance.service.impl;

import cn.hutool.log.Log;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.bean.RegisterDetailEntity;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.service.IRegisterDetailService;
import com.ejianc.business.tradematerial.finance.api.IPayMentApi;
import com.ejianc.business.tradematerial.finance.vo.IncomeRegisterVO;
import com.ejianc.business.tradematerial.finance.vo.PaymentApplyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;

@Service("paymentRegister") 
public class PaymentRegisterBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
	private IPaymentRegisterService service;
	private Logger logger = LoggerFactory.getLogger(this.getClass());


	@Autowired
	private IRegisterDetailService detailService;

	@Autowired
	private IPayMentApi payMentApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};
	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PaymentRegisterEntity paymentRegisterEntity = service.selectById(billId);
		detailService.updateBillState(billId,state);
		if(paymentRegisterEntity.getPaymentContractFlag()!=0&&paymentRegisterEntity.getPaymentContractFlag()!=1){
			service.updateStatus(paymentRegisterEntity,2);
			service.writeBack(paymentRegisterEntity,true);
		}
		if (paymentRegisterEntity.getPaymentContractFlag()==0 &&
				paymentRegisterEntity.getPurchaseMethod()!= null && paymentRegisterEntity.getPurchaseMethod()== 2){
			PaymentApplyVO paymentApplyVO = addTradeConvert(paymentRegisterEntity);
			payMentApi.saveOrUpdateApi(paymentApplyVO);//生成付款申请
			IncomeRegisterVO incomeRegisterVO = addTradeIncomeConvert(paymentRegisterEntity);
			payMentApi.saveOrUpdate(incomeRegisterVO);//生成收款登记
		}
		return CommonResponse.success("付款管理终审回调成功！");

	}




	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}


	//撤回、弃审回调方法
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		PaymentRegisterEntity paymentRegisterEntity = service.selectById(billId);
		if (paymentRegisterEntity == null) {
			return CommonResponse.error("查询不到该单据信息！");
		}
		QueryWrapper<PaymentRegisterEntity> listQueryOrderByTime = new QueryWrapper<>();
		//有合同付款申请 撤回校验
		if (paymentRegisterEntity.getPaymentContractFlag()==0){
			//查询当前合同是否存在自由态的单据
			QueryWrapper<PaymentRegisterEntity> listQuery = new QueryWrapper<>();
			listQuery.eq("contract_id", paymentRegisterEntity.getContractId());
			listQuery.eq("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
			int resultCount = service.count(listQuery);
			if (resultCount > 0) {
				return CommonResponse.error("当前合同已存在自由态的付款登记 不能弃审/撤回！");
			}
			listQueryOrderByTime.eq("contract_id", paymentRegisterEntity.getSourceId());
		}else if (paymentRegisterEntity.getPaymentContractFlag()!=1){
			//云南 方案
			listQueryOrderByTime.eq("source_id", paymentRegisterEntity.getSourceId());
		}
		listQueryOrderByTime.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
		listQueryOrderByTime.orderByDesc("create_time");
		List<PaymentRegisterEntity> listOrderByTime = service.list(listQueryOrderByTime);
		if (CollectionUtils.isNotEmpty(listOrderByTime) && null != listOrderByTime.get(0)){
			if (!listOrderByTime.get(0).getId().equals(billId)){
				return CommonResponse.error("当前单据不是最新的付款登记，不能弃审/撤回！");
			}
		}
		if(paymentRegisterEntity.getPaymentContractFlag()!=0&&paymentRegisterEntity.getPaymentContractFlag()!=1){
			service.writeBack(paymentRegisterEntity,true);
			service.updateStatus(paymentRegisterEntity,0);
		}
		detailService.updateBillState(billId,state);
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}



	public IncomeRegisterVO addTradeIncomeConvert(PaymentRegisterEntity entity) {
		IncomeRegisterVO paymentApplyVO = BeanMapper.map(entity, IncomeRegisterVO.class);
		//新增逻辑处理
		paymentApplyVO.setId(null);
		paymentApplyVO.setBillState(1);
		paymentApplyVO.setCreateUserCode(null);
		paymentApplyVO.setCreateTime(null);
		paymentApplyVO.setUpdateUserCode(null);
		paymentApplyVO.setUpdateTime(null);
		paymentApplyVO.setBillCode(null);
		paymentApplyVO.setApplyMny(entity.getPayMny());//申请金额为实付金额
		paymentApplyVO.setApprovalMny(entity.getPayMny());//批复金额为实付金额
		paymentApplyVO.setActualMny(entity.getPayMny());//实付金额为
		return paymentApplyVO;
	}
	public com.ejianc.business.tradematerial.finance.vo.PaymentApplyVO addTradeConvert(PaymentRegisterEntity entity) {
		com.ejianc.business.tradematerial.finance.vo.PaymentApplyVO paymentApplyVO = BeanMapper.map(entity, com.ejianc.business.tradematerial.finance.vo.PaymentApplyVO.class);
		//新增逻辑处理
		paymentApplyVO.setId(null);
		paymentApplyVO.setBillState(1);
		paymentApplyVO.setCreateUserCode(null);
		paymentApplyVO.setCreateTime(null);
		paymentApplyVO.setUpdateUserCode(null);
		paymentApplyVO.setUpdateTime(null);
		paymentApplyVO.setBillCode(null);
		paymentApplyVO.setApplyMny(entity.getPayMny());//申请金额为实付金额
		paymentApplyVO.setApprovalMny(entity.getPayMny());//批复金额为实付金额
		paymentApplyVO.setActualMny(BigDecimal.ZERO);//实付金额为0
		return paymentApplyVO;
	}
}
