package com.ejianc.business.profinance.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.profinance.odd.vo.ImportOddFeeVO;
import com.ejianc.business.profinance.odd.vo.OddFeeVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.profinance.odd.mapper.OddFeeMapper;
import com.ejianc.business.profinance.odd.bean.OddFeeEntity;
import com.ejianc.business.profinance.odd.service.IOddFeeService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 零星费用单
 *
 * @author generator
 */
@Service("oddFeeService")
public class OddFeeServiceImpl extends BaseServiceImpl<OddFeeMapper, OddFeeEntity> implements IOddFeeService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ODD_FEE_CODE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private OddFeeMapper oddFeeMapper;

    @Autowired
    private IProSupplierApi iProSupplierApi;

    @Autowired
    private IEmployeeApi iEmployeeApi;


    /**
     * 查询统计累计金额
     *
     * @param queryParam 查询条件
     * @return 查询结果
     */
    @Override
    public Map<String, BigDecimal> countOddFeeAmount(QueryParam queryParam) {
        Map<String, BigDecimal> rtnMap = new HashMap<>();
        BigDecimal feeTaxMnyAmount = BigDecimal.ZERO;
        BigDecimal payTaxMnyAmount = BigDecimal.ZERO;
        List<OddFeeEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            for (OddFeeEntity entity : list) {
                feeTaxMnyAmount = feeTaxMnyAmount.add(this.setDefaultValue(entity.getFeeTaxMny()));
                payTaxMnyAmount = payTaxMnyAmount.add(this.setDefaultValue(entity.getPayTaxMny()));
            }
        }
        rtnMap.put("feeTaxMnyAmount", feeTaxMnyAmount);
        rtnMap.put("payTaxMnyAmount", payTaxMnyAmount);
        return rtnMap;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        List<Integer> typeList = new ArrayList<>();
        for (int i = 1; i < 6; i++) {
            typeList.add(i);
        }
        Date startDate = new Date();
        logger.info("零星费用单导入校验开始：开始时间----------->{}", startDate);

        CommonResponse<List<DefdocDetailVO>> defFeeList = defdocApi.getDefDocByDefCode("no_contract_fee_type");
        logger.info("自定义档案查询使用时间----------->{}", new Date());

        if (!defFeeList.isSuccess()) {
            return CommonResponse.error("导入失败，查询自定义档案失败，请重试！");
        }

        //I8单位编码、纳税人识别号集合
        List<String> unitCodeOrTaxPayerIdentifierList = new ArrayList<>();
        //身份证号、OA账号集合
        List<String> iDCardOrOAAccountList = new ArrayList<>();

        Map<String, ProjectPoolSetVO> projectPoolSetVOMap = new HashMap<>();
        List<String> billCodeList = new ArrayList<>();

        List<OddFeeEntity> oddFeeEntityList = oddFeeMapper.queryAllData();
        if (CollectionUtils.isNotEmpty(oddFeeEntityList)){
            billCodeList = oddFeeEntityList.stream().map(OddFeeEntity::getBillCode).collect(Collectors.toList());
        }
        Map<String, DefdocDetailVO> defFeeMap = defFeeList.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportOddFeeVO> successList = new ArrayList<>();
            List<ImportOddFeeVO> errorList = new ArrayList<>();
            List<ImportOddFeeVO> reDataList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 18) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    ImportOddFeeVO importOddFeeVO = new ImportOddFeeVO();

                    //项目名称
                    if (StringUtils.isNotBlank(datas.get(0))) {
                        importOddFeeVO.setProjectCode(datas.get(0));
                        if (datas.get(0).length() > 64) {
                            errorMessage.append("[填写项目编码长度为1~64字]");
                        } else {
                            if (projectPoolSetVOMap.get(datas.get(0)) != null) {
                                importOddFeeVO.setProjectId(projectPoolSetVOMap.get(datas.get(0)).getId());
                                importOddFeeVO.setProjectName(projectPoolSetVOMap.get(datas.get(0)).getName());
                                importOddFeeVO.setOrgId(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentId());
                                importOddFeeVO.setOrgName(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentName());
                                importOddFeeVO.setOrgCode(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentCode());
                                importOddFeeVO.setParentOrgName(projectPoolSetVOMap.get(datas.get(0)).getOrgName());
                                importOddFeeVO.setParentOrgId(projectPoolSetVOMap.get(datas.get(0)).getOrgId());
                                importOddFeeVO.setParentOrgCode(projectPoolSetVOMap.get(datas.get(0)).getOrgCode());
                            } else {
                                CommonResponse<List<ProjectPoolSetVO>> projectData = projectPoolApi.queryProjectListByCodeAndTenantId(datas.get(0), tenantId);
                                if (!projectData.isSuccess()) {
                                    errorMessage.append("[项目池不存在当前项目编码的项目]");
                                } else {
                                    if (CollectionUtils.isNotEmpty(projectData.getData()) && null != projectData.getData().get(0)) {
                                        projectPoolSetVOMap.put(datas.get(0), projectData.getData().get(0));
                                        importOddFeeVO.setProjectId(projectPoolSetVOMap.get(datas.get(0)).getId());
                                        importOddFeeVO.setProjectName(projectPoolSetVOMap.get(datas.get(0)).getName());
                                        importOddFeeVO.setOrgId(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentId());
                                        importOddFeeVO.setOrgCode(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentCode());
                                        importOddFeeVO.setOrgName(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentName());
                                        importOddFeeVO.setParentOrgId(projectPoolSetVOMap.get(datas.get(0)).getOrgId());
                                        importOddFeeVO.setParentOrgName(projectPoolSetVOMap.get(datas.get(0)).getOrgName());
                                        importOddFeeVO.setParentOrgCode(projectPoolSetVOMap.get(datas.get(0)).getOrgCode());
                                    } else {
                                        errorMessage.append("[项目池不存在当前项目编码的项目]");
                                    }
                                }
                            }
                        }
                    } else {
                        errorMessage.append("[项目编码为必填项]");
                    }


                    //单据编号-billCode
                    if (StringUtils.isNotBlank(datas.get(2))) {
                        importOddFeeVO.setBillCode(datas.get(2));
                        if (datas.get(2).length() > 64) {
                            errorMessage.append("[填写单据编号长度为1~64字]");
                        } else {
                            if (billCodeList.contains(datas.get(2))) {
                                errorMessage.append("[当前单据编号"+ datas.get(2) +"已存在，请更换单据编号]");
                            }
                        }
                    } else {
                        errorMessage.append("[单据编号为必填项]");
                    }


                    //无合同费用类型
                    if (StringUtils.isNotBlank(datas.get(3))) {
                        importOddFeeVO.setNoContractFeeTypeName(datas.get(3));
                        if (datas.get(3).length() > 100) {
                            errorMessage.append("[填写无合同费用类型长度为1~100字]");
                        } else {
                            if (defFeeMap.get(datas.get(3)) == null) {
                                errorMessage.append("[自定义档案不存在当前无合同费用类型]");
                            } else {
                                importOddFeeVO.setNoContractFeeTypeId(defFeeMap.get(datas.get(3)).getId());
                                importOddFeeVO.setNoContractFeeTypeCode(defFeeMap.get(datas.get(3)).getCode());
                            }
                        }
                    }else {
                        errorMessage.append("[无合同费用类型为必填项]");
                    }

                    //业务说明
                    if (StringUtils.isNotBlank(datas.get(4))) {
                        importOddFeeVO.setBusinessExplain(datas.get(4));
                        if (datas.get(4).length() > 500) {
                            errorMessage.append("[填写业务说明长度为1~500字]");
                        }
                    }

                    //发生日期-happenDate
                    if (StringUtils.isBlank(datas.get(5))) {
                        errorMessage.append("[发生日期为必填项]");
                    } else {
                        try {
                            importOddFeeVO.setHappenDate(DateUtils.parseDate(datas.get(5), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[发生日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //不含税金额
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            importOddFeeVO.setFeeMny(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            errorMessage.append("[不含税金额必须为数字]");
                        }
                    } else {
                        errorMessage.append("[不含税金额为必填项]");
                    }

                    //税率
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        try {
                            importOddFeeVO.setTaxRate(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            errorMessage.append("[税率必须为数字]");
                        }
                    } else {
                        errorMessage.append("[税率为必填项]");
                    }

                    //含税金额
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        try {
                            importOddFeeVO.setFeeTaxMny(new BigDecimal(datas.get(8)));
                            if (importOddFeeVO.getFeeMny() != null){
                                importOddFeeVO.setTax(importOddFeeVO.getFeeTaxMny().subtract(importOddFeeVO.getFeeMny()));
                                importOddFeeVO.setSurplusAllocatedMny(importOddFeeVO.getFeeMny());
                                importOddFeeVO.setSurplusPayMny(importOddFeeVO.getFeeMny());
                                importOddFeeVO.setSurplusAllocatedTaxMny(importOddFeeVO.getFeeTaxMny());
                                importOddFeeVO.setSurplusPayTaxMny(importOddFeeVO.getFeeTaxMny());
                            }
                        } catch (Exception e) {
                            errorMessage.append("[含税金额必须为数字]");
                        }
                    } else {
                        errorMessage.append("[含税金额为必填项]");
                    }

                    //支付对象类型
                    if (StringUtils.isBlank(datas.get(9))) {
                        errorMessage.append("[支付对象类型为必填项]");
                    } else {
                        if (datas.get(9).equals("客商")) {
                            importOddFeeVO.setPayTargetType(1);
                        } else if (datas.get(9).equals("员工")) {
                            importOddFeeVO.setPayTargetType(2);
                        } else {
                            errorMessage.append("[支付对象类型填写错误]");
                        }
                        //通过支付对象类型对供应商 或 内部员工赋值
                        if (null != importOddFeeVO.getPayTargetType()){
                            if (importOddFeeVO.getPayTargetType() == 1){
                                //供应商
                                //I8单位编码 和 纳税人识别号应有一个必填
                                if (StringUtils.isBlank(datas.get(10)) && StringUtils.isBlank(datas.get(11))) {
                                    errorMessage.append("[支付对象类型为供应商时，I8单位编码和纳税人识别号应有一个必填]");
                                }else {
                                    if (StringUtils.isNotBlank(datas.get(10))){
                                        importOddFeeVO.setI8DeptCode(datas.get(10));
                                        //通过 I8单位编码 匹配到对应的供应商对象
                                        unitCodeOrTaxPayerIdentifierList.add(datas.get(10));
                                    }
                                    if (StringUtils.isNotBlank(datas.get(11))){
                                        importOddFeeVO.setTaxPayerNum(datas.get(11));
                                        //:通过 纳税人识别号 匹配到对应的供应商对象
                                        unitCodeOrTaxPayerIdentifierList.add(datas.get(11));
                                    }
                                }
                            }else if (importOddFeeVO.getPayTargetType() == 2){
                                //内部员工
                                //身份证号 和 OA账号应有一个必填
                                if (StringUtils.isBlank(datas.get(12)) && StringUtils.isBlank(datas.get(13))) {
                                    errorMessage.append("[支付对象类型为内部员工时，身份证号和OA账号应有一个必填]");
                                }else {
                                    if (StringUtils.isNotBlank(datas.get(12))){
                                        importOddFeeVO.setIdCardNum(datas.get(12));
                                        iDCardOrOAAccountList.add(datas.get(12));
                                    }
                                    if (StringUtils.isNotBlank(datas.get(13))){
                                        importOddFeeVO.setOAAccount(datas.get(13));
                                        iDCardOrOAAccountList.add(datas.get(13));
                                    }
                                }
                            }
                        }
                    }

                    //经办人OA账号
                    if (StringUtils.isNotBlank(datas.get(14))) {
                        importOddFeeVO.setEmployOAAccount(datas.get(14));
                        iDCardOrOAAccountList.add(datas.get(14));
                    } else {
                        errorMessage.append("[经办人OA账号为必填项]");
                    }

                    if (StringUtils.isNotBlank(errorMessage)){
                        importOddFeeVO.setErrorMessage(String.valueOf(errorMessage));
                    }
                    importOddFeeVO.setId(IdWorker.getId());
                    reDataList.add(importOddFeeVO);
                }

                //通过I8单位编码、纳税人识别号获取供应商信息
                CommonResponse<List<SupplierDTO>> supplierData = iProSupplierApi.selectByUnitCodeOrTaxPayerIdentifier(unitCodeOrTaxPayerIdentifierList);
                if (!supplierData.isSuccess() || CollectionUtils.isEmpty(supplierData.getData())) {
                    reDataList.forEach(item -> {
                        if (item.getPayTargetType() == 1){
                            item.setErrorMessage(item.getErrorMessage() != null ? item.getErrorMessage() + "[供应商档案数据不存在]" : "[供应商档案数据不存在]");
                        }
                    });
                } else {
                    List<SupplierDTO> supplierDTOList = supplierData.getData();
                    Map<String, SupplierDTO> i8UnitCodeMap = supplierDTOList.stream().filter(item -> item.getUnitI8Code() != null).collect(Collectors.toMap(SupplierDTO::getUnitI8Code, Function.identity(), (key1, key2) -> key2));
                    Map<String, SupplierDTO> taxPayerIdentifierMap = supplierDTOList.stream().filter(item -> item.getTaxPayerIdentifier() != null).collect(Collectors.toMap(SupplierDTO::getTaxPayerIdentifier, Function.identity(), (key1, key2) -> key2));
                    //判断i8单位编码、和纳税人识别号查到的供应商是否符合该条数据信息
                    for (ImportOddFeeVO importOddFeeVO : reDataList) {
                        if (importOddFeeVO.getPayTargetType() == 1 && i8UnitCodeMap.containsKey(importOddFeeVO.getI8DeptCode())){
                            importOddFeeVO.setSupplierId(i8UnitCodeMap.get(importOddFeeVO.getI8DeptCode()).getId());
                            importOddFeeVO.setSupplierName(i8UnitCodeMap.get(importOddFeeVO.getI8DeptCode()).getName());
                        }
                    }
                    for (ImportOddFeeVO importOddFeeVO : reDataList) {
                        if (importOddFeeVO.getPayTargetType() == 1 && null == importOddFeeVO.getSupplierId()){
                            if (taxPayerIdentifierMap.containsKey(importOddFeeVO.getTaxPayerNum())){
                                importOddFeeVO.setSupplierId(taxPayerIdentifierMap.get(importOddFeeVO.getTaxPayerNum()).getId());
                                importOddFeeVO.setSupplierName(taxPayerIdentifierMap.get(importOddFeeVO.getTaxPayerNum()).getName());
                            }else {
                                //如果i8单位编码、和纳税人识别号查到的供应商都不符合导入信息，则把这条信息添加到错误信息里
                                importOddFeeVO.setErrorMessage(importOddFeeVO.getErrorMessage() != null ? importOddFeeVO.getErrorMessage() + "[供应商档案数据不存在]" : "[供应商档案数据不存在]");
                            }
                        }
                    }
                }

                //通过支付对象类型对供应商 或 内部员工赋值
                CommonResponse<List<EmployeeVO>> employeeData = iEmployeeApi.getByCodeOrIdcard(iDCardOrOAAccountList);
                if (!employeeData.isSuccess() || CollectionUtils.isEmpty(employeeData.getData())) {
                    reDataList.forEach(item -> {
                        if (item.getPayTargetType() == 2){//内部员工
                            item.setErrorMessage(item.getErrorMessage() != null ? item.getErrorMessage() + "[内部员工档案数据不存在]" : "[内部员工档案数据不存在]");
                        }
                    });
                } else {
                    List<EmployeeVO> employeeVOList = employeeData.getData();
                    Map<String, EmployeeVO> idCardMap = employeeVOList.stream().filter(item -> item.getIdcard() != null).collect(Collectors.toMap(EmployeeVO::getIdcard, Function.identity(), (key1, key2) -> key2));
                    Map<String, EmployeeVO> oAAccountMap = employeeVOList.stream().filter(item -> item.getCode() != null).collect(Collectors.toMap(EmployeeVO::getCode, Function.identity(), (key1, key2) -> key2));
                    //通过支付对象类型对供应商 或 内部员工 判断查到的内部员工是否符合该条数据信息
                    for (ImportOddFeeVO importOddFeeVO : reDataList) {
                        if (importOddFeeVO.getPayTargetType() == 2 && oAAccountMap.containsKey(importOddFeeVO.getOAAccount())){
                            importOddFeeVO.setOwnStaffId(oAAccountMap.get(importOddFeeVO.getOAAccount()).getUserId());
                            importOddFeeVO.setOwnStaffName(oAAccountMap.get(importOddFeeVO.getOAAccount()).getName());
                        }

                        //设置经办人
                        if (oAAccountMap.containsKey(importOddFeeVO.getEmployOAAccount())){
                            importOddFeeVO.setEmployeeId(oAAccountMap.get(importOddFeeVO.getEmployOAAccount()).getUserId());
                            importOddFeeVO.setEmployeeName(oAAccountMap.get(importOddFeeVO.getEmployOAAccount()).getName());
                            importOddFeeVO.setDepartmentId(oAAccountMap.get(importOddFeeVO.getEmployOAAccount()).getDeptId());
                            importOddFeeVO.setDepartmentName(oAAccountMap.get(importOddFeeVO.getEmployOAAccount()).getDeptName());
                        }else {
                            //如果i8单位编码、和纳税人识别号查到的供应商都不符合导入信息，则把这条信息添加到错误信息里
                            importOddFeeVO.setErrorMessage(importOddFeeVO.getErrorMessage() != null ? importOddFeeVO.getErrorMessage() + "[内部员工档案数据不存在该经办人信息]" : "[内部员工档案数据不存在该经办人信息]");
                        }
                    }
                    for (ImportOddFeeVO importOddFeeVO : reDataList) {
                        if (importOddFeeVO.getPayTargetType() == 2 && null == importOddFeeVO.getOwnStaffId()){
                            if (idCardMap.containsKey(importOddFeeVO.getIdCardNum())){
                                importOddFeeVO.setOwnStaffId(idCardMap.get(importOddFeeVO.getIdCardNum()).getUserId());
                                importOddFeeVO.setOwnStaffName(idCardMap.get(importOddFeeVO.getIdCardNum()).getName());
                            }else {
                                //如果i8单位编码、和纳税人识别号查到的供应商都不符合导入信息，则把这条信息添加到错误信息里
                                importOddFeeVO.setErrorMessage(importOddFeeVO.getErrorMessage() != null ? importOddFeeVO.getErrorMessage() + "[内部员工档案数据不存在]" : "[内部员工档案数据不存在]");
                            }
                        }
                    }
                }

                for (ImportOddFeeVO importOddFeeVO : reDataList) {
                    if (StringUtils.isBlank(importOddFeeVO.getErrorMessage())) {
                        successList.add(importOddFeeVO);
                    } else {
                        errorList.add(importOddFeeVO);
                    }
                }
            }
            logger.info("导入结束时间----------->{}", new Date());
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }



    @Override
    public String saveImportExcel(HttpServletRequest request, List<OddFeeVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<OddFeeEntity> entityList = BeanMapper.mapList(importVOS, OddFeeEntity.class);
        for (OddFeeEntity entity : entityList) {
            entity.setSourceType(1);
            if (null == entity.getBillCode()){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(entity, OddFeeVO.class));
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) {
                    logger.error("保存零星费用失败，自动生成零星费用编码失败: {}", billCode.getMsg());
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                entity.setBillCode(billCode.getData());
            }
            entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        }
        super.saveOrUpdateBatch(entityList, entityList.size(), false);
        return "保存成功";
    }

    /**
     * 赋默认值
     * @param v 需要赋值对象
     * @return 为空赋值
     */
    private BigDecimal setDefaultValue(BigDecimal v){
        if (v == null) return BigDecimal.ZERO;
        return v;
    }
}
