package com.ejianc.business.report.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.report.service.IProjectReportService;
import com.ejianc.business.report.vo.CostAndActualOutVO;
import com.ejianc.business.report.vo.ProjectReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;


/**
 * 项目报表 controller
 */
@RestController
@RequestMapping("/projectReport")
public class ProjectReportController {

    @Autowired
    private IProjectReportService reportService;

    /**
     * 项目统计分析表
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryProjectCount", method = RequestMethod.POST)
    public CommonResponse<IPage<ProjectReportVO>> queryProjectCount(@RequestBody QueryParam queryParam) {
        IPage<ProjectReportVO> page = reportService.queryProjectCount(queryParam);
        return CommonResponse.success("查询成功",page);
    }

    /**
     * 目标成本与实际支出情况
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryProjectCostAndActualOut", method = RequestMethod.GET)
    public CommonResponse<List<CostAndActualOutVO>> queryProjectCostAndActualOut(@RequestParam("projectId") Long projectId, @RequestParam("changeAndcostTaxMny") BigDecimal changeAndcostTaxMny) {
        List<CostAndActualOutVO> costAndActualOutList = reportService.queryProjectCostAndActualOut(projectId,changeAndcostTaxMny);
        return CommonResponse.success("查询成功",costAndActualOutList);
    }







}
