/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.profinance.plan.bean.PlanMaterialEntity;
import com.ejianc.business.profinance.plan.mapper.PlanMaterialMapper;
import com.ejianc.business.profinance.plan.service.IPlanMaterialService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="planMaterialService")
public class PlanMaterialServiceImpl
extends BaseServiceImpl<PlanMaterialMapper, PlanMaterialEntity>
implements IPlanMaterialService {
    private static final String MATERIAL_SETTLE_ID = "material_settle_id";

    @Override
    public void updateBillState(Long planId, Integer billStateCode) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(PlanMaterialEntity::getPlanId, (Object)planId);
        updateWrapper.set(PlanMaterialEntity::getBillState, (Object)billStateCode);
        updateWrapper.set(PlanMaterialEntity::getBillStateName, (Object)BillStateEnum.getEnumByStateCode((Integer)billStateCode).getDescription());
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public Map<String, Object> fetchMaterialValue(Collection<Long> settleIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in((Object)MATERIAL_SETTLE_ID, settleIds);
        queryWrapper.groupBy((Object[])new String[]{MATERIAL_SETTLE_ID});
        queryWrapper.select(new String[]{"material_settle_id as materialSettleId,ifnull(sum(material_plan_payment_mny), 0) as materialAppliedMny"});
        List resultMap = super.listMaps((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)resultMap)) {
            return this.converToMap(resultMap);
        }
        return result;
    }

    private Map<String, Object> converToMap(List<Map<String, Object>> listMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map<String, Object> map : listMap) {
            if (resultMap.containsKey(map.get("materialSettleId").toString())) continue;
            resultMap.put(map.get("materialSettleId").toString(), map.get("materialAppliedMny").toString());
        }
        return resultMap;
    }
}

