/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paymentApply")
public class PaymentApplyBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPaymentApplyService service;
    @Autowired
    private IPMPayApplyApi pmPayApplyApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u4ed8\u6b3e\u7533\u8bf7-\u63d0\u4ea4\u524d\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PaymentApplyEntity entity = (PaymentApplyEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            // empty if block
        }
        entity.setActualApplyMny(entity.getApprovalMny());
        CommonResponse<PMPayApplyVO> res = this.takeEffectApply(billId);
        if (!res.isSuccess()) {
            this.logger.error("\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u751f\u6548\u63a5\u53e3\u5931\u8d25\uff01message-{}", (Object)res.getMsg());
            return CommonResponse.error((String)"\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u751f\u6548\u63a5\u53e3\u5931\u8d25");
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4ed8\u6b3e\u7533\u8bf7\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<PMPayApplyVO> takeEffectApply(Long id) {
        this.logger.info("\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u751f\u6548\u63a5\u53e3---ejc-profinance\u9879\u76ee---PaymentApplyBpmServiceImpl\u7c7b---takeEffectApply\u65b9\u6cd5---begin\uff0c\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}", (Object)id);
        PaymentApplyEntity sourceEntity = (PaymentApplyEntity)((Object)this.service.selectById(id));
        if (sourceEntity == null) {
            this.logger.error("\u6839\u636e\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}\uff0c\u67e5\u8be2\u4e0d\u5230\u672c\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u751f\u6548\u63a5\u53e3", (Object)id);
            return CommonResponse.error((String)("\u6839\u636e\u672c\u4ed8\u6b3e\u7533\u8bf7ID-\u3010" + id + "\u3011\u67e5\u8be2\u4e0d\u5230\u672c\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u751f\u6548\u63a5\u53e3"));
        }
        this.logger.info("\u6839\u636e\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}\uff0c\u67e5\u8be2\u5230\u7684\u672c\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e-{}", (Object)id, (Object)JSONObject.toJSONString((Object)((Object)sourceEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        PMPayApplyVO paramVO = new PMPayApplyVO();
        Long projectId = sourceEntity.getProjectId();
        paramVO.setProjectId(null);
        if (projectId != null) {
            paramVO.setProjectId(projectId.toString());
        }
        Long supplierId = sourceEntity.getSupplierId();
        paramVO.setSupplierId(null);
        if (supplierId != null) {
            paramVO.setSupplierId(supplierId.toString());
        }
        Long payeeId = sourceEntity.getPayeeId();
        paramVO.setPayeeId(null);
        if (payeeId != null) {
            paramVO.setPayeeId(payeeId.toString());
        }
        Integer paymentContractFlag = sourceEntity.getPaymentContractFlag();
        Long contractId = sourceEntity.getContractId();
        paramVO.setIsContract(null);
        paramVO.setContractRegisterId(null);
        if (paymentContractFlag != null) {
            if (paymentContractFlag == 0) {
                paramVO.setIsContract(Integer.valueOf(1));
                if (contractId != null) {
                    paramVO.setContractRegisterId(contractId.toString());
                }
            } else {
                paramVO.setIsContract(Integer.valueOf(0));
                paramVO.setContractRegisterId("-1");
            }
        }
        paramVO.setCurApplyMny(sourceEntity.getApprovalMny());
        Integer purchaseMethod = sourceEntity.getPurchaseMethod();
        paramVO.setBs("0");
        if (purchaseMethod != null && purchaseMethod == 2) {
            paramVO.setBs("1");
        }
        this.logger.info("\u5f00\u59cb\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u751f\u6548\u63a5\u53e3\uff0c\u63a5\u53e3\u53c2\u6570VO-{}", (Object)paramVO.toString());
        CommonResponse res = this.pmPayApplyApi.takeEffect(paramVO);
        this.logger.info("\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u751f\u6548\u63a5\u53e3---ejc-profinance\u9879\u76ee---PaymentApplyBpmServiceImpl\u7c7b---takeEffectApply\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u4ed8\u6b3e\u7533\u8bf7\u63a8\u9001\u4e2d\u95f4\u8868\u5931\u8d25");
        }
        return res;
    }

    private CommonResponse<PMPayApplyVO> abandonOrCloseApply(Long id, Integer type) {
        this.logger.info("\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u751f\u6548\u63a5\u53e3---ejc-profinance\u9879\u76ee---PaymentApplyBpmServiceImpl\u7c7b---abandonOrCloseApply\u65b9\u6cd5---begin\uff0c\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}", (Object)id);
        PaymentApplyEntity sourceEntity = (PaymentApplyEntity)((Object)this.service.selectById(id));
        if (sourceEntity == null) {
            this.logger.error("\u6839\u636e\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}\uff0c\u67e5\u8be2\u4e0d\u5230\u672c\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u751f\u6548\u63a5\u53e3", (Object)id);
            return CommonResponse.error((String)("\u6839\u636e\u672c\u4ed8\u6b3e\u7533\u8bf7ID-\u3010" + id + "\u3011\u67e5\u8be2\u4e0d\u5230\u672c\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u751f\u6548\u63a5\u53e3"));
        }
        this.logger.info("\u6839\u636e\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}\uff0c\u67e5\u8be2\u5230\u7684\u672c\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e-{}", (Object)id, (Object)JSONObject.toJSONString((Object)((Object)sourceEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (sourceEntity.getActualMny() != null && sourceEntity.getActualMny().compareTo(BigDecimal.ZERO) == 1) {
            return CommonResponse.error((String)"\u5f53\u524d\u4ed8\u6b3e\u5355\u5df2\u5b58\u5728\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\u65e0\u6cd5\u5f03\u5ba1");
        }
        this.service.abandonOrClose(sourceEntity, "\u5f03\u5ba1");
        PMPayApplyVO paramVO = new PMPayApplyVO();
        paramVO.setProjectId(sourceEntity.getProjectId().toString());
        paramVO.setSupplierId(sourceEntity.getSupplierId().toString());
        paramVO.setPayeeId(sourceEntity.getPayeeId().toString());
        Integer paymentContractFlag = sourceEntity.getPaymentContractFlag();
        Long contractId = sourceEntity.getContractId();
        paramVO.setIsContract(null);
        paramVO.setContractRegisterId(null);
        if (paymentContractFlag != null) {
            if (paymentContractFlag == 0) {
                paramVO.setIsContract(Integer.valueOf(1));
                if (contractId != null) {
                    paramVO.setContractRegisterId(contractId.toString());
                }
            } else {
                paramVO.setIsContract(Integer.valueOf(0));
                paramVO.setContractRegisterId("-1");
            }
        }
        paramVO.setType(type);
        if (type == 1) {
            paramVO.setCurApplyMny(sourceEntity.getApprovalMny());
        }
        paramVO.setCurReleaseMny(sourceEntity.getApprovalMny());
        this.logger.info("\u5f00\u59cb\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u751f\u6548\u63a5\u53e3\uff0c\u63a5\u53e3\u53c2\u6570VO-{}", (Object)paramVO.toString());
        CommonResponse res = this.pmPayApplyApi.abandonOrClose(paramVO);
        this.logger.info("\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u751f\u6548\u63a5\u53e3---ejc-profinance\u9879\u76ee---PaymentApplyBpmServiceImpl\u7c7b---abandonOrCloseApply\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return res;
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u636ebillId-{}, state-{}, billTypeCode-{}\u64a4\u56de\u524d\u6821\u9a8c", new Object[]{billId, state, billTypeCode});
        PaymentApplyEntity paymentApplyEntity = (PaymentApplyEntity)((Object)this.service.selectById(billId));
        if (paymentApplyEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u4fe1\u606f\uff01");
        }
        this.logger.info("\u64a4\u56de\u524d\u4ed8\u6b3e\u7533\u8bf7\u5b9e\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)paymentApplyEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (paymentApplyEntity.getPaymentContractFlag() == 0) {
            QueryWrapper listQuery = new QueryWrapper();
            listQuery.eq((Object)"contract_id", (Object)paymentApplyEntity.getContractId());
            listQuery.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            int resultCount = this.service.count((Wrapper)listQuery);
            if (resultCount > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u5b58\u5728\u81ea\u7531\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7 \u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
        }
        if (null != paymentApplyEntity.getCloseState() && paymentApplyEntity.getCloseState().equals(1)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        if (null != paymentApplyEntity.getPaymentStatus() && paymentApplyEntity.getPaymentStatus().equals(2)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        if (paymentApplyEntity.getActualMny() != null && paymentApplyEntity.getActualMny().compareTo(BigDecimal.ZERO) == 1) {
            return CommonResponse.error((String)"\u5f53\u524d\u4ed8\u6b3e\u5355\u5df2\u5b58\u5728\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\u65e0\u6cd5\u5f03\u5ba1");
        }
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(paymentApplyEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(paymentApplyEntity.getBillState())) {
            this.logger.error("\u4ed8\u6b3e\u7533\u8bf7-\u3010{}\u3011\u6267\u884c\u5f03\u5ba1\uff0c\u66f4\u65b0\u4e2d\u95f4\u8868\u903b\u8f91\uff01", (Object)JSONObject.toJSONString((Object)((Object)paymentApplyEntity)));
            String abaMsg = this.service.abandonOrClose(paymentApplyEntity, "\u5f03\u5ba1");
            if (StringUtils.isNotBlank((CharSequence)abaMsg)) {
                return CommonResponse.error((String)abaMsg);
            }
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

