/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.person.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.person.bean.PersonLoanEntity;
import com.ejianc.business.profinance.person.service.IPersonLoanService;
import com.ejianc.business.profinance.person.vo.PersonLoanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RList;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"personLoan"})
public class PersonLoanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private RedissonClient redissonClient;
    private static final String BILL_CODE = "PERS_L";
    @Autowired
    private IPersonLoanService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PersonLoanVO> saveOrUpdate(@RequestBody PersonLoanVO saveOrUpdateVO) {
        PersonLoanEntity entity = (PersonLoanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PersonLoanEntity.class));
        if (entity.getId() == null) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setRefStatus("\u672a\u5f15\u7528");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PersonLoanVO vo = (PersonLoanVO)BeanMapper.map((Object)((Object)entity), PersonLoanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PersonLoanVO> queryDetail(Long id) {
        PersonLoanEntity entity = (PersonLoanEntity)((Object)this.service.selectById(id));
        PersonLoanVO vo = (PersonLoanVO)BeanMapper.map((Object)((Object)entity), PersonLoanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PersonLoanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PersonLoanVO personLoanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("borrowingProjectName");
        fuzzyFields.add("borrowingPersonName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("memo");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Map<String, BigDecimal> map = this.service.fetchTotalMny(param);
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.service.queryPage(param, false);
        List personLoanVOS = BeanMapper.mapList((Iterable)page.getRecords(), PersonLoanVO.class);
        for (PersonLoanVO person : personLoanVOS) {
            if (person.getExpectRepayDate() == null) continue;
            LocalDate localDate = person.getExpectRepayDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            Period period = LocalDate.now().until(localDate);
            person.setRepayDateDiff(Integer.valueOf(period.getDays()));
        }
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("records", (Object)personLoanVOS);
        resp.put("totalLoanMny", (Object)map.get("totalLoanMny"));
        resp.put("totalRepaidLoanMny", (Object)map.get("totalRepaidLoanMny"));
        resp.put("totalLeftLoanMny", (Object)map.get("totalLeftLoanMny"));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> jsonObjectCommonResponse = this.queryList(param);
        List list = new ArrayList();
        if (null != jsonObjectCommonResponse.getData()) {
            list = (List)((JSONObject)jsonObjectCommonResponse.getData()).get((Object)"records");
            list.forEach(c -> {
                c.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
                if (c.getExpectRepayDate() != null) {
                    LocalDate localDate = c.getExpectRepayDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    Period period = LocalDate.now().until(localDate);
                    c.setRepayDateDiff(Integer.valueOf(period.getDays()));
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        if (param.getParams().containsKey("leftLoanMny")) {
            ExcelExport.getInstance().export("ToPayLoan-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().export("PersonLoan-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refPersonLoanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PersonLoanVO>> refPersonLoanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("left_loan_mny", new Parameter("gt", (Object)BigDecimal.ZERO));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            String excludeIdStr;
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"borrowingPersonId")) {
                param.getParams().put("borrowing_person_id", new Parameter("eq", _con.get((Object)"borrowingPersonId")));
            }
            if (StringUtils.isNotBlank((CharSequence)(excludeIdStr = _con.getString("excludeIds")))) {
                param.getParams().put("id", new Parameter("not_in", (Object)Lists.newArrayList((Object[])excludeIdStr.split(","))));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PersonLoanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/loanData"})
    @ResponseBody
    public CommonResponse<Map<String, List<PersonLoanVO>>> loanData(@RequestBody JSONObject jsonObject) {
        HashMap<String, List> data = new HashMap<String, List>();
        if (!jsonObject.containsKey((Object)"key")) {
            throw new BusinessException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = jsonObject.getString("key");
        RList projectLoanList = this.redissonClient.getList(key);
        if (CollectionUtils.isEmpty((Collection)projectLoanList) && jsonObject.containsKey((Object)"ids")) {
            List ids = jsonObject.getJSONArray("ids").toJavaList(Long.class);
            Collection pls = this.service.listByIds(ids);
            PersonLoanController.checkRefStatus(pls);
            projectLoanList.addAll((Collection)BeanMapper.mapList((Iterable)pls, PersonLoanVO.class));
            projectLoanList.expire(Long.parseLong("5"), TimeUnit.MINUTES);
        } else {
            PersonLoanController.checkRefStatus(BeanMapper.mapList((Iterable)projectLoanList, PersonLoanEntity.class));
        }
        data.put(key, BeanMapper.mapList((Iterable)this.redissonClient.getList(key), PersonLoanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", data);
    }

    private static void checkRefStatus(Collection<PersonLoanEntity> pls) {
        for (PersonLoanEntity pl : pls) {
            if (!"\u5f15\u7528".equals(pl.getRefStatus())) continue;
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff01\u501f\u6b3e\u5355\u53f7[" + pl.getBillCode() + "]\u5b58\u5728\u672a\u751f\u6548\u7684[\u4e2a\u4eba\u8fd8\u6b3e\u5355]\uff0c\u5f85\u751f\u6548\u540e\u624d\u5141\u8bb8\u7ee7\u7eed\u8fd8\u6b3e");
        }
    }
}

