/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.profinance.bean.RegulateEntity;
import com.ejianc.business.profinance.enums.PaymentContractEnum;
import com.ejianc.business.profinance.plan.bean.PlanContractEntity;
import com.ejianc.business.profinance.plan.bean.PlanEntity;
import com.ejianc.business.profinance.plan.bean.PlanFeeEntity;
import com.ejianc.business.profinance.plan.bean.PlanMaterialEntity;
import com.ejianc.business.profinance.plan.bean.PlanTemporaryEntity;
import com.ejianc.business.profinance.plan.service.IPlanContractService;
import com.ejianc.business.profinance.plan.service.IPlanFeeService;
import com.ejianc.business.profinance.plan.service.IPlanMaterialService;
import com.ejianc.business.profinance.plan.service.IPlanService;
import com.ejianc.business.profinance.plan.service.IPlanTemporaryService;
import com.ejianc.business.profinance.service.IRegisterDetailService;
import com.ejianc.business.profinance.service.IRegulateService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="plan")
public class PlanBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final IPlanService service;
    private final IPlanContractService planContractService;
    private final IPlanMaterialService planMaterialService;
    private final IPlanTemporaryService planTemporaryService;
    private final IPlanFeeService planFeeService;
    private final IRegulateService regulateService;
    private final IRegisterDetailService registerDetailService;
    private static final String SOURCE_TYPE = "\u9879\u76ee\u8d44\u91d1\u8ba1\u5212";
    private static final String LINK_URL = "/ejc-profinance-frontend/#/plan/card?id=";
    private static final String CHECK_CLOSE_STATE_ERROR = "\u64cd\u4f5c\u5931\u8d25\uff01\u8be5\u8ba1\u5212\u5b58\u5728\u5df2\u5173\u95ed\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u5ba1\u6279\u3002";

    public PlanBpmServiceImpl(SessionManager sessionManager, IBillTypeApi billTypeApi, IPlanService service, IPlanContractService planContractService, IPlanMaterialService planMaterialService, IPlanTemporaryService planTemporaryService, IPlanFeeService planFeeService, IRegulateService regulateService, IRegisterDetailService registerDetailService) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.service = service;
        this.planContractService = planContractService;
        this.planMaterialService = planMaterialService;
        this.planTemporaryService = planTemporaryService;
        this.planFeeService = planFeeService;
        this.regulateService = regulateService;
        this.registerDetailService = registerDetailService;
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        PlanEntity entity = (PlanEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        this.updateSubBillState(billId, state);
        this.insertMiddleTable(billId);
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        PlanEntity entity = (PlanEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5\uff1a{}\uff0c{}", (Object)res.isSuccess(), (Object)res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u9879\u76ee\u8fd8\u6b3e\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1\uff01");
        }
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(PlanEntity::getProjectId, (Object)entity.getProjectId());
        lambdaQuery.orderByDesc(PlanEntity::getPlanDate);
        List entityList = this.service.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)entityList) && !Objects.equals(entity.getId(), ((PlanEntity)((Object)entityList.get(0))).getId())) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff01\u8be5\u5355\u636e\u4e0d\u662f\u9879\u76ee\u7684\u6700\u65b0\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u5ba1\u6279\u3002");
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.exists("select 1 from `ejc-profinance`.ejc_payment_register_detail where source_parent_id = " + billId);
        int count = this.registerDetailService.count((Wrapper)queryWrapper);
        if (count > 0) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff01\u8be5\u8ba1\u5212\u5df2\u5b58\u5728\u652f\u4ed8\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u5ba1\u6279\u3002");
        }
        this.checkCloseState(entity);
        this.delMidData(billId);
        this.updateSubBillState(billId, state);
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de/\u5f03\u5ba1\u6210\u529f");
    }

    private void checkCloseState(PlanEntity planEntity) {
        List planContractList = planEntity.getPlanContractList().stream().filter(e -> e.getContractPlanPayment() != null).collect(Collectors.toList());
        List<PlanMaterialEntity> planMaterialList = planEntity.getPlanMaterialList();
        List<PlanTemporaryEntity> planTemporaryList = planEntity.getPlanTemporaryList();
        List<PlanFeeEntity> planFeeList = planEntity.getPlanFeeList();
        if (CollectionUtils.isNotEmpty(planContractList)) {
            for (PlanContractEntity planContractEntity : planContractList) {
                if (!"\u5df2\u5173\u95ed".equals(planContractEntity.getCloseState())) continue;
                throw new BusinessException(CHECK_CLOSE_STATE_ERROR);
            }
        }
        if (CollectionUtils.isNotEmpty(planMaterialList)) {
            for (PlanMaterialEntity planMaterialEntity : planMaterialList) {
                if (!"\u5df2\u5173\u95ed".equals(planMaterialEntity.getCloseState())) continue;
                throw new BusinessException(CHECK_CLOSE_STATE_ERROR);
            }
        }
        if (CollectionUtils.isNotEmpty(planTemporaryList)) {
            for (PlanTemporaryEntity planTemporaryEntity : planTemporaryList) {
                if (!"\u5df2\u5173\u95ed".equals(planTemporaryEntity.getCloseState())) continue;
                throw new BusinessException(CHECK_CLOSE_STATE_ERROR);
            }
        }
        if (CollectionUtils.isNotEmpty(planFeeList)) {
            for (PlanFeeEntity planFeeEntity : planFeeList) {
                if (!"\u5df2\u5173\u95ed".equals(planFeeEntity.getCloseState())) continue;
                throw new BusinessException(CHECK_CLOSE_STATE_ERROR);
            }
        }
    }

    private void delMidData(Long planId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(RegulateEntity::getSourceParentId, (Object)planId);
        this.regulateService.remove((Wrapper)queryWrapper);
    }

    private void updateSubBillState(Long billId, Integer state) {
        this.planContractService.updateBillState(billId, state);
        this.planMaterialService.updateBillState(billId, state);
        this.planTemporaryService.updateBillState(billId, state);
        this.planFeeService.updateBillState(billId, state);
    }

    private void insertMiddleTable(Long planId) {
        PlanEntity planEntity = (PlanEntity)((Object)this.service.selectById(planId));
        if (planEntity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f");
        }
        List<PlanContractEntity> planContractList = planEntity.getPlanContractList().stream().filter(e -> e.getContractId() != null).collect(Collectors.toList());
        List<PlanMaterialEntity> planMaterialList = planEntity.getPlanMaterialList();
        List<PlanTemporaryEntity> planTemporaryList = planEntity.getPlanTemporaryList();
        List<PlanFeeEntity> planFeeList = planEntity.getPlanFeeList();
        ArrayList<RegulateEntity> entities = new ArrayList<RegulateEntity>();
        if (CollectionUtils.isNotEmpty(planContractList)) {
            PlanBpmServiceImpl.insertPlanContractList(planEntity, planContractList, entities);
        }
        if (CollectionUtils.isNotEmpty(planMaterialList)) {
            PlanBpmServiceImpl.insertPlanMaterialList(planEntity, planMaterialList, entities);
        }
        if (CollectionUtils.isNotEmpty(planTemporaryList)) {
            PlanBpmServiceImpl.insertPlanTemporaryList(planEntity, planTemporaryList, entities);
        }
        if (CollectionUtils.isNotEmpty(planFeeList)) {
            PlanBpmServiceImpl.insertPlanFeeList(planEntity, planFeeList, entities);
        }
        if (CollectionUtils.isNotEmpty(entities)) {
            this.regulateService.saveBatch(entities, 10);
        }
    }

    private static void insertPlanContractList(PlanEntity p, List<PlanContractEntity> planContractList, Collection<RegulateEntity> entities) {
        for (PlanContractEntity e : planContractList) {
            RegulateEntity regulate = new RegulateEntity();
            regulate.setSourceType(SOURCE_TYPE);
            regulate.setSourceId(e.getId());
            regulate.setSourceParentId(e.getPlanId());
            regulate.setRuteLinkUrl(LINK_URL + e.getPlanId());
            regulate.setRuteLinkName(SOURCE_TYPE);
            regulate.setOrgId(p.getOrgId());
            regulate.setOrgCode(p.getOrgCode());
            regulate.setOrgName(p.getOrgName());
            regulate.setBillCode(p.getBillCode());
            regulate.setPlanDate(p.getPlanDate());
            regulate.setParentOrgId(p.getParentOrgId());
            regulate.setParentOrgCode(p.getParentOrgCode());
            regulate.setParentOrgName(p.getParentOrgName());
            regulate.setProjectId(p.getProjectId());
            regulate.setProjectCode(p.getProjectCode());
            regulate.setProjectName(p.getProjectName());
            regulate.setPaymentContractFlag(PaymentContractEnum.\u5408\u540c\u4ed8\u6b3e.getCode());
            regulate.setContractId(e.getContractId());
            regulate.setContractCode(e.getContractCode());
            regulate.setContractName(e.getContractName());
            regulate.setSupplierOrgId(e.getContractPartybId());
            regulate.setSupplierOrgCode(null);
            regulate.setSupplierOrgName(e.getContractPartybName());
            regulate.setFeeTypeId(null);
            regulate.setFeeTypeCode(null);
            regulate.setFeeTypeName(null);
            regulate.setSettleMny(e.getContractTotalSettleMny());
            regulate.setPayTargetType(null);
            regulate.setSupplierUserId(null);
            regulate.setSupplierUserCode(null);
            regulate.setSupplierUserName(null);
            regulate.setSupplierName(e.getContractPartybName());
            regulate.setPlanPayMny(e.getContractPlanPayment());
            regulate.setPaidMny(e.getTotalActualPaymentMny());
            regulate.setUnpaidMny(e.getUnpaidMny());
            regulate.setCloseState(e.getCloseState());
            regulate.setCloseDateTime(e.getCloseDateTime());
            regulate.setCloseUserId(e.getCloseUserId());
            regulate.setCloseUserCode(e.getCloseUserCode());
            regulate.setCloseUserName(e.getCloseUserName());
            regulate.setPaymentState("\u672a\u652f\u4ed8");
            regulate.setSourceCategoryType(e.getContractSourceType());
            regulate.setSourceCategoryTypeName(e.getContractSourceTypeName());
            regulate.setContractCategoryId(e.getContractCategoryId());
            regulate.setContractCategoryName(e.getContractCategoryName());
            regulate.setContractTaxMny(e.getContractTaxMny());
            regulate.setUnpaidMny(e.getContractPlanPayment());
            regulate.setPaidMny(BigDecimal.ZERO);
            regulate.setSourceBillCode(e.getContractCode());
            regulate.setSourceLinkUrl(e.getContractRouteUrl());
            regulate.setSourceLinkName(PaymentContractEnum.\u5408\u540c\u4ed8\u6b3e.getName());
            entities.add(regulate);
        }
    }

    private static void insertPlanMaterialList(PlanEntity p, List<PlanMaterialEntity> planMaterialList, Collection<RegulateEntity> entities) {
        for (PlanMaterialEntity e : planMaterialList) {
            RegulateEntity regulate = new RegulateEntity();
            regulate.setSourceType(SOURCE_TYPE);
            regulate.setSourceId(e.getId());
            regulate.setSourceParentId(e.getPlanId());
            regulate.setRuteLinkUrl(LINK_URL + e.getPlanId());
            regulate.setRuteLinkName(SOURCE_TYPE);
            regulate.setOrgId(p.getOrgId());
            regulate.setOrgCode(p.getOrgCode());
            regulate.setOrgName(p.getOrgName());
            regulate.setBillCode(p.getBillCode());
            regulate.setPlanDate(p.getPlanDate());
            regulate.setParentOrgId(p.getParentOrgId());
            regulate.setParentOrgCode(p.getParentOrgCode());
            regulate.setParentOrgName(p.getParentOrgName());
            regulate.setProjectId(p.getProjectId());
            regulate.setProjectCode(p.getProjectCode());
            regulate.setProjectName(p.getProjectName());
            regulate.setPaymentContractFlag(PaymentContractEnum.\u96f6\u661f\u6750\u6599.getCode());
            regulate.setContractId(null);
            regulate.setContractCode(null);
            regulate.setContractName(null);
            regulate.setSupplierOrgId(e.getMaterialPartybId());
            regulate.setSupplierOrgCode(null);
            regulate.setSupplierOrgName(e.getMaterialPartybName());
            regulate.setFeeTypeId(null);
            regulate.setFeeTypeCode(null);
            regulate.setFeeTypeName(null);
            regulate.setSettleMny(e.getMaterialSettleMny());
            regulate.setPayTargetType(null);
            regulate.setSupplierUserId(null);
            regulate.setSupplierUserCode(null);
            regulate.setSupplierUserName(null);
            regulate.setSupplierName(e.getMaterialPartybName());
            regulate.setPlanPayMny(e.getMaterialPlanPaymentMny());
            regulate.setPaidMny(e.getTotalActualPaymentMny());
            regulate.setUnpaidMny(e.getUnpaidMny());
            regulate.setCloseState(e.getCloseState());
            regulate.setCloseDateTime(e.getCloseDateTime());
            regulate.setCloseUserId(e.getCloseUserId());
            regulate.setCloseUserCode(e.getCloseUserCode());
            regulate.setCloseUserName(e.getCloseUserName());
            regulate.setPaymentState("\u672a\u652f\u4ed8");
            regulate.setUnpaidMny(e.getMaterialPlanPaymentMny());
            regulate.setPaidMny(BigDecimal.ZERO);
            regulate.setSourceBillCode(e.getMaterialSettleCode());
            regulate.setSourceLinkUrl(e.getMaterialSettleRouteUrl());
            regulate.setSourceLinkName(PaymentContractEnum.\u96f6\u661f\u6750\u6599.getName());
            regulate.setSettleDate(e.getMaterialSettleDate());
            entities.add(regulate);
        }
    }

    private static void insertPlanTemporaryList(PlanEntity p, List<PlanTemporaryEntity> planTemporaryList, Collection<RegulateEntity> entities) {
        for (PlanTemporaryEntity e : planTemporaryList) {
            RegulateEntity regulate = new RegulateEntity();
            regulate.setSourceType(SOURCE_TYPE);
            regulate.setSourceId(e.getId());
            regulate.setSourceParentId(e.getPlanId());
            regulate.setRuteLinkUrl(LINK_URL + e.getPlanId());
            regulate.setRuteLinkName(SOURCE_TYPE);
            regulate.setOrgId(p.getOrgId());
            regulate.setOrgCode(p.getOrgCode());
            regulate.setOrgName(p.getOrgName());
            regulate.setBillCode(p.getBillCode());
            regulate.setPlanDate(p.getPlanDate());
            regulate.setParentOrgId(p.getParentOrgId());
            regulate.setParentOrgCode(p.getParentOrgCode());
            regulate.setParentOrgName(p.getParentOrgName());
            regulate.setProjectId(p.getProjectId());
            regulate.setProjectCode(p.getProjectCode());
            regulate.setProjectName(p.getProjectName());
            regulate.setPaymentContractFlag(PaymentContractEnum.\u4e34\u65f6\u673a\u68b0.getCode());
            regulate.setContractId(null);
            regulate.setContractCode(null);
            regulate.setContractName(null);
            regulate.setSupplierOrgId(e.getTemporaryPartybId());
            regulate.setSupplierOrgCode(null);
            regulate.setSupplierOrgName(e.getTemporaryPartybName());
            regulate.setFeeTypeId(null);
            regulate.setFeeTypeCode(null);
            regulate.setFeeTypeName(null);
            regulate.setSettleMny(e.getTemporarySettleMny());
            regulate.setPayTargetType(null);
            regulate.setSupplierUserId(null);
            regulate.setSupplierUserCode(null);
            regulate.setSupplierUserName(null);
            regulate.setSupplierName(e.getTemporaryPartybName());
            regulate.setPlanPayMny(e.getTemporaryPlanPaymentMny());
            regulate.setPaidMny(e.getTotalActualPaymentMny());
            regulate.setUnpaidMny(e.getUnpaidMny());
            regulate.setCloseState(e.getCloseState());
            regulate.setCloseDateTime(e.getCloseDateTime());
            regulate.setCloseUserId(e.getCloseUserId());
            regulate.setCloseUserCode(e.getCloseUserCode());
            regulate.setCloseUserName(e.getCloseUserName());
            regulate.setPaymentState("\u672a\u652f\u4ed8");
            regulate.setUnpaidMny(e.getTemporaryPlanPaymentMny());
            regulate.setPaidMny(BigDecimal.ZERO);
            regulate.setSourceBillCode(e.getTemporarySettleCode());
            regulate.setSourceLinkUrl(e.getTemporarySettleRouteUrl());
            regulate.setSourceLinkName(PaymentContractEnum.\u4e34\u65f6\u673a\u68b0.getName());
            regulate.setSettleDate(e.getTemporarySettleDate());
            entities.add(regulate);
        }
    }

    private static void insertPlanFeeList(PlanEntity p, List<PlanFeeEntity> planFeeList, Collection<RegulateEntity> entities) {
        for (PlanFeeEntity e : planFeeList) {
            RegulateEntity regulate = new RegulateEntity();
            regulate.setSourceType(SOURCE_TYPE);
            regulate.setSourceId(e.getId());
            regulate.setSourceParentId(e.getPlanId());
            regulate.setRuteLinkUrl(LINK_URL + e.getPlanId());
            regulate.setRuteLinkName(SOURCE_TYPE);
            regulate.setOrgId(p.getOrgId());
            regulate.setOrgCode(p.getOrgCode());
            regulate.setOrgName(p.getOrgName());
            regulate.setBillCode(p.getBillCode());
            regulate.setPlanDate(p.getPlanDate());
            regulate.setParentOrgId(p.getParentOrgId());
            regulate.setParentOrgCode(p.getParentOrgCode());
            regulate.setParentOrgName(p.getParentOrgName());
            regulate.setProjectId(p.getProjectId());
            regulate.setProjectCode(p.getProjectCode());
            regulate.setProjectName(p.getProjectName());
            regulate.setPaymentContractFlag(PaymentContractEnum.\u96f6\u661f\u8d39\u7528.getCode());
            regulate.setContractId(null);
            regulate.setContractCode(null);
            regulate.setContractName(null);
            regulate.setSupplierOrgId(e.getSupplierOrgId());
            regulate.setSupplierOrgCode(e.getSupplierOrgCode());
            regulate.setSupplierOrgName(e.getSupplierOrgName());
            regulate.setFeeTypeId(e.getPayTypeNoContractId());
            regulate.setFeeTypeCode(e.getPayTypeNoContractCode());
            regulate.setFeeTypeName(e.getPayTypeNoContractName());
            regulate.setSettleMny(e.getFeeShouldPayTaxMny());
            regulate.setPayTargetType(e.getPaymentObject());
            regulate.setSupplierUserId(e.getSupplierUserId());
            regulate.setSupplierUserCode(e.getSupplierUserCode());
            regulate.setSupplierUserName(e.getSupplierUserName());
            regulate.setSupplierName(e.getSupplierName());
            regulate.setPlanPayMny(e.getFeePlanPaymentMny());
            regulate.setPaidMny(e.getTotalActualPaymentMny());
            regulate.setUnpaidMny(e.getUnpaidMny());
            regulate.setCloseState(e.getCloseState());
            regulate.setCloseDateTime(e.getCloseDateTime());
            regulate.setCloseUserId(e.getCloseUserId());
            regulate.setCloseUserCode(e.getCloseUserCode());
            regulate.setCloseUserName(e.getCloseUserName());
            regulate.setPaymentState("\u672a\u652f\u4ed8");
            regulate.setUnpaidMny(e.getFeePlanPaymentMny());
            regulate.setPaidMny(BigDecimal.ZERO);
            regulate.setSourceBillCode(e.getFeeCode());
            regulate.setSourceLinkUrl(e.getFeeRouteUrl());
            regulate.setSourceLinkName(PaymentContractEnum.\u96f6\u661f\u8d39\u7528.getName());
            regulate.setHappenDate(e.getHappenDate());
            entities.add(regulate);
        }
    }
}

