/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.projectloan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.projectloan.bean.ProjectLoanEntity;
import com.ejianc.business.profinance.projectloan.service.IProjectLoanService;
import com.ejianc.business.profinance.projectloan.vo.ProjectLoanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RList;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"projectLoan"})
public class ProjectLoanController
implements Serializable {
    private static final long serialVersionUID = -618353060912763817L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RULE_CODE = "PROJECT_LOAN";
    private static final String BILL_CODE = "EJCBT202208000001";
    private final IBillTypeApi billTypeApi;
    private final IBillCodeApi billCodeApi;
    private final IOrgApi iOrgApi;
    private final IProjectLoanService service;
    private final SessionManager sessionManager;
    private final RedissonClient redissonClient;

    public ProjectLoanController(IBillTypeApi billTypeApi, IBillCodeApi billCodeApi, IOrgApi iOrgApi, IProjectLoanService service, SessionManager sessionManager, RedissonClient redissonClient) {
        this.billTypeApi = billTypeApi;
        this.billCodeApi = billCodeApi;
        this.iOrgApi = iOrgApi;
        this.service = service;
        this.sessionManager = sessionManager;
        this.redissonClient = redissonClient;
    }

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<ProjectLoanVO> saveOrUpdate(@RequestBody ProjectLoanVO saveOrUpdateVO) {
        ProjectLoanEntity entity = (ProjectLoanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectLoanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setRefStatus("\u672a\u5f15\u7528");
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillName("\u9879\u76ee\u501f\u6b3e");
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        this.service.saveOrUpdate((Object)entity, false);
        ProjectLoanVO vo = (ProjectLoanVO)BeanMapper.map((Object)((Object)entity), ProjectLoanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<ProjectLoanVO> queryDetail(Long id) {
        ProjectLoanEntity entity = (ProjectLoanEntity)((Object)this.service.selectById(id));
        ProjectLoanVO vo = (ProjectLoanVO)BeanMapper.map((Object)((Object)entity), ProjectLoanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<ProjectLoanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectLoanVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("borrowingUnitName");
        fuzzyFields.add("loanUnitName");
        fuzzyFields.add("memo");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("borrowing_unit_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Map<String, BigDecimal> map = this.service.fetchTotalMny(param);
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        List projectLoanVOS = BeanMapper.mapList((Iterable)page.getRecords(), ProjectLoanVO.class);
        if (param.getParams().containsKey("leftLoanMny")) {
            LocalDate nowDate = LocalDate.now();
            projectLoanVOS.forEach(e -> {
                if (e.getExpectRepayDate() != null) {
                    e.setExpectRepayDays(Long.valueOf(ChronoUnit.DAYS.between(nowDate, e.getExpectRepayDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())));
                }
            });
        }
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("records", (Object)projectLoanVOS);
        resp.put("totalLoanMny", (Object)map.get("totalLoanMny"));
        resp.put("totalRepaidLoanMny", (Object)map.get("totalRepaidLoanMny"));
        resp.put("totalLeftLoanMny", (Object)map.get("totalLeftLoanMny"));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("borrowingUnitName");
        fuzzyFields.add("loanUnitName");
        fuzzyFields.add("memo");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("borrowing_unit_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        ArrayList projectLoanVOS1 = new ArrayList();
        List projectLoanVOS = BeanMapper.mapList((Iterable)page.getRecords(), ProjectLoanVO.class);
        projectLoanVOS.forEach(e -> {
            LocalDate nowDate = LocalDate.now();
            if (e.getExpectRepayDate() != null) {
                e.setExpectRepayDays(Long.valueOf(ChronoUnit.DAYS.between(nowDate, e.getExpectRepayDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())));
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            projectLoanVOS1.add(e);
        });
        HashMap beans = new HashMap();
        beans.put("records", projectLoanVOS1);
        if (param.getParams().containsKey("leftLoanMny")) {
            ExcelExport.getInstance().export("projectLoan-to-be-pay-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().export("projectLoan-export.xlsx", beans, response);
        }
    }

    @GetMapping(value={"/refProjectLoanData"})
    public CommonResponse<IPage<ProjectLoanVO>> refProjectLoanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("loanUnitName");
        fuzzyFields.add("memo");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("left_loan_mny", new Parameter("gt", (Object)BigDecimal.ZERO));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"repayUnitId")) {
                param.getParams().put("borrowing_unit_id", new Parameter("eq", _con.get((Object)"repayUnitId")));
            }
            if (_con.containsKey((Object)"excludeIds") && CollectionUtils.isNotEmpty((Collection)_con.getJSONArray("excludeIds"))) {
                param.getParams().put("id", new Parameter("not_in", (Object)_con.getJSONArray("excludeIds")));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectLoanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/fetchProjectLoanData"})
    public CommonResponse<Map<String, List<ProjectLoanVO>>> fetchProjectLoanData(@RequestBody JSONObject jsonObject) {
        HashMap<String, List> data = new HashMap<String, List>();
        if (!jsonObject.containsKey((Object)"key")) {
            throw new BusinessException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = jsonObject.getString("key");
        RList projectLoanList = this.redissonClient.getList(key);
        if (CollectionUtils.isEmpty((Collection)projectLoanList) && jsonObject.containsKey((Object)"ids")) {
            List ids = jsonObject.getJSONArray("ids").toJavaList(Long.class);
            Collection pls = this.service.listByIds(ids);
            ProjectLoanController.checkRefStatus(pls);
            projectLoanList.addAll((Collection)BeanMapper.mapList((Iterable)pls, ProjectLoanVO.class));
            projectLoanList.expire(Long.parseLong("5"), TimeUnit.MINUTES);
        } else {
            ProjectLoanController.checkRefStatus(BeanMapper.mapList((Iterable)projectLoanList, ProjectLoanEntity.class));
        }
        data.put(key, BeanMapper.mapList((Iterable)this.redissonClient.getList(key), ProjectLoanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", data);
    }

    private static void checkRefStatus(Collection<ProjectLoanEntity> pls) {
        for (ProjectLoanEntity pl : pls) {
            if (!"\u5f15\u7528".equals(pl.getRefStatus())) continue;
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff01\u501f\u6b3e\u5355\u53f7[" + pl.getBillCode() + "]\u5b58\u5728\u672a\u751f\u6548\u7684[\u9879\u76ee\u8fd8\u6b3e\u5355]\uff0c\u5f85\u751f\u6548\u540e\u624d\u5141\u8bb8\u7ee7\u7eed\u8fd8\u6b3e");
        }
    }
}

