package com.ejianc.business.pro.income.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;


/**
 * 合同登记变更
 *
 * @author generator
 */
public class ContractRegisterChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long registerId; // 合同登记主键
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long reviewId; // 合同评审主键
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Long bearType; // 承揽方式
    private String contractName; // 合同名称
    private Long contractType; // 合同类型
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 签约日期
    private Long customerId; // 合同甲方
    private String customerName; // 合同甲方名称
    private Long supplierId; // 合同乙方
    private String supplierName; // 合同乙方名称
    private String constructionPartner; // 施工联合方
    private BigDecimal taxRate; // 合同税率
    private BigDecimal taxMny; // 税额
    private BigDecimal contractMny; // 合同(签订)金额(不含税)
    private BigDecimal contractTaxMny; // 合同(签订)金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 合同竣工日期
    private Integer schedule; // 工期
    private Long contractValuationType; // 合同计价形式，档案
    private String contractStatus; // 合同状态：1-履约中, 2-已封账，3-已解除
    private String contractPartyc; // 合同丙方
    private BigDecimal conjoinedContractTotalMny; // 联体合同总金额
    private BigDecimal costChangeTotalMny; // 工程造价及变动合计总金额(无税)
    private BigDecimal costChangeTotalTaxMny; // 工程造价及变动合计总金额
    private BigDecimal provisionalMny; // 暂列金额
    private BigDecimal contractPromisePaymentRate; // 合同约定收款比例
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String memo; // 备注
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    private BigDecimal baseMoney; // 初始版本金额
    private BigDecimal baseTax; // 初始版本税额
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private BigDecimal beforeChangeMny; // 变更前金额
    private Integer changeVersion; // 变更版本
    private String changeReason; // 变更原因
    private String beforeContractName; // 变更前合同名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date changeTime; // 变更（编制）时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date usedTime; // 生效时间
    private String mainContractName; // 主合同名称
    private Long mainContractId; // 主合同ID
    private String mainContractCode; // 主合同编码
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private String supplierPhone; // 乙方电话
    private String customerPhone; // 甲方电话
    private String customerEntrustedAgent; // 甲方委托代理人
    private String supplierEntrustedAgent; // 乙方委托代理人
    private Long disputeResolution; // 争议解决方式
    private String disputeResolutionAgency; // 争议解决机构

    private String changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private String historyBillCode; // 历史版本编号
    private BigDecimal scale; // 本次变更比例(合同页签用)
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算
    private String supplementContent; // 协议内容
    private Long contractualModel; // 承包模式
    private BigDecimal notIncludeProvisionalMny; // 施工合同金额(不含暂列金额)

    private String changeName; // 变更名称
    private BigDecimal thisChangeTaxMny; // 本次变更金额
    private BigDecimal thisChangeMny; // 本次变更金额(无税)
    private BigDecimal thisChangeTax; // 本次变更税额
    private String thisChangeRate; // 本次变更比例

    private Integer isEstimation; // 是否暂估合同：0-否，1-是
    private BigDecimal totalCostAdjustTaxMny; // 工程造价调整金额合计
    private BigDecimal totalCostAdjustMny; // 工程造价调整金额合计(无税)
    private BigDecimal totalCostAdjustTax; // 工程造价调整税额
    private BigDecimal totalAfterCostAdjustTaxMny; // 工程造价调整后总金额
    private BigDecimal totalAfterCostAdjustMny; // 工程造价调整后总金额(无税)
    private BigDecimal totalAfterCostAdjustTax; // 工程造价调整后税额
    private BigDecimal nicContractMny; // 工程造价调整后总金额(不含暂列金额)

    private String progressPaymentClause; // 工程进度款支付条款



    public String getProgressPaymentClause() {
        return progressPaymentClause;
    }

    public void setProgressPaymentClause(String progressPaymentClause) {
        this.progressPaymentClause = progressPaymentClause;
    }

    public Integer getIsEstimation() {
        return isEstimation;
    }

    public void setIsEstimation(Integer isEstimation) {
        this.isEstimation = isEstimation;
    }

    public BigDecimal getTotalCostAdjustTaxMny() {
        return totalCostAdjustTaxMny;
    }

    public void setTotalCostAdjustTaxMny(BigDecimal totalCostAdjustTaxMny) {
        this.totalCostAdjustTaxMny = totalCostAdjustTaxMny;
    }

    public BigDecimal getTotalCostAdjustMny() {
        return totalCostAdjustMny;
    }

    public void setTotalCostAdjustMny(BigDecimal totalCostAdjustMny) {
        this.totalCostAdjustMny = totalCostAdjustMny;
    }

    public BigDecimal getTotalCostAdjustTax() {
        return totalCostAdjustTax;
    }

    public void setTotalCostAdjustTax(BigDecimal totalCostAdjustTax) {
        this.totalCostAdjustTax = totalCostAdjustTax;
    }

    public BigDecimal getTotalAfterCostAdjustTaxMny() {
        return totalAfterCostAdjustTaxMny;
    }

    public void setTotalAfterCostAdjustTaxMny(BigDecimal totalAfterCostAdjustTaxMny) {
        this.totalAfterCostAdjustTaxMny = totalAfterCostAdjustTaxMny;
    }

    public BigDecimal getTotalAfterCostAdjustMny() {
        return totalAfterCostAdjustMny;
    }

    public void setTotalAfterCostAdjustMny(BigDecimal totalAfterCostAdjustMny) {
        this.totalAfterCostAdjustMny = totalAfterCostAdjustMny;
    }

    public BigDecimal getTotalAfterCostAdjustTax() {
        return totalAfterCostAdjustTax;
    }

    public void setTotalAfterCostAdjustTax(BigDecimal totalAfterCostAdjustTax) {
        this.totalAfterCostAdjustTax = totalAfterCostAdjustTax;
    }

    public BigDecimal getNicContractMny() {
        return nicContractMny;
    }

    public void setNicContractMny(BigDecimal nicContractMny) {
        this.nicContractMny = nicContractMny;
    }

    public String getChangeName() {
        return changeName;
    }

    public void setChangeName(String changeName) {
        this.changeName = changeName;
    }

    public BigDecimal getThisChangeTaxMny() {
        return thisChangeTaxMny;
    }

    public void setThisChangeTaxMny(BigDecimal thisChangeTaxMny) {
        this.thisChangeTaxMny = thisChangeTaxMny;
    }

    public BigDecimal getThisChangeMny() {
        return thisChangeMny;
    }

    public void setThisChangeMny(BigDecimal thisChangeMny) {
        this.thisChangeMny = thisChangeMny;
    }

    public BigDecimal getThisChangeTax() {
        return thisChangeTax;
    }

    public void setThisChangeTax(BigDecimal thisChangeTax) {
        this.thisChangeTax = thisChangeTax;
    }

    public String getThisChangeRate() {
        return thisChangeRate;
    }

    public void setThisChangeRate(String thisChangeRate) {
        this.thisChangeRate = thisChangeRate;
    }

    public BigDecimal getNotIncludeProvisionalMny() {
        return notIncludeProvisionalMny;
    }

    public void setNotIncludeProvisionalMny(BigDecimal notIncludeProvisionalMny) {
        this.notIncludeProvisionalMny = notIncludeProvisionalMny;
    }

    /**
     * 合同登记主键
     */
    @ReferSerialTransfer(referCode = "pro-income-contract")
    public Long getRegisterId() {
        return registerId;
    }

    /**
     * 合同登记主键
     */
    @ReferDeserialTransfer
    public void setRegisterId(Long registerId) {
        this.registerId = registerId;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 合同评审主键
     */
    @ReferSerialTransfer(referCode = "proincome-contract-review")
    public Long getReviewId() {
        return reviewId;
    }

    /**
     * 合同评审主键
     */
    @ReferDeserialTransfer
    public void setReviewId(Long reviewId) {
        this.reviewId = reviewId;
    }

    /**
     * 项目
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * 组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    /**
     * 承揽方式
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBearType() {
        return bearType;
    }

    /**
     * 承揽方式
     */
    @ReferDeserialTransfer
    public void setBearType(Long bearType) {
        this.bearType = bearType;
    }

    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    /**
     * 合同类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }

    /**
     * 合同甲方
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 合同甲方
     */
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    /**
     * 合同甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 合同甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    /**
     * 合同乙方
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 合同乙方
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    /**
     * 合同乙方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 合同乙方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    /**
     * 施工联合方
     */
    public String getConstructionPartner() {
        return constructionPartner;
    }

    /**
     * 施工联合方
     */
    public void setConstructionPartner(String constructionPartner) {
        this.constructionPartner = constructionPartner;
    }

    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * 税额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    /**
     * 合同(签订)金额(不含税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同(签订)金额(不含税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    /**
     * 合同(签订)金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同(签订)金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    /**
     * 合同开工日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 合同开工日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }

    /**
     * 合同竣工日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 合同竣工日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }

    /**
     * 工期
     */
    public Integer getSchedule() {
        return schedule;
    }

    /**
     * 工期
     */
    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    /**
     * 合同计价形式，档案
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式，档案
     */
    @ReferDeserialTransfer
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    /**
     * 合同状态：1-履约中, 2-已封账，3-已解除
     */
    public String getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-履约中, 2-已封账，3-已解除
     */
    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    /**
     * 合同丙方
     */
    public String getContractPartyc() {
        return contractPartyc;
    }

    /**
     * 合同丙方
     */
    public void setContractPartyc(String contractPartyc) {
        this.contractPartyc = contractPartyc;
    }

    /**
     * 联体合同总金额
     */
    public BigDecimal getConjoinedContractTotalMny() {
        return conjoinedContractTotalMny;
    }

    /**
     * 联体合同总金额
     */
    public void setConjoinedContractTotalMny(BigDecimal conjoinedContractTotalMny) {
        this.conjoinedContractTotalMny = conjoinedContractTotalMny;
    }

    /**
     * 工程造价及变动合计总金额(无税)
     */
    public BigDecimal getCostChangeTotalMny() {
        return costChangeTotalMny;
    }

    /**
     * 工程造价及变动合计总金额(无税)
     */
    public void setCostChangeTotalMny(BigDecimal costChangeTotalMny) {
        this.costChangeTotalMny = costChangeTotalMny;
    }

    /**
     * 工程造价及变动合计总金额
     */
    public BigDecimal getCostChangeTotalTaxMny() {
        return costChangeTotalTaxMny;
    }

    /**
     * 工程造价及变动合计总金额
     */
    public void setCostChangeTotalTaxMny(BigDecimal costChangeTotalTaxMny) {
        this.costChangeTotalTaxMny = costChangeTotalTaxMny;
    }

    /**
     * 暂列金额
     */
    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    /**
     * 暂列金额
     */
    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }

    /**
     * 合同约定收款比例
     */
    public BigDecimal getContractPromisePaymentRate() {
        return contractPromisePaymentRate;
    }

    /**
     * 合同约定收款比例
     */
    public void setContractPromisePaymentRate(BigDecimal contractPromisePaymentRate) {
        this.contractPromisePaymentRate = contractPromisePaymentRate;
    }

    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 初始版本金额（含税）
     */
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额（含税）
     */
    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    /**
     * 初始版本金额
     */
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBaseTax() {
        return baseTax;
    }

    public void setBaseTax(BigDecimal baseTax) {
        this.baseTax = baseTax;
    }

    /**
     * 变更前金额（含税）
     */
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    /**
     * 变更前合同名称
     */
    public String getBeforeContractName() {
        return beforeContractName;
    }

    /**
     * 变更前合同名称
     */
    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    /**
     * 变更（编制）时间
     */
    public java.util.Date getChangeTime() {
        return changeTime;
    }

    /**
     * 变更（编制）时间
     */
    public void setChangeTime(java.util.Date changeTime) {
        this.changeTime = changeTime;
    }

    /**
     * 生效时间
     */
    public java.util.Date getUsedTime() {
        return usedTime;
    }

    /**
     * 生效时间
     */
    public void setUsedTime(java.util.Date usedTime) {
        this.usedTime = usedTime;
    }

    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    /**
     * 乙方电话
     */
    public String getSupplierPhone() {
        return supplierPhone;
    }

    /**
     * 乙方电话
     */
    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    /**
     * 甲方电话
     */
    public String getCustomerPhone() {
        return customerPhone;
    }

    /**
     * 甲方电话
     */
    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    /**
     * 甲方委托代理人
     */
    public String getCustomerEntrustedAgent() {
        return customerEntrustedAgent;
    }

    /**
     * 甲方委托代理人
     */
    public void setCustomerEntrustedAgent(String customerEntrustedAgent) {
        this.customerEntrustedAgent = customerEntrustedAgent;
    }

    /**
     * 乙方委托代理人
     */
    public String getSupplierEntrustedAgent() {
        return supplierEntrustedAgent;
    }

    /**
     * 乙方委托代理人
     */
    public void setSupplierEntrustedAgent(String supplierEntrustedAgent) {
        this.supplierEntrustedAgent = supplierEntrustedAgent;
    }

    /**
     * 争议解决方式
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getDisputeResolution() {
        return disputeResolution;
    }

    /**
     * 争议解决方式
     */
    @ReferDeserialTransfer
    public void setDisputeResolution(Long disputeResolution) {
        this.disputeResolution = disputeResolution;
    }

    /**
     * 争议解决机构
     */
    public String getDisputeResolutionAgency() {
        return disputeResolutionAgency;
    }

    /**
     * 争议解决机构
     */
    public void setDisputeResolutionAgency(String disputeResolutionAgency) {
        this.disputeResolutionAgency = disputeResolutionAgency;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public String getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }

    /**
     * 历史版本编号
     */
    public String getHistoryBillCode() {
        return historyBillCode;
    }

    /**
     * 历史版本编号
     */
    public void setHistoryBillCode(String historyBillCode) {
        this.historyBillCode = historyBillCode;
    }

    /**
     * 本次变更比例
     */
    public BigDecimal getScale() {
        return scale;
    }

    /**
     * 本次变更比例
     */
    public void setScale(BigDecimal scale) {
        this.scale = scale;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public String getSettlementType() {
        return settlementType;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    /**
     * 协议内容
     */
    public String getSupplementContent() {
        return supplementContent;
    }

    /**
     * 协议内容
     */
    public void setSupplementContent(String supplementContent) {
        this.supplementContent = supplementContent;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractualModel() {
        return contractualModel;
    }

    @ReferDeserialTransfer
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }
}
