package com.ejianc.business.pro.income.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 成本分析报告
 *
 * @author generator
 *
 */
public class RegisterResVO implements Serializable {

    private static final long serialVersionUID = -6204420674214669070L;
    private Long contractId;
    private String contractName;
    private String contractCode;
    private BigDecimal nicContractMny;
    private Long contractValuationType;
    private BigDecimal contractBaseTaxMny;
    private BigDecimal contractBaseMny;
    private BigDecimal taxRate;
    private BigDecimal taxMny;
    private BigDecimal provisionalMny;
    private Long engineeringTypeId;
    private String engineeringTypeName;
    private BigDecimal builtArea;
    private Long contractualModel;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;
    private String fundsSource;
    private Long fundsSourceId;
    private String address;

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFundsSourceId() {
        return fundsSourceId;
    }

    @ReferDeserialTransfer
    public void setFundsSourceId(Long fundsSourceId) {
        this.fundsSourceId = fundsSourceId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public BigDecimal getNicContractMny() {
        return nicContractMny;
    }

    public void setNicContractMny(BigDecimal nicContractMny) {
        this.nicContractMny = nicContractMny;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractValuationType() {
        return contractValuationType;
    }
    @ReferDeserialTransfer
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    public BigDecimal getContractBaseTaxMny() {
        return contractBaseTaxMny;
    }

    public void setContractBaseTaxMny(BigDecimal contractBaseTaxMny) {
        this.contractBaseTaxMny = contractBaseTaxMny;
    }

    public BigDecimal getContractBaseMny() {
        return contractBaseMny;
    }

    public void setContractBaseMny(BigDecimal contractBaseMny) {
        this.contractBaseMny = contractBaseMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }
    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractualModel() {
        return contractualModel;
    }
    @ReferDeserialTransfer
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getFundsSource() {
        return fundsSource;
    }

    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}
