package com.ejianc.business.pro.arch.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.pro.arch.vo.ArchitectDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 建造师
 * 
 * @author generator
 * 
 */
public class ArchitectVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long architectMajor; // 建造师专业
    private String architectMajorName; // 建造师专业 名称
    private String name; // 接收人姓名
    private String sex; // 性别 1：男；2：女
    private String sexString; // 性别 1：男；2：女
    private String idCard; // 乙方项目经理身份证号
    private String registrationNumber; // 注册编号
    private Integer userAge; // 年龄
    private String addItemOne; // 增项1
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date validity; // 有效期止
    private String addItemThree; // 增项3
    private String addItemTwo; // 增项2
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date certificateValidity; // B类有效期止
    private String certificateNumber; // B类证号
    private Long employeeId; // 经办人Id
    private String employeeName; // 经办人名称
    private String departmentName; // 经办部门名称
    private Long departmentId; // 经办部门id
    private String departmentCode; // 经办部门编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date regionDate; // 登记时间
    private String orgCode; // 组织编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgName; // 所属组织名称
    private String parentOrgCode; // 所属组织编码
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private String billStateString; // 单据状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名字
    private String commitUserCode; // 提交人账号
    private String useStatus;//    当前在用状态
    private String area;//当前在用地区
    private String projectName;//当前在用工程
    private List<ArchitectDetailVO> architectDetailList = new ArrayList<>(); // 建造师详情

    public String getSexString() {
        return sexString;
    }

    public void setSexString(String sexString) {
        this.sexString = sexString;
    }

    public String getBillStateString() {
        return billStateString;
    }

    public void setBillStateString(String billStateString) {
        this.billStateString = billStateString;
    }

    public String getArchitectMajorName() {
        return architectMajorName;
    }

    public void setArchitectMajorName(String architectMajorName) {
        this.architectMajorName = architectMajorName;
    }

    public String getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(String useStatus) {
        this.useStatus = useStatus;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getArchitectMajor() {
        return architectMajor;
    }
    @ReferDeserialTransfer
    public void setArchitectMajor(Long architectMajor) {
        this.architectMajor = architectMajor;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getRegistrationNumber() {
        return registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }
    public Integer getUserAge() {
        return userAge;
    }

    public void setUserAge(Integer userAge) {
        this.userAge = userAge;
    }
    public String getAddItemOne() {
        return addItemOne;
    }

    public void setAddItemOne(String addItemOne) {
        this.addItemOne = addItemOne;
    }
    public Date getValidity() {
        return validity;
    }

    public void setValidity(Date validity) {
        this.validity = validity;
    }
    public String getAddItemThree() {
        return addItemThree;
    }

    public void setAddItemThree(String addItemThree) {
        this.addItemThree = addItemThree;
    }
    public String getAddItemTwo() {
        return addItemTwo;
    }

    public void setAddItemTwo(String addItemTwo) {
        this.addItemTwo = addItemTwo;
    }
    public Date getCertificateValidity() {
        return certificateValidity;
    }

    public void setCertificateValidity(Date certificateValidity) {
        this.certificateValidity = certificateValidity;
    }
    public String getCertificateNumber() {
        return certificateNumber;
    }

    public void setCertificateNumber(String certificateNumber) {
        this.certificateNumber = certificateNumber;
    }
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public Date getRegionDate() {
        return regionDate;
    }

    public void setRegionDate(Date regionDate) {
        this.regionDate = regionDate;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    
     public List<ArchitectDetailVO> getArchitectDetailList() {
        return architectDetailList;
     }

     public void setArchitectDetailList(List<ArchitectDetailVO> architectDetailList) {
        this.architectDetailList = architectDetailList;
     }
}
