package com.ejianc.business.pro.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 竣工未结明细
 * 
 * @author generator
 * 
 */
public class UnsettleDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long unsettleId; // 主表主键id
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long parentProjectId; // 所属父级项目id
    private String parentProjectCode; // 所属父级项目编码
    private String parentProjectName; // 所属父级项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionDate; // 竣工日期
    private String projectManager; // 项目经理
    private Long settleEmployeeId; // 结算负责人id
    private String settleEmployeeName; // 结算负责人名称
    private BigDecimal contractMny; // 合同金额
    private BigDecimal sumCompleteMny; // 累计实际完成产值
    private BigDecimal sumIncomeMny; // 累计收款金额
    private BigDecimal contractProgressScale; // 合同约定进度款支付比例
    private BigDecimal contractSettleScale; // 合同约定竣工结算支付比例
    private BigDecimal detailSubmitMny; // 送审金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date detailSubmitDate; // 预计送审日期
    private Integer finalizeType; // 定案阶段 1-一审、2-二审、3-三审、4-终审
    private Integer finalizeFlag; // 定案返回状态 0-已返回 1-未返回
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finalizeDate; // 定案返回日期
    private BigDecimal finalizeMny; // 定案表返回金额
    private String disputedMemo; // 争议事项
    private BigDecimal detailDisputedMny; // 争议金额
    private String memo; // 备注

    private Integer submissionFlag; // 送审状态 0未送审、1已送审
    private Integer settleStage; // 结算阶段 1-第一阶段、2-第二阶段、3-第三阶段、4-第四阶段、5-第五阶段
    private Integer indexGrade; // 指标等级 1一类、2二类
    private Integer scheduleCompletionDate; // 计划完成日期 1-第一季度、2-第二季度、3-第三季度、4-第四季度


    public Integer getSubmissionFlag() {
        return submissionFlag;
    }

    public void setSubmissionFlag(Integer submissionFlag) {
        this.submissionFlag = submissionFlag;
    }

    public Integer getSettleStage() {
        return settleStage;
    }

    public void setSettleStage(Integer settleStage) {
        this.settleStage = settleStage;
    }

    public Integer getIndexGrade() {
        return indexGrade;
    }

    public void setIndexGrade(Integer indexGrade) {
        this.indexGrade = indexGrade;
    }

    public Integer getScheduleCompletionDate() {
        return scheduleCompletionDate;
    }

    public void setScheduleCompletionDate(Integer scheduleCompletionDate) {
        this.scheduleCompletionDate = scheduleCompletionDate;
    }

    public Long getUnsettleId() {
        return unsettleId;
    }

    public void setUnsettleId(Long unsettleId) {
        this.unsettleId = unsettleId;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getParentProjectId() {
        return parentProjectId;
    }

    public void setParentProjectId(Long parentProjectId) {
        this.parentProjectId = parentProjectId;
    }
    public String getParentProjectCode() {
        return parentProjectCode;
    }

    public void setParentProjectCode(String parentProjectCode) {
        this.parentProjectCode = parentProjectCode;
    }
    public String getParentProjectName() {
        return parentProjectName;
    }

    public void setParentProjectName(String parentProjectName) {
        this.parentProjectName = parentProjectName;
    }
    public Date getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }
    public String getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSettleEmployeeId() {
        return settleEmployeeId;
    }
    @ReferDeserialTransfer
    public void setSettleEmployeeId(Long settleEmployeeId) {
        this.settleEmployeeId = settleEmployeeId;
    }
    public String getSettleEmployeeName() {
        return settleEmployeeName;
    }

    public void setSettleEmployeeName(String settleEmployeeName) {
        this.settleEmployeeName = settleEmployeeName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getSumCompleteMny() {
        return sumCompleteMny;
    }

    public void setSumCompleteMny(BigDecimal sumCompleteMny) {
        this.sumCompleteMny = sumCompleteMny;
    }
    public BigDecimal getSumIncomeMny() {
        return sumIncomeMny;
    }

    public void setSumIncomeMny(BigDecimal sumIncomeMny) {
        this.sumIncomeMny = sumIncomeMny;
    }
    public BigDecimal getContractProgressScale() {
        return contractProgressScale;
    }

    public void setContractProgressScale(BigDecimal contractProgressScale) {
        this.contractProgressScale = contractProgressScale;
    }
    public BigDecimal getContractSettleScale() {
        return contractSettleScale;
    }

    public void setContractSettleScale(BigDecimal contractSettleScale) {
        this.contractSettleScale = contractSettleScale;
    }
    public BigDecimal getDetailSubmitMny() {
        return detailSubmitMny;
    }

    public void setDetailSubmitMny(BigDecimal detailSubmitMny) {
        this.detailSubmitMny = detailSubmitMny;
    }
    public Date getDetailSubmitDate() {
        return detailSubmitDate;
    }

    public void setDetailSubmitDate(Date detailSubmitDate) {
        this.detailSubmitDate = detailSubmitDate;
    }
    public Integer getFinalizeType() {
        return finalizeType;
    }

    public void setFinalizeType(Integer finalizeType) {
        this.finalizeType = finalizeType;
    }
    public Integer getFinalizeFlag() {
        return finalizeFlag;
    }

    public void setFinalizeFlag(Integer finalizeFlag) {
        this.finalizeFlag = finalizeFlag;
    }
    public Date getFinalizeDate() {
        return finalizeDate;
    }

    public void setFinalizeDate(Date finalizeDate) {
        this.finalizeDate = finalizeDate;
    }
    public BigDecimal getFinalizeMny() {
        return finalizeMny;
    }

    public void setFinalizeMny(BigDecimal finalizeMny) {
        this.finalizeMny = finalizeMny;
    }
    public String getDisputedMemo() {
        return disputedMemo;
    }

    public void setDisputedMemo(String disputedMemo) {
        this.disputedMemo = disputedMemo;
    }
    public BigDecimal getDetailDisputedMny() {
        return detailDisputedMny;
    }

    public void setDetailDisputedMny(BigDecimal detailDisputedMny) {
        this.detailDisputedMny = detailDisputedMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
