package com.ejianc.business.pro.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 年度计划审定与完成情况明细
 * 
 * @author generator
 * 
 */
public class PlancompletionDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long completionId; // 主表主键id
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long parentProjectId; // 所属父级项目id
    private String parentProjectCode; // 所属父级项目编码
    private String parentProjectName; // 所属父级项目名称
    private String projectUnits; // 建设单位
    private Integer groupType; // 集团内/外 0-内 1-外
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionDate; // 竣工日期
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date approveDate; // 上报计划审定日期
    private String projectManager; // 项目经理
    private Long settleEmployeeId; // 结算负责人id
    private String settleEmployeeName; // 结算负责人名称
    private BigDecimal contractMny; // 合同金额
    private BigDecimal sumCompleteMny; // 累计实际完成产值
    private BigDecimal detailSubmitMny; // 送审金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date detailSubmitDate; // 送审日期
    private BigDecimal ydApproveMny; // 预计审定金额
    private Integer completedFlag; // 是否取得竣工备案表 0-是 1-否
    private Integer finalizeType; // 计划定案阶段 1-一审、2-二审、3-三审、4-终审
    private Integer yearPlanFlag; // 是否进入年度计划 0-是 1-否
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planApproveDate; // 批复计划审定日期
    private Integer finalizeFlag; // 定案返回状态 0-已返回 1-未返回
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finalizeDate; // 定案表返回日期
    private BigDecimal finalizeMny; // 定案表返回金额
    private String memo; // 备注
    private Integer indexGrade; // 指标等级 1-一类 2-二类

    public Integer getIndexGrade() {
        return indexGrade;
    }

    public void setIndexGrade(Integer indexGrade) {
        this.indexGrade = indexGrade;
    }

    public Long getCompletionId() {
        return completionId;
    }

    public void setCompletionId(Long completionId) {
        this.completionId = completionId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getParentProjectId() {
        return parentProjectId;
    }

    public void setParentProjectId(Long parentProjectId) {
        this.parentProjectId = parentProjectId;
    }
    public String getParentProjectCode() {
        return parentProjectCode;
    }

    public void setParentProjectCode(String parentProjectCode) {
        this.parentProjectCode = parentProjectCode;
    }
    public String getParentProjectName() {
        return parentProjectName;
    }

    public void setParentProjectName(String parentProjectName) {
        this.parentProjectName = parentProjectName;
    }
    public String getProjectUnits() {
        return projectUnits;
    }

    public void setProjectUnits(String projectUnits) {
        this.projectUnits = projectUnits;
    }
    public Integer getGroupType() {
        return groupType;
    }

    public void setGroupType(Integer groupType) {
        this.groupType = groupType;
    }
    public Date getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }
    public Date getApproveDate() {
        return approveDate;
    }

    public void setApproveDate(Date approveDate) {
        this.approveDate = approveDate;
    }
    public String getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSettleEmployeeId() {
        return settleEmployeeId;
    }
    @ReferDeserialTransfer
    public void setSettleEmployeeId(Long settleEmployeeId) {
        this.settleEmployeeId = settleEmployeeId;
    }
    public String getSettleEmployeeName() {
        return settleEmployeeName;
    }

    public void setSettleEmployeeName(String settleEmployeeName) {
        this.settleEmployeeName = settleEmployeeName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getSumCompleteMny() {
        return sumCompleteMny;
    }

    public void setSumCompleteMny(BigDecimal sumCompleteMny) {
        this.sumCompleteMny = sumCompleteMny;
    }
    public BigDecimal getDetailSubmitMny() {
        return detailSubmitMny;
    }

    public void setDetailSubmitMny(BigDecimal detailSubmitMny) {
        this.detailSubmitMny = detailSubmitMny;
    }
    public Date getDetailSubmitDate() {
        return detailSubmitDate;
    }

    public void setDetailSubmitDate(Date detailSubmitDate) {
        this.detailSubmitDate = detailSubmitDate;
    }
    public BigDecimal getYdApproveMny() {
        return ydApproveMny;
    }

    public void setYdApproveMny(BigDecimal ydApproveMny) {
        this.ydApproveMny = ydApproveMny;
    }
    public Integer getCompletedFlag() {
        return completedFlag;
    }

    public void setCompletedFlag(Integer completedFlag) {
        this.completedFlag = completedFlag;
    }
    public Integer getFinalizeType() {
        return finalizeType;
    }

    public void setFinalizeType(Integer finalizeType) {
        this.finalizeType = finalizeType;
    }
    public Integer getYearPlanFlag() {
        return yearPlanFlag;
    }

    public void setYearPlanFlag(Integer yearPlanFlag) {
        this.yearPlanFlag = yearPlanFlag;
    }
    public Date getPlanApproveDate() {
        return planApproveDate;
    }

    public void setPlanApproveDate(Date planApproveDate) {
        this.planApproveDate = planApproveDate;
    }
    public Integer getFinalizeFlag() {
        return finalizeFlag;
    }

    public void setFinalizeFlag(Integer finalizeFlag) {
        this.finalizeFlag = finalizeFlag;
    }
    public Date getFinalizeDate() {
        return finalizeDate;
    }

    public void setFinalizeDate(Date finalizeDate) {
        this.finalizeDate = finalizeDate;
    }
    public BigDecimal getFinalizeMny() {
        return finalizeMny;
    }

    public void setFinalizeMny(BigDecimal finalizeMny) {
        this.finalizeMny = finalizeMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
