package com.ejianc.business.pro.income.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 对甲报量
 *
 * @author generator
 *
 */
public class QuoteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ConvertField(targetField = "billCode")
    private String billCode; // 单据编号
    @ConvertField(targetField = "projectId")
    private Long projectId; // 项目
    @ConvertField(targetField = "projectCode")
    private String projectCode; // 项目编号
    @ConvertField(targetField = "projectName")
    private String projectName; // 项目名称
    @ConvertField(targetField = "orgId")
    private Long orgId; // 组织
    @ConvertField(targetField = "orgName")
    private String orgName; // 组织名称
    @ConvertField(targetField = "orgCode")
    private String orgCode; // 组织编码
    @ConvertField(targetField = "parentOrgId")
    private Long parentOrgId; // 父级组织
    @ConvertField(targetField = "parentOrgCode")
    private String parentOrgCode; // 所属组织编码
    @ConvertField(targetField = "parentOrgName")
    private String parentOrgName; // 父级组织名称
    @ConvertField(targetField = "contractId")
    private Long contractId; // 合同主键
    @ConvertField(targetField = "contractCode")
    private String contractCode; // 合同编号
    @ConvertField(targetField = "contractName")
    private String contractName; // 合同名称
    private java.math.BigDecimal taxRate; // 合同税率
    private java.math.BigDecimal contractMny; // 合同金额(无税)
    private java.math.BigDecimal contractTaxMny; // 合同金额(含税)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date quoteDate; // 报量时间
    @ConvertField(targetField = "quoteMny")
    private java.math.BigDecimal quoteMny; // 本次上报金额(无税)
    @ConvertField(targetField = "quoteTaxMny")
    private java.math.BigDecimal quoteTaxMny; // 本次上报金额
    @ConvertField(targetField = "quoteTax")
    private java.math.BigDecimal taxMny; // 税额
    @ConvertField(targetField = "employeeId")
    private Long employeeId; // 经办人
    @ConvertField(targetField = "employeeName")
    private String employeeName; // 经办人名称
    @ConvertField(targetField = "departmentId")
    private Long deptId; // 部门id
    @ConvertField(targetField = "departmentName")
    private String deptName; // 部门名称
    @ConvertField(targetField = "settleDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date replyDate; // 批复时间
    private Integer replyStatus; // 甲方批复状态(0-未批复，1-已批复，2-未通过)
    @ConvertField(targetField = "curMny")
    private java.math.BigDecimal replyMny; // 本次批复金额(无税)
    @ConvertField(targetField = "curTaxMny")
    private java.math.BigDecimal replyTaxMny; // 本次批复金额
    @ConvertField
    private String memo; // 备注
    @ConvertField(targetField = "billState")
    private Integer billState; // 单据状态
    private BigDecimal appliedTaxMny; //已申请金额(不含本次)
    private BigDecimal appliedMny; //已申请金额(不含本次)(无税)
    private BigDecimal residueTaxMny;//剩余可申请金额
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date productionAscriptionYears; // 产值归属年月
    private Integer productionContain; // 产值包含关系--1--是--0--否
    private BigDecimal constructionBudgetMny; // 施工图预算金额
    private BigDecimal contractPaymentRate; // 合同收款比例
    private BigDecimal sumCheckProduction; // 累计审定产值
    private BigDecimal productionContainClaimMny; // 产值含变更签证\索赔金额
    private BigDecimal checkProductionCompany; // 审定产值归公司
    private BigDecimal checkProductionGroup; // 审定产值归集团
    private BigDecimal completedNotApprovalProduction; // 已完成未审批产值
    private BigDecimal monthReceivableEngineeringMny; // 本月应收工程款
    private BigDecimal sumReceivableEngineeringMny; // 累计应收工程款
    private BigDecimal forecastProductionCompany; // 预报产值归公司
    private BigDecimal forecastProductionGroup; // 预报产值归集团
    private BigDecimal reportProduceManagementProduction; // 报生产管理部产值
    private BigDecimal remainderReportProduceMny; // 剩余可报产值金额
    private BigDecimal lastCheckProductionCompany; // 累计审定产值归公司
    private BigDecimal lastCheckProductionGroup; // 累计审定产值归集团
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date predictCompleteDate; // 预计完（竣）工日期

    private Integer replyStatusRedFlag=0;
    private String productionContainName; // 产值包含关系名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date commitDate; // 提交日期
    private List<QuoteDetailVO> detailList = new ArrayList<>(); // 对甲报量子表
    @TableField(value="sum_actual_mny")
    private BigDecimal sumActualMny; // 累计实际完成产值(无税)
    @TableField(value="sum_actual_mny_tax")
    private BigDecimal sumActualMnyTax; // 累计实际完成产值
    @TableField(value="diff_mny")
    private BigDecimal diffMny; // 产值偏差值
    @TableField(value="production_type_id")
    private Long productionTypeId;//产值类型
    @TableField(value="production_type_name")
    private String productionTypeName;//产值类型


    private Integer contractVersion;// 合同版本

    private String billStateName; //单据状态名称

    @TableField(value="sum_mny")
    private BigDecimal sumMny; //累计产值
    @TableField(value="sum_mny_tax")
    private BigDecimal sumMnyTax; //累计产值

    public BigDecimal getSumMny() {
        return sumMny;
    }

    public void setSumMny(BigDecimal sumMny) {
        this.sumMny = sumMny;
    }

    public BigDecimal getSumMnyTax() {
        return sumMnyTax;
    }

    public void setSumMnyTax(BigDecimal sumMnyTax) {
        this.sumMnyTax = sumMnyTax;
    }

    public BigDecimal getSumActualMnyTax() {
        return sumActualMnyTax;
    }

    public void setSumActualMnyTax(BigDecimal sumActualMnyTax) {
        this.sumActualMnyTax = sumActualMnyTax;
    }

    public BigDecimal getSumActualMny() {
        return sumActualMny;
    }

    public void setSumActualMny(BigDecimal sumActualMny) {
        this.sumActualMny = sumActualMny;
    }

    public BigDecimal getDiffMny() {
        return diffMny;
    }

    public void setDiffMny(BigDecimal diffMny) {
        this.diffMny = diffMny;
    }


    public String getProductionTypeName() {
        return productionTypeName;
    }

    public void setProductionTypeName(String productionTypeName) {
        this.productionTypeName = productionTypeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    @ReferSerialTransfer(referCode = "pro-income-contract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同金额(无税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(无税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同金额(含税)
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额(含税)
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 报量时间
     */
    public java.util.Date getQuoteDate() {
        return quoteDate;
    }

    /**
     * 报量时间
     */
    public void setQuoteDate(java.util.Date quoteDate) {
        this.quoteDate = quoteDate;
    }
    /**
     * 本次上报金额(无税)
     */
    public java.math.BigDecimal getQuoteMny() {
        return quoteMny;
    }

    /**
     * 本次上报金额(无税)
     */
    public void setQuoteMny(java.math.BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }
    /**
     * 本次上报金额
     */
    public java.math.BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    /**
     * 本次上报金额
     */
    public void setQuoteTaxMny(java.math.BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 部门id
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 部门id
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 批复时间
     */
    public java.util.Date getReplyDate() {
        return replyDate;
    }

    /**
     * 批复时间
     */
    public void setReplyDate(java.util.Date replyDate) {
        this.replyDate = replyDate;
    }
    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public Integer getReplyStatus() {
        return replyStatus;
    }

    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public void setReplyStatus(Integer replyStatus) {
        this.replyStatus = replyStatus;
    }
    /**
     * 本次批复金额(无税)
     */
    public java.math.BigDecimal getReplyMny() {
        return replyMny;
    }

    /**
     * 本次批复金额(无税)
     */
    public void setReplyMny(java.math.BigDecimal replyMny) {
        this.replyMny = replyMny;
    }
    /**
     * 本次批复金额
     */
    public java.math.BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    /**
     * 本次批复金额
     */
    public void setReplyTaxMny(java.math.BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 对甲报量子表
     */
    public List<QuoteDetailVO> getDetailList() {
        return detailList;
    }

    /**
     * 对甲报量子表
     */
    public void setDetailList(List<QuoteDetailVO> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getAppliedTaxMny() {
        return appliedTaxMny;
    }

    public void setAppliedTaxMny(BigDecimal appliedTaxMny) {
        this.appliedTaxMny = appliedTaxMny;
    }

    public BigDecimal getAppliedMny() {
        return appliedMny;
    }

    public void setAppliedMny(BigDecimal appliedMny) {
        this.appliedMny = appliedMny;
    }

    public BigDecimal getResidueTaxMny() {
        return residueTaxMny;
    }

    public void setResidueTaxMny(BigDecimal residueTaxMny) {
        this.residueTaxMny = residueTaxMny;
    }

    public Date getProductionAscriptionYears() {
        return productionAscriptionYears;
    }

    public void setProductionAscriptionYears(Date productionAscriptionYears) {
        this.productionAscriptionYears = productionAscriptionYears;
    }

    public Integer getProductionContain() {
        return productionContain;
    }

    public void setProductionContain(Integer productionContain) {
        this.productionContain = productionContain;
    }

    public BigDecimal getConstructionBudgetMny() {
        return constructionBudgetMny;
    }

    public void setConstructionBudgetMny(BigDecimal constructionBudgetMny) {
        this.constructionBudgetMny = constructionBudgetMny;
    }

    public BigDecimal getContractPaymentRate() {
        return contractPaymentRate;
    }

    public void setContractPaymentRate(BigDecimal contractPaymentRate) {
        this.contractPaymentRate = contractPaymentRate;
    }

    public BigDecimal getSumCheckProduction() {
        return sumCheckProduction;
    }

    public void setSumCheckProduction(BigDecimal sumCheckProduction) {
        this.sumCheckProduction = sumCheckProduction;
    }

    public BigDecimal getProductionContainClaimMny() {
        return productionContainClaimMny;
    }

    public void setProductionContainClaimMny(BigDecimal productionContainClaimMny) {
        this.productionContainClaimMny = productionContainClaimMny;
    }

    public BigDecimal getCheckProductionCompany() {
        return checkProductionCompany;
    }

    public void setCheckProductionCompany(BigDecimal checkProductionCompany) {
        this.checkProductionCompany = checkProductionCompany;
    }

    public BigDecimal getCheckProductionGroup() {
        return checkProductionGroup;
    }

    public void setCheckProductionGroup(BigDecimal checkProductionGroup) {
        this.checkProductionGroup = checkProductionGroup;
    }

    public BigDecimal getCompletedNotApprovalProduction() {
        return completedNotApprovalProduction;
    }

    public void setCompletedNotApprovalProduction(BigDecimal completedNotApprovalProduction) {
        this.completedNotApprovalProduction = completedNotApprovalProduction;
    }

    public BigDecimal getMonthReceivableEngineeringMny() {
        return monthReceivableEngineeringMny;
    }

    public void setMonthReceivableEngineeringMny(BigDecimal monthReceivableEngineeringMny) {
        this.monthReceivableEngineeringMny = monthReceivableEngineeringMny;
    }

    public BigDecimal getSumReceivableEngineeringMny() {
        return sumReceivableEngineeringMny;
    }

    public void setSumReceivableEngineeringMny(BigDecimal sumReceivableEngineeringMny) {
        this.sumReceivableEngineeringMny = sumReceivableEngineeringMny;
    }

    public BigDecimal getForecastProductionCompany() {
        return forecastProductionCompany;
    }

    public void setForecastProductionCompany(BigDecimal forecastProductionCompany) {
        this.forecastProductionCompany = forecastProductionCompany;
    }

    public BigDecimal getForecastProductionGroup() {
        return forecastProductionGroup;
    }

    public void setForecastProductionGroup(BigDecimal forecastProductionGroup) {
        this.forecastProductionGroup = forecastProductionGroup;
    }

    public BigDecimal getReportProduceManagementProduction() {
        return reportProduceManagementProduction;
    }

    public void setReportProduceManagementProduction(BigDecimal reportProduceManagementProduction) {
        this.reportProduceManagementProduction = reportProduceManagementProduction;
    }

    public Integer getReplyStatusRedFlag() {
        return replyStatusRedFlag;
    }

    public void setReplyStatusRedFlag(Integer replyStatusRedFlag) {
        this.replyStatusRedFlag = replyStatusRedFlag;
    }

    public String getProductionContainName() {
        return productionContainName;
    }

    public void setProductionContainName(String productionContainName) {
        this.productionContainName = productionContainName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public BigDecimal getRemainderReportProduceMny() {
        return remainderReportProduceMny;
    }

    public void setRemainderReportProduceMny(BigDecimal remainderReportProduceMny) {
        this.remainderReportProduceMny = remainderReportProduceMny;
    }

    public BigDecimal getLastCheckProductionCompany() {
        return lastCheckProductionCompany;
    }

    public void setLastCheckProductionCompany(BigDecimal lastCheckProductionCompany) {
        this.lastCheckProductionCompany = lastCheckProductionCompany;
    }

    public BigDecimal getLastCheckProductionGroup() {
        return lastCheckProductionGroup;
    }

    public void setLastCheckProductionGroup(BigDecimal lastCheckProductionGroup) {
        this.lastCheckProductionGroup = lastCheckProductionGroup;
    }

    public Date getPredictCompleteDate() {
        return predictCompleteDate;
    }

    public void setPredictCompleteDate(Date predictCompleteDate) {

        this.predictCompleteDate = predictCompleteDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProductionTypeId() {
        return productionTypeId;
    }
    @ReferDeserialTransfer
    public void setProductionTypeId(Long productionTypeId) {
        this.productionTypeId = productionTypeId;
    }
}
