package com.ejianc.business.pro.income.api;

import com.ejianc.business.pro.income.hystrix.ProincomeBudgetHystrix;
import com.ejianc.business.pro.income.vo.BudgetReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

@FeignClient(name= "ejc-proincome-web", url="${common.env.feign-client-url}", path="ejc-proincome-web", fallback = ProincomeBudgetHystrix.class)
public interface IProincomeBudgetApi {

    /**
     * 根据项目查项目预算金额
     * @param projectId
     * @param endDate
     * @return
     */
    @GetMapping("/api/budgetApi/querySumBudgetMny")
    public CommonResponse<List<BudgetReportVO>> querySumBudgetMny(@RequestParam(value = "projectId") Long projectId,
                                                                  @RequestParam(value = "beginPeriod", required = false) String beginPeriod,
                                                                  @RequestParam(value = "endDate", required = false) String endDate);
    @GetMapping("/api/budgetApi/querySumBudgetMnyNew")
    public CommonResponse<List<BudgetReportVO>> querySumBudgetMnyNew(@RequestParam(value = "projectId") Long projectId,
                                                                     @RequestParam(value = "beginPeriod", required = false) String beginPeriod,
                                                                     @RequestParam(value = "endDate", required = false) String endDate);
    @GetMapping("/api/budgetApi/queryAllBudgetMny")
    public CommonResponse<BigDecimal> queryAllBudgetMny(@RequestParam(value = "projectId") Long projectId);
}
