package com.ejianc.business.pro.income.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.pro.income.utils.ITreeNodeB;
import com.ejianc.business.pub.tax.ITaxCalculate;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 其他项清单
 * 
 * @author generator
 * 
 */
public class BudgetOtherVO extends BaseVO implements ITreeNodeB,ITaxCalculate {
    private static final long serialVersionUID = 1L;
    
    private Long budgetId; // 预算书主键
    private String detailIndex; // 序号
    private Long parentId; // 父ID
    private String otherCode; // 编码
    private String otherName; // 名称
    private String otherFeature; // 特征
    private String otherUnit; // 单位
    private BigDecimal otherNum; // 工程量
    private BigDecimal otherTaxRate; // 税率
    private BigDecimal otherPrice; // 综合单价(无税)
    private BigDecimal otherTaxPrice; // 综合单价(含税)
    private BigDecimal otherMny; // 合价(无税)
    private BigDecimal otherTaxMny; // 合价(含税)
    private BigDecimal otherTax; // 税额
    private String otherMemo; // 备注
    private Boolean leafFlag; // 是否末级
    private List<BudgetDetailVO> detailVos = new ArrayList<>(); // 清单明细

    private String tid;
    private String tpid;
    private String indexCode;//序号
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;
    private Long otherSubjectId; // 成本科目id
    private String otherSubjectName; // 成本科目名称

    private String otherCompositiveCoefficientName; //综合系数名称
    private Long otherCompositiveCoefficientId; //综合系数id
    private BigDecimal otherCompositiveCoefficient; //综合系数

    private Integer otherPriceType; //价税计算类型：0-无税优先， 1-含税优先

    private String otherItemType; //清单类型  用于导入数据区分

    private List<ITreeNodeB> children;

    public Integer getOtherPriceType() {
        return otherPriceType;
    }

    public void setOtherPriceType(Integer otherPriceType) {
        this.otherPriceType = otherPriceType;
    }

    public String getOtherItemType() {
        return otherItemType;
    }

    public void setOtherItemType(String otherItemType) {
        this.otherItemType = otherItemType;
    }

    public String getOtherCompositiveCoefficientName() {
        return otherCompositiveCoefficientName;
    }

    public void setOtherCompositiveCoefficientName(String otherCompositiveCoefficientName) {
        this.otherCompositiveCoefficientName = otherCompositiveCoefficientName;
    }

    @ReferSerialTransfer(referCode = "pro-income-coefficient")
    public Long getOtherCompositiveCoefficientId() {
        return otherCompositiveCoefficientId;
    }

    @ReferDeserialTransfer
    public void setOtherCompositiveCoefficientId(Long otherCompositiveCoefficientId) {
        this.otherCompositiveCoefficientId = otherCompositiveCoefficientId;
    }

    public BigDecimal getOtherCompositiveCoefficient() {
        return otherCompositiveCoefficient;
    }

    public void setOtherCompositiveCoefficient(BigDecimal otherCompositiveCoefficient) {
        this.otherCompositiveCoefficient = otherCompositiveCoefficient;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    @ReferSerialTransfer(referCode="subject-project-org-ref")
    public Long getOtherSubjectId() {
        return otherSubjectId;
    }
    @ReferDeserialTransfer
    public void setOtherSubjectId(Long otherSubjectId) {
        this.otherSubjectId = otherSubjectId;
    }

    public String getOtherSubjectName() {
        return otherSubjectName;
    }

    public void setOtherSubjectName(String otherSubjectName) {
        this.otherSubjectName = otherSubjectName;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public List<BudgetDetailVO> getDetailVos() {
        return detailVos;
    }

    public void setDetailVos(List<BudgetDetailVO> detailVos) {
        this.detailVos = detailVos;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }
    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 编码
     */
    public String getOtherCode() {
        return otherCode;
    }

    /**
     * 编码
     */
    public void setOtherCode(String otherCode) {
        this.otherCode = otherCode;
    }
    /**
     * 名称
     */
    public String getOtherName() {
        return otherName;
    }

    /**
     * 名称
     */
    public void setOtherName(String otherName) {
        this.otherName = otherName;
    }
    /**
     * 特征
     */
    public String getOtherFeature() {
        return otherFeature;
    }

    /**
     * 特征
     */
    public void setOtherFeature(String otherFeature) {
        this.otherFeature = otherFeature;
    }
    /**
     * 单位
     */
    public String getOtherUnit() {
        return otherUnit;
    }

    /**
     * 单位
     */
    public void setOtherUnit(String otherUnit) {
        this.otherUnit = otherUnit;
    }
    /**
     * 工程量
     */
    public BigDecimal getOtherNum() {
        return otherNum;
    }

    /**
     * 工程量
     */
    public void setOtherNum(BigDecimal otherNum) {
        this.otherNum = otherNum;
    }
    /**
     * 税率
     */
    public BigDecimal getOtherTaxRate() {
        return otherTaxRate;
    }

    /**
     * 税率
     */
    public void setOtherTaxRate(BigDecimal otherTaxRate) {
        this.otherTaxRate = otherTaxRate;
    }
    /**
     * 综合单价(无税)
     */
    public BigDecimal getOtherPrice() {
        return otherPrice;
    }

    /**
     * 综合单价(无税)
     */
    public void setOtherPrice(BigDecimal otherPrice) {
        this.otherPrice = otherPrice;
    }
    /**
     * 综合单价(含税)
     */
    public BigDecimal getOtherTaxPrice() {
        return otherTaxPrice;
    }

    /**
     * 综合单价(含税)
     */
    public void setOtherTaxPrice(BigDecimal otherTaxPrice) {
        this.otherTaxPrice = otherTaxPrice;
    }
    /**
     * 合价(无税)
     */
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    /**
     * 合价(无税)
     */
    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    /**
     * 合价(含税)
     */
    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }
    /**
     * 备注
     */
    public String getOtherMemo() {
        return otherMemo;
    }

    /**
     * 备注
     */
    public void setOtherMemo(String otherMemo) {
        this.otherMemo = otherMemo;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    @Override
    public String[] getPriceArray() {
        return new String[]{"otherPrice"};
    }

    @Override
    public String[] getTaxPriceArray() {
        return new String[]{"otherTaxPrice"};
    }

    @Override
    public String[] getNumArray() {
        return new String[]{"otherNum"};
    }

    @Override
    public String[] getMoneyArray() {
        return new String[]{"otherMny"};
    }

    @Override
    public String[] getTaxMoneyArray() {
        return new String[]{"otherTaxMny"};
    }

    @Override
    public String[] getTaxRateArray() {
        return new String[]{"otherTaxRate"};
    }

    @Override
    public String[] getTaxArray() {
        return new String[]{"otherTax"};
    }
}
