package com.ejianc.business.pro.income.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 施工合同评审
 *
 * @author generator
 */
public class ContractReviewVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private String contractName; // 工程名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private java.math.BigDecimal contractMny; // 合同金额(不含税)
    private java.math.BigDecimal contractTaxMny; // 合同金额
    private Long customerId; // 合同甲方
    private String customerName; // 合同甲方名称
    private Long supplierId; // 合同乙方
    private String supplierName; // 合同乙方名称
    private String constructionPartner; // 联合体（牵头人）
    private String constructionPartnerMember; // 联合体（成员）
    private java.math.BigDecimal taxRate; // 合同税率
    private java.math.BigDecimal taxMny; // 税额
    private Long contractType; // 合同类型
    private String contractTypeName;//合同类型名称
    private Long contractValuationType; // 合同计价形式，档案
    private java.math.BigDecimal builtArea; // 建筑面积(㎡)
    private String contractPartyc; // 合同丙方
    private java.math.BigDecimal conjoinedContractTotalMny; // 联合体（牵头人）造价
    private java.math.BigDecimal conjoinedContractMemberMny; // 联合体（成员）造价
    private Long architectId; // 建造师
    private String architectName; // 建造师名称
    private Long managerId; // 项目责任人
    private String managerName; // 项目责任人名称
    private Long engineeringTypeId; // 工程类型
    private String engineeringTypeName; // 工程类型名称
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算
    private String address; // 项目地址
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String briefDescription; // 补充协议简要说明
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private String mainContractName; // 主合同名称
    private Long mainContractId; // 主合同ID
    private String mainContractCode; // 主合同编码
    private String contractScope; // 承包范围
    private String fundsSource; // 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 合同竣工日期
    private Integer schedule; // 工期
    private String qualityRequirement; // 质量要求
    private String safetyGoal; // 安全目标
    private String civilizationConstructionGoal; // 文明施工目标
    private Integer advancePayment; // 预付款：0-无，1-有
    private Integer progressPayment; // 工程进度款支付：0-按节点支付，1-按月支付
    private String nodePayment; // 按节点支付
    private String monthPayment; // 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
    private String qualityDeposit; // 质量保证金：0-3%，1-5%
    private String priceAdjustment; // 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
    private String priceAdjustmentDetail; // 其他方式：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
    private String breach; // 违约


    private java.lang.String advancePaymentInfo; // 预付款信息
    private java.lang.String priceAdjustmentSecond; // 价格调整2：0-采用造价信息进行价格调整，1-采用价格指数进行价格调整，2-专用合同条款约定的其他方式
    private java.lang.String priceAdjustmentThird; // 价格调整3：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
    private java.lang.String priceAdjustmentInfo; // 法律变化引起的调整信息
    private java.lang.String priceAdjustmentThirdTwo; // 采用价格指数进行价格调整信息
    private java.lang.String priceAdjustmentThirdThree; // 专用合同条款约定的其他方式信息
    private String otherTerms; // 其它条款
    private String billStateName; // 单据状态名称
    private Long contractualModel; // 承包模式
    private Long bearType; // 承揽方式

    private Long fundsSourceId; // 资金来源(自定义档案)
    private Long constructId;//建设单位
    private String constructName;//建设单位
    private java.lang.String priceAdjustmentThirdOne; // 采用价格信息进行价格调整信息
    private String paymentTerm; //支付条款描述
    private BigDecimal fixedPaymentRate; //固定付款比例

    private Integer filingFlag; // 归档状态（0：未归档，1：合同登记归档，2：单据归档）
    private Long filingId; // 归档文件id
    private Integer paymentNum; // 付款次数
    private Integer sealFlag; // 用印状态（0：未用印，1：已用印）

    private Integer cancelFlag; // 作废状态（0：未作废，1：已作废）
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date sealDate; // 用印时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date filingDate; // 归档时间

    private Long sealId;//用印id;
    private String oldClause;//旧条款内容
    private String newClause;//新条款内容
    private String differentClause;//新旧条款内容区别
    private String abandonBillCode;//作废单据编号
    private String oldReviewCode;//原版本评审编号
    private Long oldReviewId;//原版本评审id
    private Integer useStatus;//在用状态
    private Long approveType;//审批类型
    private String approveTypeName;//审批类型名称
    private String revision;//修订版本
    private String modifyReason;//调修详细原因
    private String modifyType;//调修类型
    private Long abandonType;//作废类型
    private String abandonTypeName;//作废类型名称
    private String abandonReason;//作废原因
    private String explainReason;//情况简要说明及责任承诺书


    private List<ContractReviewPayRemarkVO> reviewPayRemarkList = new ArrayList<>(); // 施工合同补录-付款节点
    private List<ContractReviewPayNodeVO> reviewPayNodeList = new ArrayList<>(); // 施工合同补录-质保金节点


    public List<ContractReviewPayRemarkVO> getReviewPayRemarkList() {
        return reviewPayRemarkList;
    }

    public void setReviewPayRemarkList(List<ContractReviewPayRemarkVO> reviewPayRemarkList) {
        this.reviewPayRemarkList = reviewPayRemarkList;
    }

    public List<ContractReviewPayNodeVO> getReviewPayNodeList() {
        return reviewPayNodeList;
    }

    public void setReviewPayNodeList(List<ContractReviewPayNodeVO> reviewPayNodeList) {
        this.reviewPayNodeList = reviewPayNodeList;
    }

    public Date getSealDate() {
        return sealDate;
    }

    public void setSealDate(Date sealDate) {
        this.sealDate = sealDate;
    }

    public Date getFilingDate() {
        return filingDate;
    }

    public void setFilingDate(Date filingDate) {
        this.filingDate = filingDate;
    }

    public Integer getSealFlag() {
        return sealFlag;
    }

    public void setSealFlag(Integer sealFlag) {
        this.sealFlag = sealFlag;
    }

    public Integer getCancelFlag() {
        return cancelFlag;
    }

    public void setCancelFlag(Integer cancelFlag) {
        this.cancelFlag = cancelFlag;
    }

    public Integer getPaymentNum() {
        return paymentNum;
    }

    public void setPaymentNum(Integer paymentNum) {
        this.paymentNum = paymentNum;
    }

    public Integer getFilingFlag() {
        return filingFlag;
    }

    public void setFilingFlag(Integer filingFlag) {
        this.filingFlag = filingFlag;
    }

    public Long getFilingId() {
        return filingId;
    }

    public void setFilingId(Long filingId) {
        this.filingId = filingId;
    }

    private List<ContractReviewVO> children;

    public String getPriceAdjustmentThirdOne() {
        return priceAdjustmentThirdOne;
    }

    public void setPriceAdjustmentThirdOne(String priceAdjustmentThirdOne) {
        this.priceAdjustmentThirdOne = priceAdjustmentThirdOne;
    }

    public String getPaymentTerm() {
        return paymentTerm;
    }

    public void setPaymentTerm(String paymentTerm) {
        this.paymentTerm = paymentTerm;
    }

    public BigDecimal getFixedPaymentRate() {
        return fixedPaymentRate;
    }

    public void setFixedPaymentRate(BigDecimal fixedPaymentRate) {
        this.fixedPaymentRate = fixedPaymentRate;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 工程名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 工程名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    /**
     * 项目
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * 组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    /**
     * 合同金额(不含税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    /**
     * 合同金额
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    /**
     * 合同甲方
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 合同甲方
     */
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    /**
     * 合同甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 合同甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    /**
     * 合同乙方
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 合同乙方
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    /**
     * 合同乙方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 合同乙方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    /**
     * 联合体（牵头人）
     */
    public String getConstructionPartner() {
        return constructionPartner;
    }

    /**
     * 联合体（牵头人）
     */
    public void setConstructionPartner(String constructionPartner) {
        this.constructionPartner = constructionPartner;
    }
    /**
     * 联合体（成员）
     */
    public String getConstructionPartnerMember() {
        return constructionPartnerMember;
    }
    /**
     * 联合体（成员）
     */
    public void setConstructionPartnerMember(String constructionPartnerMember) {
        this.constructionPartnerMember = constructionPartnerMember;
    }

    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * 税额
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    /**
     * 合同类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    /**
     * 合同类型名称
     */
    public String getContractTypeName() {
        return contractTypeName;
    }

    /**
     * 合同类型名称
     */
    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    /**
     * 合同计价形式，档案
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式，档案
     */
    @ReferDeserialTransfer
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    /**
     * 建筑面积(㎡)
     */
    public java.math.BigDecimal getBuiltArea() {
        return builtArea;
    }

    /**
     * 建筑面积(㎡)
     */
    public void setBuiltArea(java.math.BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    /**
     * 合同丙方
     */
    public String getContractPartyc() {
        return contractPartyc;
    }

    /**
     * 合同丙方
     */
    public void setContractPartyc(String contractPartyc) {
        this.contractPartyc = contractPartyc;
    }

    /**
     * 联合体（牵头人）造价
     */
    public java.math.BigDecimal getConjoinedContractTotalMny() {
        return conjoinedContractTotalMny;
    }

    /**
     * 联合体（牵头人）造价
     */
    public void setConjoinedContractTotalMny(java.math.BigDecimal conjoinedContractTotalMny) {
        this.conjoinedContractTotalMny = conjoinedContractTotalMny;
    }
    /**
     * 联合体（成员）造价
     */
    public BigDecimal getConjoinedContractMemberMny() {
        return conjoinedContractMemberMny;
    }
    /**
     * 联合体（成员）造价
     */
    public void setConjoinedContractMemberMny(BigDecimal conjoinedContractMemberMny) {
        this.conjoinedContractMemberMny = conjoinedContractMemberMny;
    }

    /**
     * 建造师
     */
    @ReferSerialTransfer(referCode = "JzsInfo")
    public Long getArchitectId() {
        return architectId;
    }

    /**
     * 建造师
     */
    @ReferDeserialTransfer
    public void setArchitectId(Long architectId) {
        this.architectId = architectId;
    }

    /**
     * 建造师名称
     */
    public String getArchitectName() {
        return architectName;
    }

    /**
     * 建造师名称
     */
    public void setArchitectName(String architectName) {
        this.architectName = architectName;
    }

    /**
     * 项目责任人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getManagerId() {
        return managerId;
    }

    /**
     * 项目责任人
     */
    @ReferDeserialTransfer
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }

    /**
     * 项目责任人名称
     */
    public String getManagerName() {
        return managerName;
    }

    /**
     * 项目责任人名称
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    /**
     * 工程类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    /**
     * 工程类型
     */
    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }

    /**
     * 工程类型名称
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类型名称
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public String getSettlementType() {
        return settlementType;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    /**
     * 项目地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 项目地址
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    /**
     * 补充协议简要说明
     */
    public String getBriefDescription() {
        return briefDescription;
    }

    /**
     * 补充协议简要说明
     */
    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    /**
     * 承包范围
     */
    public String getContractScope() {
        return contractScope;
    }

    /**
     * 承包范围
     */
    public void setContractScope(String contractScope) {
        this.contractScope = contractScope;
    }

    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public String getFundsSource() {
        return fundsSource;
    }

    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }

    /**
     * 合同开工日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 合同开工日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }

    /**
     * 合同竣工日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 合同竣工日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }

    /**
     * 工期
     */
    public Integer getSchedule() {
        return schedule;
    }

    /**
     * 工期
     */
    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    /**
     * 质量要求
     */
    public String getQualityRequirement() {
        return qualityRequirement;
    }

    /**
     * 质量要求
     */
    public void setQualityRequirement(String qualityRequirement) {
        this.qualityRequirement = qualityRequirement;
    }

    /**
     * 安全目标
     */
    public String getSafetyGoal() {
        return safetyGoal;
    }

    /**
     * 安全目标
     */
    public void setSafetyGoal(String safetyGoal) {
        this.safetyGoal = safetyGoal;
    }

    /**
     * 文明施工目标
     */
    public String getCivilizationConstructionGoal() {
        return civilizationConstructionGoal;
    }

    /**
     * 文明施工目标
     */
    public void setCivilizationConstructionGoal(String civilizationConstructionGoal) {
        this.civilizationConstructionGoal = civilizationConstructionGoal;
    }

    /**
     * 预付款：0-无，1-有
     */
    public Integer getAdvancePayment() {
        return advancePayment;
    }

    /**
     * 预付款：0-无，1-有
     */
    public void setAdvancePayment(Integer advancePayment) {
        this.advancePayment = advancePayment;
    }

    /**
     * 工程进度款支付：0-按节点支付，2-按月支付
     */
    public Integer getProgressPayment() {
        return progressPayment;
    }

    /**
     * 工程进度款支付：0-按节点支付，2-按月支付
     */
    public void setProgressPayment(Integer progressPayment) {
        this.progressPayment = progressPayment;
    }

    /**
     * 按节点支付
     */
    public String getNodePayment() {
        return nodePayment;
    }

    /**
     * 按节点支付
     */
    public void setNodePayment(String nodePayment) {
        this.nodePayment = nodePayment;
    }

    /**
     * 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
     */
    public String getMonthPayment() {
        return monthPayment;
    }

    /**
     * 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
     */
    public void setMonthPayment(String monthPayment) {
        this.monthPayment = monthPayment;
    }

    /**
     * 质量保证金：0-3%，1-5%
     */
    public String getQualityDeposit() {
        return qualityDeposit;
    }

    /**
     * 质量保证金：0-3%，1-5%
     */
    public void setQualityDeposit(String qualityDeposit) {
        this.qualityDeposit = qualityDeposit;
    }

    /**
     * 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
     */
    public String getPriceAdjustment() {
        return priceAdjustment;
    }

    /**
     * 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
     */
    public void setPriceAdjustment(String priceAdjustment) {
        this.priceAdjustment = priceAdjustment;
    }

    /**
     * 其他方式：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
     */
    public String getPriceAdjustmentDetail() {
        return priceAdjustmentDetail;
    }

    /**
     * 其他方式：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
     */
    public void setPriceAdjustmentDetail(String priceAdjustmentDetail) {
        this.priceAdjustmentDetail = priceAdjustmentDetail;
    }

    /**
     * 违约
     */
    public String getBreach() {
        return breach;
    }

    /**
     * 违约
     */
    public void setBreach(String breach) {
        this.breach = breach;
    }

    public String getAdvancePaymentInfo() {
        return advancePaymentInfo;
    }

    public void setAdvancePaymentInfo(String advancePaymentInfo) {
        this.advancePaymentInfo = advancePaymentInfo;
    }

    public String getPriceAdjustmentSecond() {
        return priceAdjustmentSecond;
    }

    public void setPriceAdjustmentSecond(String priceAdjustmentSecond) {
        this.priceAdjustmentSecond = priceAdjustmentSecond;
    }

    public String getPriceAdjustmentThird() {
        return priceAdjustmentThird;
    }

    public void setPriceAdjustmentThird(String priceAdjustmentThird) {
        this.priceAdjustmentThird = priceAdjustmentThird;
    }

    public String getPriceAdjustmentInfo() {
        return priceAdjustmentInfo;
    }

    public void setPriceAdjustmentInfo(String priceAdjustmentInfo) {
        this.priceAdjustmentInfo = priceAdjustmentInfo;
    }

    public String getPriceAdjustmentThirdTwo() {
        return priceAdjustmentThirdTwo;
    }

    public void setPriceAdjustmentThirdTwo(String priceAdjustmentThirdTwo) {
        this.priceAdjustmentThirdTwo = priceAdjustmentThirdTwo;
    }

    public String getPriceAdjustmentThirdThree() {
        return priceAdjustmentThirdThree;
    }

    public void setPriceAdjustmentThirdThree(String priceAdjustmentThirdThree) {
        this.priceAdjustmentThirdThree = priceAdjustmentThirdThree;
    }

    public String getOtherTerms() {
        return otherTerms;
    }

    public void setOtherTerms(String otherTerms) {
        this.otherTerms = otherTerms;
    }

    /**
     * 单据状态名称
     */
    public String getBillStateName() {
        return billStateName;
    }

    /**
     * 单据状态名称
     */
    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<ContractReviewVO> getChildren() {
        return children;
    }

    public void setChildren(List<ContractReviewVO> children) {
        this.children = children;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractualModel() {
        return contractualModel;
    }

    @ReferDeserialTransfer
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    /**
     * 承揽方式
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBearType() {
        return bearType;
    }

    /**
     * 承揽方式
     */
    @ReferDeserialTransfer
    public void setBearType(Long bearType) {
        this.bearType = bearType;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFundsSourceId() {
        return fundsSourceId;
    }

    @ReferDeserialTransfer
    public void setFundsSourceId(Long fundsSourceId) {
        this.fundsSourceId = fundsSourceId;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getConstructId() {
        return constructId;
    }

    @ReferDeserialTransfer
    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public String getOldClause() {
        return oldClause;
    }

    public void setOldClause(String oldClause) {
        this.oldClause = oldClause;
    }

    public String getNewClause() {
        return newClause;
    }

    public void setNewClause(String newClause) {
        this.newClause = newClause;
    }

    public String getDifferentClause() {
        return differentClause;
    }

    public void setDifferentClause(String differentClause) {
        this.differentClause = differentClause;
    }

    public String getAbandonBillCode() {
        return abandonBillCode;
    }

    public void setAbandonBillCode(String abandonBillCode) {
        this.abandonBillCode = abandonBillCode;
    }

    public String getOldReviewCode() {
        return oldReviewCode;
    }

    public void setOldReviewCode(String oldReviewCode) {
        this.oldReviewCode = oldReviewCode;
    }

    public Integer getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(Integer useStatus) {
        this.useStatus = useStatus;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getApproveType() {
        return approveType;
    }

    @ReferDeserialTransfer
    public void setApproveType(Long approveType) {
        this.approveType = approveType;
    }

    public String getApproveTypeName() {
        return approveTypeName;
    }

    public void setApproveTypeName(String approveTypeName) {
        this.approveTypeName = approveTypeName;
    }

    public String getRevision() {
        return revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getModifyReason() {
        return modifyReason;
    }

    public void setModifyReason(String modifyReason) {
        this.modifyReason = modifyReason;
    }

    public String getModifyType() {
        return modifyType;
    }

    public void setModifyType(String modifyType) {
        this.modifyType = modifyType;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getAbandonType() {
        return abandonType;
    }
    @ReferDeserialTransfer
    public void setAbandonType(Long abandonType) {
        this.abandonType = abandonType;
    }

    public String getAbandonTypeName() {
        return abandonTypeName;
    }

    public void setAbandonTypeName(String abandonTypeName) {
        this.abandonTypeName = abandonTypeName;
    }

    public String getAbandonReason() {
        return abandonReason;
    }

    public void setAbandonReason(String abandonReason) {
        this.abandonReason = abandonReason;
    }

    public String getExplainReason() {
        return explainReason;
    }

    public void setExplainReason(String explainReason) {
        this.explainReason = explainReason;
    }

    public Long getOldReviewId() {
        return oldReviewId;
    }

    public void setOldReviewId(Long oldReviewId) {
        this.oldReviewId = oldReviewId;
    }
}
