package com.ejianc.business.pro.g9.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.pro.income.vo.SettleReportDetailVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 结算报审-G9
 * 
 * @author generator
 * 
 */
public class SettleReportG9VO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long projectId; // 项目
    private String projectName; // 
    private String projectCode; // 项目编号
    private Long contractId; // 合同
    private String contractCode; // 合同编号
    private String contractName; // 
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; //
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 合同竣工日期
    private BigDecimal contractMny; // 合同签订金额(不含税)
    private BigDecimal contractTaxMny; // 合同签订金额
    private Long contractValuationType; // 合同计价形式
    private BigDecimal contractPromisePaymentRate; // 合同约定收款比例
    private BigDecimal sumProductionMny; // 累计产值(无税)
    private BigDecimal sumProductionTaxMny; // 累计产值
    private BigDecimal sumCostMny; // 累计成本(无税)
    private BigDecimal sumCostTaxMny; // 累计成本
    private BigDecimal sumReceiptMny; // 累计收款金额(无税)
    private BigDecimal sumReceiptTaxMny; // 累计收款金额
    private BigDecimal reportSettleMny; // 报审结算金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reportDate; // 报审日期
    private BigDecimal subtractTaxRate; // 合同约定审减率
    private BigDecimal predictCheckMny; // 预计审定金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date predictCheckDate; // 预计审定日期
    private BigDecimal materialMny; // 其中甲供材金额
    private String checkUnit; // 审核单位
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String memo; // 备注
    private BigDecimal reportSettleTaxMny; // 报审结算金额(含税)
    private BigDecimal taxRate; // 税率
    private BigDecimal tax; // 税额
    private String settleName; // 结算名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date realStartDate; // 实际开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date realEndDate; // 实际竣工日期
    private String reportSettleName; // 报审名称
    private String gdStatus; // 归档状态(1-已归档 2-未归档)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date gdDate; // 归档日期
    private String closeFlag; // 是否已成本关门(1-是 2-否)
    private BigDecimal preTotalCost; // 预计总成本
    private String reportProgress; // 报审阶段
    private Long projectPartId; // 执行标段id
    private Long projectLeaderId; // 项目负责人
    private String projectLeaderName; // 项目负责人
    private Long businessManager; // 经营对接人
    private String businessManagerName; // 经营对接人

    private List<SettleReportFollowG9VO> followVOS;

    public String getReportSettleName() {
        return reportSettleName;
    }

    public void setReportSettleName(String reportSettleName) {
        this.reportSettleName = reportSettleName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="ejc-share-zzyj-project-ex001")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode = "nbzz-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractValuationType() {
        return contractValuationType;
    }
    @ReferDeserialTransfer
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    public BigDecimal getContractPromisePaymentRate() {
        return contractPromisePaymentRate;
    }

    public void setContractPromisePaymentRate(BigDecimal contractPromisePaymentRate) {
        this.contractPromisePaymentRate = contractPromisePaymentRate;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    public BigDecimal getSumCostMny() {
        return sumCostMny;
    }

    public void setSumCostMny(BigDecimal sumCostMny) {
        this.sumCostMny = sumCostMny;
    }
    public BigDecimal getSumCostTaxMny() {
        return sumCostTaxMny;
    }

    public void setSumCostTaxMny(BigDecimal sumCostTaxMny) {
        this.sumCostTaxMny = sumCostTaxMny;
    }
    public BigDecimal getSumReceiptMny() {
        return sumReceiptMny;
    }

    public void setSumReceiptMny(BigDecimal sumReceiptMny) {
        this.sumReceiptMny = sumReceiptMny;
    }
    public BigDecimal getSumReceiptTaxMny() {
        return sumReceiptTaxMny;
    }

    public void setSumReceiptTaxMny(BigDecimal sumReceiptTaxMny) {
        this.sumReceiptTaxMny = sumReceiptTaxMny;
    }
    public BigDecimal getReportSettleMny() {
        return reportSettleMny;
    }

    public void setReportSettleMny(BigDecimal reportSettleMny) {
        this.reportSettleMny = reportSettleMny;
    }
    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    public BigDecimal getSubtractTaxRate() {
        return subtractTaxRate;
    }

    public void setSubtractTaxRate(BigDecimal subtractTaxRate) {
        this.subtractTaxRate = subtractTaxRate;
    }
    public BigDecimal getPredictCheckMny() {
        return predictCheckMny;
    }

    public void setPredictCheckMny(BigDecimal predictCheckMny) {
        this.predictCheckMny = predictCheckMny;
    }
    public Date getPredictCheckDate() {
        return predictCheckDate;
    }

    public void setPredictCheckDate(Date predictCheckDate) {
        this.predictCheckDate = predictCheckDate;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public String getCheckUnit() {
        return checkUnit;
    }

    public void setCheckUnit(String checkUnit) {
        this.checkUnit = checkUnit;
    }
    public String getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getReportSettleTaxMny() {
        return reportSettleTaxMny;
    }

    public void setReportSettleTaxMny(BigDecimal reportSettleTaxMny) {
        this.reportSettleTaxMny = reportSettleTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getSettleName() {
        return settleName;
    }

    public void setSettleName(String settleName) {
        this.settleName = settleName;
    }

    public Date getRealStartDate() {
        return realStartDate;
    }

    public void setRealStartDate(Date realStartDate) {
        this.realStartDate = realStartDate;
    }

    public Date getRealEndDate() {
        return realEndDate;
    }

    public void setRealEndDate(Date realEndDate) {
        this.realEndDate = realEndDate;
    }

    public String getGdStatus() {
        return gdStatus;
    }

    public void setGdStatus(String gdStatus) {
        this.gdStatus = gdStatus;
    }

    public Date getGdDate() {
        return gdDate;
    }

    public void setGdDate(Date gdDate) {
        this.gdDate = gdDate;
    }

    public String getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(String closeFlag) {
        this.closeFlag = closeFlag;
    }

    public BigDecimal getPreTotalCost() {
        return preTotalCost;
    }

    public void setPreTotalCost(BigDecimal preTotalCost) {
        this.preTotalCost = preTotalCost;
    }

    public String getReportProgress() {
        return reportProgress;
    }

    public void setReportProgress(String reportProgress) {
        this.reportProgress = reportProgress;
    }
    @ReferSerialTransfer(referCode="pro-part")
    public Long getProjectPartId() {
        return projectPartId;
    }
    @ReferDeserialTransfer
    public void setProjectPartId(Long projectPartId) {
        this.projectPartId = projectPartId;
    }

    public List<SettleReportFollowG9VO> getFollowVOS() {
        return followVOS;
    }

    public void setFollowVOS(List<SettleReportFollowG9VO> followVOS) {
        this.followVOS = followVOS;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getProjectLeaderId() {
        return projectLeaderId;
    }
    @ReferDeserialTransfer
    public void setProjectLeaderId(Long projectLeaderId) {
        this.projectLeaderId = projectLeaderId;
    }

    public String getProjectLeaderName() {
        return projectLeaderName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public void setProjectLeaderName(String projectLeaderName) {
        this.projectLeaderName = projectLeaderName;
    }
    @ReferDeserialTransfer
    public Long getBusinessManager() {
        return businessManager;
    }

    public void setBusinessManager(Long businessManager) {
        this.businessManager = businessManager;
    }

    public String getBusinessManagerName() {
        return businessManagerName;
    }

    public void setBusinessManagerName(String businessManagerName) {
        this.businessManagerName = businessManagerName;
    }
}
