package com.ejianc.business.pro.g9.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 工程定案G9
 *
 * @author generator
 *
 */
public class FinalizedG9VO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ConvertField
    private String billCode; // 单据编号
    @ConvertField
    private Integer billState; // 单据状态
    @ConvertField
    private Long projectId; // 项目
    @ConvertField
    private String projectName; // 项目名称
    @ConvertField
    private String projectCode; // 项目编号
    @ConvertField
    private Long contractId; // 合同
    @ConvertField
    private String contractCode; // 合同编号
    @ConvertField
    private String contractName; // 合同名称
    @ConvertField
    private Long orgId; // 组织
    @ConvertField
    private String orgCode; // 组织编码
    @ConvertField
    private String orgName; // 组织名称
    @ConvertField
    private Long parentOrgId; // 父级组织
    @ConvertField
    private String parentOrgCode; // 父级组织编码
    @ConvertField
    private String parentOrgName; // 父级组织名称
    private BigDecimal contractMny; // 合同签订金额(不含税)
    private BigDecimal contractTaxMny; // 合同签订金额
    private Long contractValuationType; // 合同计价形式
    private BigDecimal sumProductionMny; // 累计产值(无税)
    private BigDecimal sumProductionTaxMny; // 累计产值
    private BigDecimal sumCostMny; // 累计成本(无税)
    private BigDecimal sumCostTaxMny; // 累计成本
    private BigDecimal sumReceiptMny; // 累计收款金额(无税)
    private BigDecimal sumReceiptTaxMny; // 累计收款金额
    private String finalStage; // 定案阶段：1-一审，2-二审，3-三审，4-终审
    private BigDecimal reportSettleMny; // 报审结算金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reportDate; // 报审日期
    @ConvertField(targetField = "curMny")
    private BigDecimal checkMny; // 审定金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ConvertField(targetField = "settleDate")
    private Date checkDate; // 审定日期
    private BigDecimal subtractTaxRate; // 合同约定审减率
    private BigDecimal materialMny; // 其中甲供材金额
    private BigDecimal reviewSubtractRate; // 审减率
    private BigDecimal reviewSubtractMny; // 审减金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date returnDate; // 预计定案表返回日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startGuaranteeDate; // 保修期起算日
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endGuaranteeDate; // 防水保修期届满日
    private BigDecimal guaranteeRate; // 保修金比例
    private BigDecimal guaranteeMny; // 其中防水保修金额
    private BigDecimal totalEconomicBenefitRate; // 总经济效益率
    @ConvertField
    private Long employeeId; // 经办人
    @ConvertField
    private String employeeName; // 经办人名称
    @ConvertField(targetField = "departmentId")
    private Long deptId; // 经办部门
    @ConvertField(targetField = "departmentName")
    private String deptName; // 经办部门名称
    @ConvertField
    private String memo; // 备注
    @ConvertField(targetField = "curTaxMny")
    private BigDecimal checkTaxMny; // 审定金额
    private BigDecimal taxRate; // 税率
    @ConvertField(targetField = "curTax")
    private BigDecimal tax; // 税额
    private String auditUnit;//审核单位

    private Integer contractVersion; // 合同版本
    private java.math.BigDecimal provisionalMny; // 暂列金额
    private String finalStageName; // 定案阶段名称：1-一审，2-二审，3-三审，4-终审
    @ConvertField
    private String billStateName; // 单据状态名称
    private Long settleReportId;//结算报审id
    private BigDecimal reportSettleTaxMny; // 报审结算金额
    private String settleName; //结算类型名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date filingDate;//返还时间
    private Long filingStatus;//返还状态
    private String filingStatusName;//返还状态名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sealDate;//盖章时间
    private String finalizedName; // 定案名称
    private String gdStatus;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date gdDate;
    private String closeFlag;//是否已成本关门(1-是 2-否)
    private BigDecimal preTotalCost;//预计总成本
    private Long projectPartId;//执行标段id

    public String getFinalizedName() {
        return finalizedName;
    }

    public void setFinalizedName(String finalizedName) {
        this.finalizedName = finalizedName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 项目
     */
    @ReferSerialTransfer(referCode = "ejc-share-zzyj-project-ex001")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode = "nbzz-contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractValuationType() {
        return contractValuationType;
    }

    @ReferDeserialTransfer
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    public BigDecimal getSumCostMny() {
        return sumCostMny;
    }

    public void setSumCostMny(BigDecimal sumCostMny) {
        this.sumCostMny = sumCostMny;
    }
    public BigDecimal getSumCostTaxMny() {
        return sumCostTaxMny;
    }

    public void setSumCostTaxMny(BigDecimal sumCostTaxMny) {
        this.sumCostTaxMny = sumCostTaxMny;
    }
    public BigDecimal getSumReceiptMny() {
        return sumReceiptMny;
    }

    public void setSumReceiptMny(BigDecimal sumReceiptMny) {
        this.sumReceiptMny = sumReceiptMny;
    }
    public BigDecimal getSumReceiptTaxMny() {
        return sumReceiptTaxMny;
    }

    public void setSumReceiptTaxMny(BigDecimal sumReceiptTaxMny) {
        this.sumReceiptTaxMny = sumReceiptTaxMny;
    }
    public String getFinalStage() {
        return finalStage;
    }

    public void setFinalStage(String finalStage) {
        this.finalStage = finalStage;
    }
    public BigDecimal getReportSettleMny() {
        return reportSettleMny;
    }

    public void setReportSettleMny(BigDecimal reportSettleMny) {
        this.reportSettleMny = reportSettleMny;
    }
    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public BigDecimal getSubtractTaxRate() {
        return subtractTaxRate;
    }

    public void setSubtractTaxRate(BigDecimal subtractTaxRate) {
        this.subtractTaxRate = subtractTaxRate;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getReviewSubtractRate() {
        return reviewSubtractRate;
    }

    public void setReviewSubtractRate(BigDecimal reviewSubtractRate) {
        this.reviewSubtractRate = reviewSubtractRate;
    }
    public BigDecimal getReviewSubtractMny() {
        return reviewSubtractMny;
    }

    public void setReviewSubtractMny(BigDecimal reviewSubtractMny) {
        this.reviewSubtractMny = reviewSubtractMny;
    }
    public Date getReturnDate() {
        return returnDate;
    }

    public void setReturnDate(Date returnDate) {
        this.returnDate = returnDate;
    }
    public Date getStartGuaranteeDate() {
        return startGuaranteeDate;
    }

    public void setStartGuaranteeDate(Date startGuaranteeDate) {
        this.startGuaranteeDate = startGuaranteeDate;
    }
    public Date getEndGuaranteeDate() {
        return endGuaranteeDate;
    }

    public void setEndGuaranteeDate(Date endGuaranteeDate) {
        this.endGuaranteeDate = endGuaranteeDate;
    }
    public BigDecimal getGuaranteeRate() {
        return guaranteeRate;
    }

    public void setGuaranteeRate(BigDecimal guaranteeRate) {
        this.guaranteeRate = guaranteeRate;
    }
    public BigDecimal getGuaranteeMny() {
        return guaranteeMny;
    }

    public void setGuaranteeMny(BigDecimal guaranteeMny) {
        this.guaranteeMny = guaranteeMny;
    }

    public BigDecimal getTotalEconomicBenefitRate() {
        return totalEconomicBenefitRate;
    }

    public void setTotalEconomicBenefitRate(BigDecimal totalEconomicBenefitRate) {
        this.totalEconomicBenefitRate = totalEconomicBenefitRate;
    }

    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }

    public String getFinalStageName() {
        return finalStageName;
    }

    public void setFinalStageName(String finalStageName) {
        this.finalStageName = finalStageName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getSettleReportId() {
        return settleReportId;
    }

    public void setSettleReportId(Long settleReportId) {
        this.settleReportId = settleReportId;
    }

    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getReportSettleTaxMny() {
        return reportSettleTaxMny;
    }

    public void setReportSettleTaxMny(BigDecimal reportSettleTaxMny) {
        this.reportSettleTaxMny = reportSettleTaxMny;
    }

    public String getSettleName() {
        return settleName;
    }

    public void setSettleName(String settleName) {
        this.settleName = settleName;
    }

    public Date getFilingDate() {
        return filingDate;
    }

    public void setFilingDate(Date filingDate) {
        this.filingDate = filingDate;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getFilingStatus() {
        return filingStatus;
    }
    @ReferDeserialTransfer
    public void setFilingStatus(Long filingStatus) {
        this.filingStatus = filingStatus;
    }

    public String getFilingStatusName() {
        return filingStatusName;
    }

    public void setFilingStatusName(String filingStatusName) {
        this.filingStatusName = filingStatusName;
    }

    public Date getSealDate() {
        return sealDate;
    }

    public void setSealDate(Date sealDate) {
        this.sealDate = sealDate;
    }

    public String getAuditUnit() {
        return auditUnit;
    }

    public void setAuditUnit(String auditUnit) {
        this.auditUnit = auditUnit;
    }

    public String getGdStatus() {
        return gdStatus;
    }

    public void setGdStatus(String gdStatus) {
        this.gdStatus = gdStatus;
    }

    public Date getGdDate() {
        return gdDate;
    }

    public void setGdDate(Date gdDate) {
        this.gdDate = gdDate;
    }

    public String getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(String closeFlag) {
        this.closeFlag = closeFlag;
    }

    public BigDecimal getPreTotalCost() {
        return preTotalCost;
    }

    public void setPreTotalCost(BigDecimal preTotalCost) {
        this.preTotalCost = preTotalCost;
    }
    @ReferSerialTransfer(referCode="pro-part")
    public Long getProjectPartId() {
        return projectPartId;
    }
    @ReferDeserialTransfer
    public void setProjectPartId(Long projectPartId) {
        this.projectPartId = projectPartId;
    }
}

