package com.ejianc.business.pro.income.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.List;

/**
 * 对甲报量
 *
 * @author generator
 *
 */
public class QuoteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ConvertField(targetField = "billCode")
    private String billCode; // 单据编号
    @ConvertField(targetField = "projectId")
    private Long projectId; // 项目
    @ConvertField(targetField = "projectCode")
    private String projectCode; // 项目编号
    @ConvertField(targetField = "projectName")
    private String projectName; // 项目名称
    @ConvertField(targetField = "orgId")
    private Long orgId; // 组织
    @ConvertField(targetField = "orgName")
    private String orgName; // 组织名称
    @ConvertField(targetField = "orgCode")
    private String orgCode; // 组织编码
    @ConvertField(targetField = "parentOrgId")
    private Long parentOrgId; // 父级组织
    @ConvertField(targetField = "parentOrgCode")
    private String parentOrgCode; // 所属组织编码
    @ConvertField(targetField = "parentOrgName")
    private String parentOrgName; // 父级组织名称
    @ConvertField(targetField = "contractId")
    private Long contractId; // 合同主键
    @ConvertField(targetField = "contractCode")
    private String contractCode; // 合同编号
    @ConvertField(targetField = "contractName")
    private String contractName; // 合同名称
    private java.math.BigDecimal taxRate; // 合同税率
    private java.math.BigDecimal contractMny; // 合同金额(无税)
    private java.math.BigDecimal contractTaxMny; // 合同金额(含税)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date quoteDate; // 报量时间
    @ConvertField(targetField = "quoteMny")
    private java.math.BigDecimal quoteMny; // 本次上报金额(无税)
    @ConvertField(targetField = "quoteTaxMny")
    private java.math.BigDecimal quoteTaxMny; // 本次上报金额
    @ConvertField(targetField = "quoteTax")
    private java.math.BigDecimal taxMny; // 税额
    @ConvertField(targetField = "employeeId")
    private Long employeeId; // 经办人
    @ConvertField(targetField = "employeeName")
    private String employeeName; // 经办人名称
    @ConvertField(targetField = "departmentId")
    private Long deptId; // 部门id
    @ConvertField(targetField = "departmentName")
    private String deptName; // 部门名称
    @ConvertField(targetField = "settleDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date replyDate; // 批复时间
    private Integer replyStatus; // 甲方批复状态(0-未批复，1-已批复，2-未通过)
    @ConvertField(targetField = "curMny")
    private java.math.BigDecimal replyMny; // 本次批复金额(无税)
    @ConvertField(targetField = "curTaxMny")
    private java.math.BigDecimal replyTaxMny; // 本次批复金额
    @ConvertField
    private String memo; // 备注
    @ConvertField(targetField = "billState")
    private Integer billState; // 单据状态

    private List<QuoteDetailVO> detailList = new ArrayList<>(); // 对甲报量子表

    private Integer contractVersion;// 合同版本

    private String billStateName; //单据状态名称

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    @ReferSerialTransfer(referCode = "pro-income-contract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同金额(无税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(无税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同金额(含税)
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额(含税)
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 报量时间
     */
    public java.util.Date getQuoteDate() {
        return quoteDate;
    }

    /**
     * 报量时间
     */
    public void setQuoteDate(java.util.Date quoteDate) {
        this.quoteDate = quoteDate;
    }
    /**
     * 本次上报金额(无税)
     */
    public java.math.BigDecimal getQuoteMny() {
        return quoteMny;
    }

    /**
     * 本次上报金额(无税)
     */
    public void setQuoteMny(java.math.BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }
    /**
     * 本次上报金额
     */
    public java.math.BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    /**
     * 本次上报金额
     */
    public void setQuoteTaxMny(java.math.BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 部门id
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 部门id
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 批复时间
     */
    public java.util.Date getReplyDate() {
        return replyDate;
    }

    /**
     * 批复时间
     */
    public void setReplyDate(java.util.Date replyDate) {
        this.replyDate = replyDate;
    }
    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public Integer getReplyStatus() {
        return replyStatus;
    }

    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public void setReplyStatus(Integer replyStatus) {
        this.replyStatus = replyStatus;
    }
    /**
     * 本次批复金额(无税)
     */
    public java.math.BigDecimal getReplyMny() {
        return replyMny;
    }

    /**
     * 本次批复金额(无税)
     */
    public void setReplyMny(java.math.BigDecimal replyMny) {
        this.replyMny = replyMny;
    }
    /**
     * 本次批复金额
     */
    public java.math.BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    /**
     * 本次批复金额
     */
    public void setReplyTaxMny(java.math.BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 对甲报量子表
     */
    public List<QuoteDetailVO> getDetailList() {
        return detailList;
    }

    /**
     * 对甲报量子表
     */
    public void setDetailList(List<QuoteDetailVO> detailList) {
        this.detailList = detailList;
    }
}
