package com.ejianc.business.pro.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.pro.income.vo.ContractExportPayRemarkVO;
import com.ejianc.business.pro.income.vo.ContractExportPayRemarkVO;

/**
 * 施工合同条款补录
 * 
 * @author generator
 * 
 */
public class ContractExportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long contractId; // 合同id
    private String contractName; // 合同名称

    private List<ContractExportPayRemarkVO> contractExportPayRemarkList = new ArrayList<>(); // 施工合同补录-付款节点
    private List<ContractExportPayNodeVO> contractExportPayNodeList = new ArrayList<>(); // 施工合同补录-质保金节点
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode = "pro-income-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public List<ContractExportPayRemarkVO> getContractExportPayRemarkList() {
        return contractExportPayRemarkList;
    }

    public void setContractExportPayRemarkList(List<ContractExportPayRemarkVO> contractExportPayRemarkList) {
        this.contractExportPayRemarkList = contractExportPayRemarkList;
    }

    public List<ContractExportPayNodeVO> getContractExportPayNodeList() {
        return contractExportPayNodeList;
    }

    public void setContractExportPayNodeList(List<ContractExportPayNodeVO> contractExportPayNodeList) {
        this.contractExportPayNodeList = contractExportPayNodeList;
    }
}
