package com.ejianc.business.pro.income.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 工程造价调整
 *
 * @author generator
 */
public class CostAdjustVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 组织ID
    private String parentOrgCode; // 组织编码ID
    private String parentOrgName; // 组织名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyAdjustDate; // 申请调整日期
    private BigDecimal baseMny; // 初始版本金额(无税)
    private BigDecimal baseTaxMny; // 初始版本金额
    private BigDecimal contractMny; // 合同签订金额(无税)
    private BigDecimal contractTaxMny; // 合同签订金额
    private BigDecimal taxRate; // 合同税率
    private BigDecimal totalSupplementMny; // 补充协议总金额(无税)
    private BigDecimal totalSupplementTaxMny; // 补充协议总金额
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private BigDecimal applyChangeMny; // 申请变动金额(无税)
    private BigDecimal applyChangeTaxMny; // 申请变动金额
    private BigDecimal replyMny; // 甲方批复金额(无税)
    private BigDecimal replyTaxMny; // 甲方批复金额
    private BigDecimal lastApplyChangeMny; // 不含本期累计申请变动金额(无税)
    private BigDecimal lastApplyChangeTaxMny; // 不含本期累计申请变动金额
    private BigDecimal totalApplyChangeMny; // 累计申请变动金额(无税)
    private BigDecimal totalApplyChangeTaxMny; // 累计申请变动金额
    private BigDecimal costChangeTotalMny; // 工程造价及变动合计总金额(无税)
    private BigDecimal costChangeTotalTaxMny; // 工程造价及变动合计总金额
    private String memo; // 备注
    private Integer approvalFlag; // 是否需要领导审批
    private BigDecimal notReplyMny; // 甲方未批复金额(无税)
    private BigDecimal notReplyTaxMny; // 甲方未批复金额
    private BigDecimal nicCostChangeTotalMny; // 工程造价及变动合计无税（不含暂列金）
    private BigDecimal nicCostChangeTotalTaxMny; //工程造价及变动合计（不含暂列金）

    private List<CostAdjustDetailVO> detailList = new ArrayList<>(); // 工程造价调整-调整来源

    private String billStateName; //单据状态名称
    private Integer contractVersion; // 合同版本

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "pro-income-contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Date getApplyAdjustDate() {
        return applyAdjustDate;
    }

    public void setApplyAdjustDate(Date applyAdjustDate) {
        this.applyAdjustDate = applyAdjustDate;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTotalSupplementMny() {
        return totalSupplementMny;
    }

    public void setTotalSupplementMny(BigDecimal totalSupplementMny) {
        this.totalSupplementMny = totalSupplementMny;
    }

    public BigDecimal getTotalSupplementTaxMny() {
        return totalSupplementTaxMny;
    }

    public void setTotalSupplementTaxMny(BigDecimal totalSupplementTaxMny) {
        this.totalSupplementTaxMny = totalSupplementTaxMny;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public BigDecimal getApplyChangeMny() {
        return applyChangeMny;
    }

    public void setApplyChangeMny(BigDecimal applyChangeMny) {
        this.applyChangeMny = applyChangeMny;
    }

    public BigDecimal getApplyChangeTaxMny() {
        return applyChangeTaxMny;
    }

    public void setApplyChangeTaxMny(BigDecimal applyChangeTaxMny) {
        this.applyChangeTaxMny = applyChangeTaxMny;
    }

    public BigDecimal getReplyMny() {
        return replyMny;
    }

    public void setReplyMny(BigDecimal replyMny) {
        this.replyMny = replyMny;
    }

    public BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    public void setReplyTaxMny(BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }

    public BigDecimal getLastApplyChangeMny() {
        return lastApplyChangeMny;
    }

    public void setLastApplyChangeMny(BigDecimal lastApplyChangeMny) {
        this.lastApplyChangeMny = lastApplyChangeMny;
    }

    public BigDecimal getLastApplyChangeTaxMny() {
        return lastApplyChangeTaxMny;
    }

    public void setLastApplyChangeTaxMny(BigDecimal lastApplyChangeTaxMny) {
        this.lastApplyChangeTaxMny = lastApplyChangeTaxMny;
    }

    public BigDecimal getTotalApplyChangeMny() {
        return totalApplyChangeMny;
    }

    public void setTotalApplyChangeMny(BigDecimal totalApplyChangeMny) {
        this.totalApplyChangeMny = totalApplyChangeMny;
    }

    public BigDecimal getTotalApplyChangeTaxMny() {
        return totalApplyChangeTaxMny;
    }

    public void setTotalApplyChangeTaxMny(BigDecimal totalApplyChangeTaxMny) {
        this.totalApplyChangeTaxMny = totalApplyChangeTaxMny;
    }

    public BigDecimal getCostChangeTotalMny() {
        return costChangeTotalMny;
    }

    public void setCostChangeTotalMny(BigDecimal costChangeTotalMny) {
        this.costChangeTotalMny = costChangeTotalMny;
    }

    public BigDecimal getCostChangeTotalTaxMny() {
        return costChangeTotalTaxMny;
    }

    public void setCostChangeTotalTaxMny(BigDecimal costChangeTotalTaxMny) {
        this.costChangeTotalTaxMny = costChangeTotalTaxMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<CostAdjustDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CostAdjustDetailVO> detailList) {
        this.detailList = detailList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    public Integer getApprovalFlag() {
        return approvalFlag;
    }

    public void setApprovalFlag(Integer approvalFlag) {
        this.approvalFlag = approvalFlag;
    }

    public BigDecimal getNotReplyMny() {
        return notReplyMny;
    }

    public void setNotReplyMny(BigDecimal notReplyMny) {
        this.notReplyMny = notReplyMny;
    }

    public BigDecimal getNotReplyTaxMny() {
        return notReplyTaxMny;
    }

    public void setNotReplyTaxMny(BigDecimal notReplyTaxMny) {
        this.notReplyTaxMny = notReplyTaxMny;
    }

    public BigDecimal getNicCostChangeTotalMny() {
        return nicCostChangeTotalMny;
    }

    public void setNicCostChangeTotalMny(BigDecimal nicCostChangeTotalMny) {
        this.nicCostChangeTotalMny = nicCostChangeTotalMny;
    }

    public BigDecimal getNicCostChangeTotalTaxMny() {
        return nicCostChangeTotalTaxMny;
    }

    public void setNicCostChangeTotalTaxMny(BigDecimal nicCostChangeTotalTaxMny) {
        this.nicCostChangeTotalTaxMny = nicCostChangeTotalTaxMny;
    }
}
