/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.mapper.ContractReviewMapper;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractReviewService")
public class ContractReviewServiceImpl
extends BaseServiceImpl<ContractReviewMapper, ContractReviewEntity>
implements IContractReviewService {
    private static final String INCOME_CONTRACT_REVIEW = "INCOME_CONTRACT_REVIEW";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public ContractReviewVO saveOrUpdate(ContractReviewVO saveorUpdateVO) {
        ContractReviewEntity entity = (ContractReviewEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ContractReviewEntity.class));
        if (1 != saveorUpdateVO.getSupplementFlag()) {
            this.validateReview(entity.getProjectId(), entity.getId());
        }
        super.saveOrUpdate((Object)entity, false);
        return (ContractReviewVO)BeanMapper.map((Object)((Object)entity), ContractReviewVO.class);
    }

    @Override
    public ContractReviewVO queryDetail(Long id) {
        ContractReviewEntity entity = (ContractReviewEntity)((Object)super.selectById((Serializable)id));
        return (ContractReviewVO)BeanMapper.map((Object)((Object)entity), ContractReviewVO.class);
    }

    @Override
    public ContractReviewVO addSupplementByConId(Long mainContractId) {
        ContractReviewVO vo = this.queryDetail(mainContractId);
        ContractReviewVO resultVo = new ContractReviewVO();
        resultVo.setProjectId(vo.getProjectId());
        resultVo.setProjectName(vo.getProjectName());
        resultVo.setProjectCode(vo.getProjectCode());
        resultVo.setOrgId(vo.getOrgId());
        resultVo.setOrgCode(vo.getOrgCode());
        resultVo.setOrgName(vo.getOrgName());
        resultVo.setParentOrgId(vo.getParentOrgId());
        resultVo.setParentOrgCode(vo.getParentOrgCode());
        resultVo.setParentOrgName(vo.getParentOrgName());
        resultVo.setContractName(vo.getContractName());
        resultVo.setCustomerId(vo.getCustomerId());
        resultVo.setCustomerName(vo.getCustomerName());
        resultVo.setSupplierId(vo.getSupplierId());
        resultVo.setSupplierName(vo.getSupplierName());
        resultVo.setConstructionPartner(vo.getConstructionPartner());
        resultVo.setTaxRate(vo.getTaxRate());
        resultVo.setContractType(vo.getContractType());
        resultVo.setContractValuationType(vo.getContractValuationType());
        resultVo.setBuiltArea(vo.getBuiltArea());
        resultVo.setContractPartyc(vo.getContractPartyc());
        resultVo.setConjoinedContractTotalMny(vo.getConjoinedContractTotalMny());
        resultVo.setArchitectId(vo.getArchitectId());
        resultVo.setArchitectName(vo.getArchitectName());
        resultVo.setManagerId(vo.getManagerId());
        resultVo.setManagerName(vo.getManagerName());
        resultVo.setEngineeringTypeId(vo.getEngineeringTypeId());
        resultVo.setEngineeringTypeName(vo.getEngineeringTypeName());
        resultVo.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        resultVo.setEmployeeName(this.sessionManager.getUserContext().getUserName());
        resultVo.setDeptId(this.sessionManager.getUserContext().getDeptId());
        resultVo.setDeptName(this.sessionManager.getUserContext().getDeptName());
        resultVo.setAddress(vo.getAddress());
        resultVo.setMainContractId(mainContractId);
        resultVo.setMainContractName(vo.getContractName());
        resultVo.setMainContractCode(vo.getBillCode());
        resultVo.setBearType(vo.getBearType());
        resultVo.setContractualModel(vo.getContractualModel());
        return resultVo;
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        int total = 0;
        int pages = 0;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("supplementFlag", new Parameter("eq", (Object)0));
        List entityList = this.queryList(param);
        List list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        List voList = BeanMapper.mapList(list, ContractReviewVO.class);
        List idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam childrenParam = (QueryParam)Utils.deepCopy((Object)param);
        if (ListUtil.isNotEmpty(idList)) {
            childrenParam.getParams().put("mainContractId", new Parameter("in", idList));
        }
        childrenParam.getParams().put("supplementFlag", new Parameter("eq", (Object)"1"));
        List childrenList = this.queryList(childrenParam);
        List childrenVoList = BeanMapper.mapList((Iterable)childrenList, ContractReviewVO.class);
        Map<Long, List<ContractReviewVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(ContractReviewVO::getMainContractId));
        if (param.getSearchText() != null && ListUtil.isNotEmpty((List)childrenVoList)) {
            ArrayList<Long> childrenIdList = new ArrayList<Long>(childrenMap.keySet());
            param.getParams().put("id", new Parameter("in", (Object)childrenIdList));
            if (ListUtil.isEmpty((List)entityList)) {
                param.setSearchText(null);
            }
            List newEntityList = this.queryList(param);
            entityList.addAll(newEntityList);
            entityList = entityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ContractReviewEntity>(Comparator.comparing(BaseEntity::getId))), ArrayList::new));
            entityList = entityList.stream().sorted(Comparator.comparing(BaseEntity::getCreateTime).reversed()).collect(Collectors.toList());
            list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
            voList = BeanMapper.mapList(list, ContractReviewVO.class);
        }
        if (ListUtil.isNotEmpty((List)voList)) {
            for (ContractReviewVO vo : voList) {
                if (!childrenMap.containsKey(vo.getId())) continue;
                vo.setChildren(childrenMap.get(vo.getId()));
            }
        }
        if ((total = entityList.size()) % pageSize > 0) {
            pages = total / pageSize + 1;
        } else if (total % pageSize == 0) {
            pages = total / pageSize;
        }
        JSONObject page = new JSONObject();
        page.put("records", (Object)voList);
        page.put("total", (Object)total);
        page.put("current", (Object)pageIndex);
        page.put("size", (Object)pageSize);
        page.put("pages", (Object)pages);
        return page;
    }

    @Override
    public List<ContractReviewVO> excelExport(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("supplementFlag", new Parameter("eq", (Object)"0"));
        List entityList = this.queryList(param);
        List voList = BeanMapper.mapList((Iterable)entityList, ContractReviewVO.class);
        List idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam childrenParam = (QueryParam)Utils.deepCopy((Object)param);
        childrenParam.getParams().put("mainContractId", new Parameter("in", idList));
        childrenParam.getParams().remove("supplementFlag");
        List childrenList = this.queryList(childrenParam);
        List childrenVoList = BeanMapper.mapList((Iterable)childrenList, ContractReviewVO.class);
        Map<Long, List<ContractReviewVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(ContractReviewVO::getMainContractId));
        if (param.getSearchText() != null && ListUtil.isNotEmpty((List)childrenVoList)) {
            ArrayList<Long> childrenIdList = new ArrayList<Long>(childrenMap.keySet());
            param.getParams().put("id", new Parameter("in", childrenIdList));
            if (ListUtil.isEmpty((List)entityList)) {
                param.setSearchText(null);
            }
            List newEntityList = this.queryList(param);
            entityList.addAll(newEntityList);
            entityList = entityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ContractReviewEntity>(Comparator.comparing(BaseEntity::getId))), ArrayList::new));
            entityList = entityList.stream().sorted(Comparator.comparing(BaseEntity::getCreateTime).reversed()).collect(Collectors.toList());
            voList = BeanMapper.mapList(entityList, ContractReviewVO.class);
        }
        ArrayList<ContractReviewVO> resultList = new ArrayList<ContractReviewVO>();
        for (ContractReviewVO vo : voList) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            resultList.add(vo);
            if (!childrenMap.containsKey(vo.getId())) continue;
            for (ContractReviewVO reviewVO : childrenMap.get(vo.getId())) {
                reviewVO.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                resultList.add(reviewVO);
            }
        }
        return resultList;
    }

    @Override
    public String relationProject(ContractReviewVO vo) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(ContractReviewEntity::getProjectId, (Object)vo.getProjectId());
        wrapper.set(ContractReviewEntity::getProjectCode, (Object)vo.getProjectCode());
        wrapper.set(ContractReviewEntity::getProjectName, (Object)vo.getProjectName());
        wrapper.set(ContractReviewEntity::getOrgId, (Object)vo.getOrgId());
        wrapper.set(ContractReviewEntity::getOrgCode, (Object)vo.getOrgCode());
        wrapper.set(ContractReviewEntity::getOrgName, (Object)vo.getOrgName());
        wrapper.set(ContractReviewEntity::getParentOrgId, (Object)vo.getParentOrgId());
        wrapper.set(ContractReviewEntity::getParentOrgCode, (Object)vo.getParentOrgCode());
        wrapper.set(ContractReviewEntity::getParentOrgName, (Object)vo.getParentOrgName());
        wrapper.eq(BaseEntity::getId, (Object)vo.getId());
        this.update((Wrapper)wrapper);
        return "\u5173\u8054\u9879\u76ee\u6210\u529f\uff01";
    }

    @Override
    public Boolean validateReview(Long projectId, Long id) {
        List list;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractReviewEntity::getProjectId, (Object)projectId);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        if (id != null) {
            wrapper.ne(BaseEntity::getId, (Object)id);
        }
        if (ListUtil.isNotEmpty((List)(list = this.list((Wrapper)wrapper)))) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5b58\u5728\u5176\u4ed6\u8bc4\u5ba1\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e/\u4fee\u6539!");
        }
        return true;
    }
}

