package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.service.IClaimRecordsService;
import com.ejianc.business.pro.income.vo.ClaimRecordsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 洽商签证索赔记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("claimRecords")
public class ClaimRecordsController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "INCOME_CLAIM_RECORDS";//此处需要根据实际修改

    @Autowired
    private IClaimRecordsService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ClaimRecordsVO> saveOrUpdate(@RequestBody ClaimRecordsVO saveOrUpdateVO) {
    	ClaimRecordsEntity entity = BeanMapper.map(saveOrUpdateVO, ClaimRecordsEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setIsClose(CommonConstants.OPEN);
        }
    	service.saveOrUpdate(entity, false);
    	ClaimRecordsVO vo = BeanMapper.map(entity, ClaimRecordsVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ClaimRecordsVO> queryDetail(Long id) {
    	ClaimRecordsEntity entity = service.selectById(id);
    	ClaimRecordsVO vo = BeanMapper.map(entity, ClaimRecordsVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ClaimRecordsVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ClaimRecordsVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ClaimRecordsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ClaimRecordsVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        if(!param.getParams().containsKey("orgId")) {
            //pc端
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            //移动端 需要取orgId的本下
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ClaimRecordsEntity> page = service.queryPage(param,false);
        IPage<ClaimRecordsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ClaimRecordsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ClaimRecordsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ClaimRecords-export.xlsx", beans, response);
    }

    /**
     * 参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refClaimRecordsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ClaimRecordsVO>> refClaimRecordsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("isClose", new Parameter(QueryParam.EQ, 0)); // 查询

        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }
            if (null != conditionMap.get("claimType")) {
                String claimType = conditionMap.get("claimType").toString();
                param.getParams().put("claimType", new Parameter(QueryParam.EQ, claimType));
            }
            if(null != conditionMap.get("claimId")){
                Long claimId = Long.valueOf(conditionMap.get("claimId").toString());
                ComplexParam c1 = new ComplexParam();
                c1.setLogic(ComplexParam.AND);

                ComplexParam c2 = new ComplexParam();
                c2.setLogic(ComplexParam.OR);
//                c2.getParams().put("replyStatus", new Parameter(QueryParam.EQ, CommonConstants.WU));
                c2.getParams().put("quoteStatus", new Parameter(QueryParam.EQ, CommonConstants.WYY));

                ComplexParam c3 = new ComplexParam();
                c3.setLogic(ComplexParam.OR);
                c3.getParams().put("claimId", new Parameter(QueryParam.EQ, claimId));

                c1.getComplexParams().add(c2);
                c1.getComplexParams().add(c3);

                param.getComplexParams().add(c1);
            }else{
                param.getParams().put("quoteStatus", new Parameter(QueryParam.EQ, CommonConstants.WYY));
            }
        }

        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage<ClaimRecordsEntity> page = service.queryPage(param,false);
        IPage<ClaimRecordsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ClaimRecordsVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/updateCloseStatus")
    @ResponseBody
    public CommonResponse<ClaimRecordsVO> updateCloseStatus(@RequestParam Long id, @RequestParam Integer isClose) {
        ClaimRecordsEntity entity = service.selectById(id);
        if (!CommonConstants.WYY.equals(entity.getQuoteStatus())) {
            return CommonResponse.error("该单据已经被引用，不能关闭/开启！");
        }

        entity.setIsClose(isClose.equals(CommonConstants.OPEN) ? CommonConstants.CLOSE : CommonConstants.OPEN);
        service.save(entity);

        return CommonResponse.success("修改成功！");
    }


}
