package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.income.vo.BudgetDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.BudgetDetailMapper;
import com.ejianc.business.pro.income.bean.BudgetDetailEntity;
import com.ejianc.business.pro.income.service.IBudgetDetailService;

import java.util.List;

/**
 * 清单明细
 * 
 * @author generator
 * 
 */
@Service("budgetDetailService")
public class BudgetDetailServiceImpl extends BaseServiceImpl<BudgetDetailMapper, BudgetDetailEntity> implements IBudgetDetailService{

    @Override
    public void delDetailByBudgetId(Long budgetId) {
        baseMapper.delete(new QueryWrapper<BudgetDetailEntity>().eq("budget_id", budgetId));
    }

    @Override
    public void delDetailBatchByBudgetId(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<BudgetDetailEntity>().in("budget_id", ids));
    }

    @Override
    public List<BudgetDetailVO> queryDetailList(Long budgetBid) {
        LambdaQueryWrapper<BudgetDetailEntity> lambd = new LambdaQueryWrapper<>();
        lambd.eq(BudgetDetailEntity::getBudgetBid,budgetBid);
        List<BudgetDetailEntity> list = super.list(lambd);
        return BeanMapper.mapList(list,BudgetDetailVO.class);
    }

    @Override
    public List<BudgetDetailEntity> queryDetailByBudgetIds(List<Long> budegtIds) {
        return baseMapper.selectList(new QueryWrapper<BudgetDetailEntity>()
                .eq("dr",0)
                .in("budget_id", budegtIds));
    }
}
