package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.income.bean.ContractRegisterChangeEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterHistoryEntity;
import com.ejianc.business.pro.income.enums.BillPushStatusEnum;
import com.ejianc.business.pro.income.service.IContractRegisterChangeService;
import com.ejianc.business.pro.income.service.IContractRegisterHistoryService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service("contractRegisterChange") 
public class ContractRegisterChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private IContractRegisterChangeService changeService;
	
	@Autowired
	private IContractRegisterService registerService;
	
	@Autowired
	private IContractRegisterHistoryService historyService;

	@Autowired
	private IAttachmentApi attachmentApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 变更表
		ContractRegisterChangeEntity changeEntity = changeService.selectById(billId);
		// 合同登记主表
		ContractRegisterEntity registerEntity = registerService.selectById(changeEntity.getRegisterId());
		
		// 同步原合同到记录表
		ContractRegisterHistoryEntity historyEntity = BeanMapper.map(registerEntity, ContractRegisterHistoryEntity.class);
		historyEntity.setRegisterId(changeEntity.getRegisterId());
		historyEntity.setId(null);
		historyService.saveOrUpdate(historyEntity,false);
		
		// 回写合同主表
		registerEntity.setBeforeChangeTaxMny(registerEntity.getContractTaxMny());
		registerEntity.setBeforeChangeMny(registerEntity.getContractMny());
		registerEntity.setChangingTaxMny(null);//变更中金额清空
		registerEntity.setChangingMny(null);//变更中金额清空
		registerEntity.setChangeStatus("3");//状态改为已变更
		registerEntity.setChangeCode(registerEntity.getChangeCode());
		registerEntity.setChangeId(registerEntity.getChangeId());
		registerEntity.setBillState(registerEntity.getBillState());
		registerEntity.setSumProductionTaxMny(registerEntity.getSumProductionTaxMny());
		registerEntity.setSumProductionMny(registerEntity.getSumProductionMny());
		registerEntity.setSumQuoteTaxMny(registerEntity.getSumQuoteTaxMny());
		registerEntity.setSumQuoteMny(registerEntity.getSumQuoteMny());
		registerEntity.setSumCollectMny(registerEntity.getSumCollectMny());
		registerEntity.setSumInvoicingTaxMny(registerEntity.getSumInvoicingTaxMny());
		registerEntity.setSumInvoicingMny(registerEntity.getSumInvoicingMny());
		
		registerEntity.setBearType(changeEntity.getBearType());
		registerEntity.setContractName(changeEntity.getContractName());
		registerEntity.setContractType(changeEntity.getContractType());
		registerEntity.setSignDate(changeEntity.getSignDate());
		registerEntity.setCustomerId(changeEntity.getCustomerId());
		registerEntity.setCustomerName(changeEntity.getCustomerName());
		registerEntity.setSupplierId(changeEntity.getSupplierId());
		registerEntity.setSupplierName(changeEntity.getSupplierName());
		registerEntity.setConstructionPartner(changeEntity.getConstructionPartner());
		registerEntity.setTaxRate(changeEntity.getTaxRate());
		registerEntity.setContractTaxMny(changeEntity.getContractTaxMny());
		registerEntity.setContractMny(changeEntity.getContractMny());
		registerEntity.setTaxMny(changeEntity.getTaxMny());
		registerEntity.setStartDate(changeEntity.getStartDate());
		registerEntity.setEndDate(changeEntity.getEndDate());
		registerEntity.setSchedule(changeEntity.getSchedule());
		registerEntity.setContractValuationType(changeEntity.getContractValuationType());
		registerEntity.setContractStatus(changeEntity.getContractStatus());
		registerEntity.setContractPartyc(changeEntity.getContractPartyc());
		registerEntity.setProvisionalMny(changeEntity.getProvisionalMny()); // 暂列金额
		registerEntity.setContractPromisePaymentRate(changeEntity.getContractPromisePaymentRate());
		registerEntity.setEmployeeId(changeEntity.getEmployeeId());
		registerEntity.setEmployeeName(changeEntity.getEmployeeName());
		registerEntity.setDeptId(changeEntity.getDeptId());
		registerEntity.setDeptName(changeEntity.getDeptName());
		registerEntity.setChangeId(registerEntity.getChangeId());
		registerEntity.setChangeReason(changeEntity.getChangeReason());
		registerEntity.setChangeVersion(changeEntity.getChangeVersion());
		registerEntity.setSupplierPhone(changeEntity.getSupplierPhone());
		registerEntity.setCustomerPhone(changeEntity.getCustomerPhone());
		registerEntity.setCustomerEntrustedAgent(changeEntity.getCustomerEntrustedAgent());
		registerEntity.setSupplierEntrustedAgent(changeEntity.getSupplierEntrustedAgent());
		registerEntity.setDisputeResolution(changeEntity.getDisputeResolution());
		registerEntity.setDisputeResolutionAgency(changeEntity.getDisputeResolutionAgency());
		registerEntity.setNotIncludeProvisionalMny(changeEntity.getNotIncludeProvisionalMny()); // 施工合同金额(不含暂列金额)


		// 历史记录主键、生效时间、变更前合同名称
		changeEntity.setUsedTime(new Date());
		changeEntity.setBeforeContractName(registerEntity.getContractName());
		changeService.saveOrUpdate(changeEntity, false);
		
		// 同步附件
		logger.info("同步附件");
		CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(billId), "BT211214000000009", null,
				String.valueOf(registerEntity.getId()), "BT211214000000005", null);
		logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response).toString());

		//合同推送合同池
		boolean pushResult = registerService.pushContract(BeanMapper.map(registerEntity, ContractRegisterVO.class),true);
		if(pushResult) {
			registerEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		} else {
			registerEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		registerService.saveOrUpdate(registerEntity, false);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("合同变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
