package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.mapper.ContractRegisterMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.utils.BillTypeCodeEnum;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.business.pro.income.vo.RegisterSupplementHistoryVO;
import com.ejianc.business.pro.warn.SqlParam;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工合同登记
 * 
 * @author generator
 * 
 */
@Service("contractRegisterService")
public class ContractRegisterServiceImpl extends BaseServiceImpl<ContractRegisterMapper, ContractRegisterEntity> implements IContractRegisterService{

    private static final String INCOME_CONTRACT_REGISTER = "INCOME_CONTRACT_REGISTER";//此处需要根据实际修改

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ValidateUtil validateUtil;

    @Autowired
    private SessionManager sessionManager;
    
    @Autowired
    private IContractReviewService reviewService;
    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    public ContractRegisterMapper mapper;
    
    @Override
    public ContractRegisterVO saveOrUpdate(ContractRegisterVO saveorUpdateVO) {

        // 保存时校验合同version是否一致
        if (!Objects.equals(null, saveorUpdateVO.getReviewId())) {
            if(!validateUtil.validateUpStreamVersion(String.valueOf(saveorUpdateVO.getReviewId()),
                    BillTypeCodeEnum.施工合同评审.getCode(), saveorUpdateVO.getReviewVersion())){
                throw new BusinessException("该合同已被更新，请刷新后重做！");
            }
        }
        
        ContractRegisterEntity entity = BeanMapper.map(saveorUpdateVO, ContractRegisterEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(entity.getId() == null || entity.getId() == 0){
            // 新增
            if (StringUtils.isBlank(entity.getBillCode())) {
                String billCode = null;
                if (Objects.equals(entity.getSupplementFlag(), ContractRegisterVO.CONTRACT_TYPE_SUPPLEMENT)) {
                    // 查询补充协议
                    LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(ContractRegisterEntity::getMainContractId, entity.getMainContractId());
                    wrapper.in(ContractRegisterEntity::getBillState, Arrays.asList(1, 3));
                    List<ContractRegisterEntity> list = this.list(wrapper);

                    String supplementNum = "";
                    if (list.size() < 10) {
                        supplementNum += "0" + (list.size() + 1);
                    }else {
                        supplementNum += (list.size() + 1);
                    }

                    billCode = entity.getMainContractCode() + "-2-" + supplementNum;
                }else {
                    BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_REGISTER, tenantId, saveorUpdateVO);
                    CommonResponse<String> response = billCodeApi.generateBillCode(billCodeParam);
                    if(response.isSuccess()) {
                        billCode = response.getData();
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }

                entity.setBillCode(billCode);
            }
            // 校验合同编号是否重复
            LambdaQueryWrapper<ContractRegisterEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractRegisterEntity::getTenantId, tenantId);
            lambda.eq(ContractRegisterEntity::getBillCode, entity.getBillCode());
            List<ContractRegisterEntity> entityList = super.list(lambda);
            if(ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
            
            // 新增设置 竣工结算标志、解除状态、合同状态、变更状态
            entity.setIsFinish(0);
            entity.setIsRelieve(0);
            entity.setIsSuspend(0);
            entity.setContractStatus(ContractStatusEnum.未签订.getCode());
            entity.setChangeStatus("1");
        }else {
            // 修改
            if(StringUtils.isEmpty(entity.getBillCode())){
                throw new BusinessException("编码为空，不允许保存!");
            }
            
            // 校验合同编号是否重复
            LambdaQueryWrapper<ContractRegisterEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractRegisterEntity::getBillCode, entity.getBillCode());
            lambda.eq(ContractRegisterEntity::getTenantId, tenantId);
            lambda.ne(ContractRegisterEntity::getId, entity.getId());
            List<ContractRegisterEntity> entityList = super.list(lambda);
            if(ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }

            // 暂估合同用
            if (null == entity.getBillState()) {
                entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            }

        }

        entity.setContractTaxMny(entity.getBaseTaxMoney()); // 合同总金额
        entity.setContractMny(entity.getBaseMoney()); // 合同总金额(无税)
        entity.setTaxMny(entity.getBaseTax()); // 合同税额
        entity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd(entity.getBaseTaxMoney(), entity.getTotalCostAdjustTaxMny()));
        entity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd(entity.getBaseMoney(), entity.getTotalCostAdjustMny()));
        entity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd(entity.getBaseTax(), entity.getTotalCostAdjustTax()));
        entity.setNicContractMny(ComputeUtil.safeAdd(entity.getNotIncludeProvisionalMny(), entity.getTotalCostAdjustTaxMny()));

        entity.setBeforeChangeTaxMny(entity.getContractTaxMny()); // 变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny()); // 变更前金额(不含税)
        super.saveOrUpdate(entity, false);
        
        return BeanMapper.map(entity, ContractRegisterVO.class);
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 项合同编号、目名称、合同名称、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<ContractRegisterEntity> pageData = this.queryPage(param, false);


        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractRegisterVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("contractCount", contractAmountMap);
        
        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
//        String originalAmount = resp.get("originalAmount").toString();
//        String curAmount = resp.get("curAmount").toString();
//        resp.put("originalAmount",originalAmount);
//        resp.put("curAmount",curAmount);
        return resp;
    }

    @Override
    public List<ContractRegisterVO> excelExport(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 项合同编号、目名称、合同名称、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");

        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<ContractRegisterEntity> entityList = this.queryList(param);
        List<ContractRegisterVO> voList = BeanMapper.mapList(entityList, ContractRegisterVO.class);

        for (ContractRegisterVO vo : voList) {
            String contractStatus = vo.getContractStatus();
            if (StringUtils.isNotBlank(contractStatus)) {
                if (Objects.equals(contractStatus, "1")) {
                    vo.setContractStatusName("履约中");
                }
                if (Objects.equals(contractStatus, "2")) {
                    vo.setContractStatusName("已封账");
                }
                if (Objects.equals(contractStatus, "3")) {
                    vo.setContractStatusName("已解除");
                }
            }else {
                vo.setContractStatusName("");
            }
            
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }
        
        return voList;
    }

    @Override
    public ContractRegisterVO addRegisterByRevId(Long reviewId) {
        ContractReviewEntity entity = reviewService.selectById(reviewId);
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setReviewId(reviewId);
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractName(entity.getContractName());
        vo.setSignDate(new Date());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setBaseTaxMoney(entity.getContractTaxMny());
        vo.setBaseMoney(entity.getContractMny());
        vo.setBaseTax(entity.getTaxMny());
//        vo.setTaxMny(entity.getTaxMny());
//        vo.setContractMny(entity.getContractMny());
//        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setStartDate(entity.getStartDate());
        vo.setEndDate(entity.getEndDate());
        vo.setSchedule(entity.getSchedule());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(sessionManager.getUserContext().getUserName());
        vo.setDeptId(sessionManager.getUserContext().getDeptId());
        vo.setDeptName(sessionManager.getUserContext().getDeptName());
        vo.setSignDate(new Date());
        
        
        // 查询主合同对应的合同登记
        LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterEntity::getReviewId, entity.getMainContractId());
        wrapper.orderByDesc(ContractRegisterEntity::getCreateTime);
        List<ContractRegisterEntity> list = this.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            ContractRegisterEntity registerEntity = list.get(0);
            vo.setMainContractId(registerEntity.getId());
            vo.setMainContractCode(registerEntity.getBillCode());
            vo.setMainContractName(registerEntity.getContractName());
        }
        
        return vo;
    }

    @Override
    public ContractRegisterVO addSupplementByConId(Long mainContractId) {
        ContractRegisterEntity entity = this.selectById(mainContractId);
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractType(entity.getContractType());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(sessionManager.getUserContext().getUserName());
        vo.setDeptId(sessionManager.getUserContext().getDeptId());
        vo.setDeptName(sessionManager.getUserContext().getDeptName());
        vo.setMainContractId(mainContractId);
        vo.setMainContractName(entity.getContractName());
        vo.setMainContractCode(entity.getBillCode());
        
        return vo;
    }

    @Override
    public RegisterSupplementHistoryVO querySupplementRecord(Long id) {
        ContractRegisterEntity entity = this.selectById(id);
        RegisterSupplementHistoryVO vo = new RegisterSupplementHistoryVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        
        // 查询补充协议
        LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterEntity::getMainContractId, id);
        wrapper.orderByDesc(ContractRegisterEntity::getSignDate);
        List<ContractRegisterEntity> supplementList = super.list(wrapper);
        
        vo.setSupplementToalTaxMny(supplementList.stream().map(ContractRegisterEntity::getContractTaxMny).filter(x->x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().map(ContractRegisterEntity::getContractMny).filter(x->x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setDetailList(BeanMapper.mapList(supplementList, ContractRegisterVO.class));
        
        return vo;
    }

    @Override
    public List<ContractRegisterEntity> queryRegisterByReviewId(Long reviewId) {
//        List<Integer> stateList = new ArrayList<>();
//        stateList.add(1);
//        stateList.add(3);
        
        LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterEntity::getReviewId, reviewId);
//        wrapper.in(ContractRegisterEntity::getBillState, stateList);
        
        List<ContractRegisterEntity> list = this.list(wrapper);
        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }

        return list;
    }

    @Override
    public boolean pushContract(ContractRegisterVO vo,Boolean updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            /*if(updateLevel){ // 更新
                delContractFromPool(vo.getId());
            }*/
            if("1".equals(vo.getContractStatus())){
                data.setPerformanceStatus("2");
            }
            if("2".equals(vo.getContractStatus())){
                data.setPerformanceStatus("3");
            }
            if("3".equals(vo.getContractStatus())){
                data.setPerformanceStatus("4");
            }
            data.setChangeStatus(Integer.parseInt(vo.getChangeStatus()));
            data.setContractProperty(1);
            data.setSourceType(ContractTypeEnum.施工合同.getTypeCode());

            data.setUpdateLevel(UpdateLevelEnum.更新非空字段.getLevelCode());
            data.setSourceId(vo.getId());
            String url = null;
            if (vo.getSupplementFlag() == 0) {
                url = "/ejc-proincome-frontend/#/contractRegister/contractApprove?id=" + vo.getId();
            }else {
                url = "/ejc-proincome-frontend/#/contractRegister/supplementCard?id=";
            }
            data.setPcCardUrl(url);
            //data.setMobileCardUrl(baseHost+"ejc-proincome-mobile/#/contractRegister/card");
            data.setCategoryId(1524001989040545793L);// 施工合同类别是自定义档案，合同池写死
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }
        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);

        logger.info("将合同-{}从合同池中删除！", id);
        CommonResponse<String> delDataResp = contractPoolApi.deleteContract(c);
        if(delDataResp.isSuccess()) {
            return true;
        }

        logger.error("将合同-{}从合同池中删除失败, {}！", id, delDataResp.getMsg());
        return false;
    }

    @Override
    public List<Map<String,Object>> queryBudgetWarnContract(List<SqlParam> sqlParamList){
        return mapper.queryBudgetWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String,Object>> queryCostWarnContract(List<SqlParam> sqlParamList){
        return mapper.queryCostWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String,Object>> queryContractRegisterWarnContract(List<SqlParam> sqlParamList){
        return mapper.queryContractRegisterWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String,Object>> querySettleReportWarnContract(List<SqlParam> sqlParamList){
        return mapper.querySettleReportWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String,Object>> queryFinalizedWarnContract(List<SqlParam> sqlParamList){
        return mapper.queryFinalizedWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String,Object>> queryBudgetInWarnContract(List<SqlParam> sqlParamList){
        return mapper.queryBudgetInWarnContract(sqlParamList);
    }

    @Override
    public ContractReviewVO queryReviewByProject(Long projectId) {
        LambdaQueryWrapper<ContractReviewEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractReviewEntity::getProjectId, projectId);
        wrapper.eq(ContractReviewEntity::getSupplementFlag, 0);
        wrapper.eq(BaseEntity::getTenantId, InvocationInfoProxy.getTenantid());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List<ContractReviewEntity> list = reviewService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ContractReviewVO();
        }

        return BeanMapper.map(list.get(0), ContractReviewVO.class);
    }

}
