package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractRelieveEntity;
import com.ejianc.business.pro.income.enums.BillPushStatusEnum;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractRelieveService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("contractRelieve") 
public class ContractRelieveBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IContractRelieveService relieveService;
	
	@Autowired
	private IContractRegisterService registerService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		ContractRelieveEntity entity = relieveService.selectById(billId);

		// 回写合同解除状态
		LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(ContractRegisterEntity::getIsRelieve, 1);
		wrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.已解除.getCode());
		wrapper.eq(BaseEntity::getId, entity.getRegisterId());
		registerService.update(wrapper);


        ContractRegisterEntity contractRegisterEntity = registerService.selectById(entity.getRegisterId());
        //合同推送合同池，更新解除状态
		boolean pushResult = registerService.pushContract(BeanMapper.map(contractRegisterEntity, ContractRegisterVO.class),true);
		if(pushResult) {
            contractRegisterEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		} else {
            contractRegisterEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		registerService.saveOrUpdate(contractRegisterEntity, false);

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		ContractRelieveEntity entity = relieveService.selectById(billId);
		ContractRegisterEntity contractRegisterEntity = registerService.selectById(entity.getRegisterId());

		// 回写合同解除状态
		LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(ContractRegisterEntity::getIsRelieve, 0);
		wrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.履约中.getCode());
		wrapper.eq(BaseEntity::getId, entity.getRegisterId());
		registerService.update(wrapper);

        //合同推送合同池，更新解除状态
        boolean pushResult = registerService.pushContract(BeanMapper.map(contractRegisterEntity, ContractRegisterVO.class),true);
        if(pushResult) {
            contractRegisterEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
        } else {
            contractRegisterEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        }
        registerService.saveOrUpdate(contractRegisterEntity, false);

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
