package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.mapper.ContractReviewMapper;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工合同评审
 * 
 * @author generator
 * 
 */
@Service("contractReviewService")
public class ContractReviewServiceImpl extends BaseServiceImpl<ContractReviewMapper, ContractReviewEntity> implements IContractReviewService{

    private static final String INCOME_CONTRACT_REVIEW = "INCOME_CONTRACT_REVIEW";//此处需要根据实际修改
    
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;
    
    @Autowired
    private SessionManager sessionManager;
    
    @Override
    public ContractReviewVO saveOrUpdate(ContractReviewVO saveorUpdateVO) {
        ContractReviewEntity entity = BeanMapper.map(saveorUpdateVO, ContractReviewEntity.class);

        // 补充协议不限制同一项目只能有一个
        if(1 != saveorUpdateVO.getSupplementFlag()){
            validateReview(entity.getProjectId(), entity.getId());
        }

//        if(entity.getId() == null || entity.getId() == 0){
//            // 新增
//            BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_REVIEW, InvocationInfoProxy.getTenantid(), saveorUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }

        super.saveOrUpdate(entity, false);
        
        return BeanMapper.map(entity, ContractReviewVO.class);
    }

    @Override
    public ContractReviewVO queryDetail(Long id) {
        ContractReviewEntity entity = super.selectById(id);
        return BeanMapper.map(entity, ContractReviewVO.class);
    }

    @Override
    public ContractReviewVO addSupplementByConId(Long mainContractId) {
        ContractReviewVO vo = this.queryDetail(mainContractId);
        ContractReviewVO resultVo = new ContractReviewVO();
        resultVo.setProjectId(vo.getProjectId());
        resultVo.setProjectName(vo.getProjectName());
        resultVo.setProjectCode(vo.getProjectCode());
        resultVo.setOrgId(vo.getOrgId());
        resultVo.setOrgCode(vo.getOrgCode());
        resultVo.setOrgName(vo.getOrgName());
        resultVo.setParentOrgId(vo.getParentOrgId());
        resultVo.setParentOrgCode(vo.getParentOrgCode());
        resultVo.setParentOrgName(vo.getParentOrgName());
        resultVo.setContractName(vo.getContractName());
        
        resultVo.setCustomerId(vo.getCustomerId());
        resultVo.setCustomerName(vo.getCustomerName());
        resultVo.setSupplierId(vo.getSupplierId());
        resultVo.setSupplierName(vo.getSupplierName());
        resultVo.setConstructionPartner(vo.getConstructionPartner());
        resultVo.setTaxRate(vo.getTaxRate());
        resultVo.setContractType(vo.getContractType());
        resultVo.setContractValuationType(vo.getContractValuationType());
        resultVo.setBuiltArea(vo.getBuiltArea());
        resultVo.setContractPartyc(vo.getContractPartyc());
        resultVo.setConjoinedContractTotalMny(vo.getConjoinedContractTotalMny());
        resultVo.setArchitectId(vo.getArchitectId());
        resultVo.setArchitectName(vo.getArchitectName());
        resultVo.setManagerId(vo.getManagerId());
        resultVo.setManagerName(vo.getManagerName());
        resultVo.setEngineeringTypeId(vo.getEngineeringTypeId());
        resultVo.setEngineeringTypeName(vo.getEngineeringTypeName());
//        resultVo.setSettlementType(vo.getSettlementType());
        resultVo.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        resultVo.setEmployeeName(sessionManager.getUserContext().getUserName());
        resultVo.setDeptId(sessionManager.getUserContext().getDeptId());
        resultVo.setDeptName(sessionManager.getUserContext().getDeptName());
        resultVo.setAddress(vo.getAddress());
        resultVo.setMainContractId(mainContractId);
        resultVo.setMainContractName(vo.getContractName());
        resultVo.setMainContractCode(vo.getBillCode());

        resultVo.setBearType(vo.getBearType());
        resultVo.setContractualModel(vo.getContractualModel());
        
        return resultVo;
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        int total = 0; // 总条数
        int pages = 0; // 有几页
        
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("supplementFlag",new Parameter(QueryParam.EQ, 0));
        
        // 查出来非补充协议的合同
        List<ContractReviewEntity> entityList = this.queryList(param);
        List<ContractReviewEntity> list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        List<ContractReviewVO> voList = BeanMapper.mapList(list, ContractReviewVO.class);
        List<Long> idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        
        // 根据合同查出来补充协议
        QueryParam childrenParam = Utils.deepCopy(param);
        if (ListUtil.isNotEmpty(idList)) {
            childrenParam.getParams().put("mainContractId", new Parameter(QueryParam.IN, idList));
        }
//        childrenParam.getParams().remove("supplementFlag");
        childrenParam.getParams().put("supplementFlag",new Parameter(QueryParam.EQ, "1"));
        List<ContractReviewEntity> childrenList = this.queryList(childrenParam);
        List<ContractReviewVO> childrenVoList = BeanMapper.mapList(childrenList, ContractReviewVO.class);
        Map<Long, List<ContractReviewVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(ContractReviewVO::getMainContractId));

        if (param.getSearchText() != null && ListUtil.isNotEmpty(childrenVoList)) {
            List<Long> childrenIdList = new ArrayList<>(childrenMap.keySet());
            param.getParams().put("id", new Parameter(QueryParam.IN, childrenIdList));
            // 搜索补充协议编码，主合同为空。清空搜索条件
            if (ListUtil.isEmpty(entityList)) {
                param.setSearchText(null);
            }
            List<ContractReviewEntity> newEntityList = this.queryList(param);
            // 搜索非补充协议编码，两个结果合并
            entityList.addAll(newEntityList);
            entityList = entityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                    new TreeSet<>(Comparator.comparing(ContractReviewEntity::getId))), ArrayList::new));
            entityList = entityList.stream().sorted(Comparator.comparing(ContractReviewEntity::getCreateTime).reversed()).collect(Collectors.toList());
            list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
            voList = BeanMapper.mapList(list, ContractReviewVO.class);
        }
        
        if (ListUtil.isNotEmpty(voList)) {
            // 拼装数据
            for (ContractReviewVO vo : voList) {
                if (childrenMap.containsKey(vo.getId())) {
                    vo.setChildren(childrenMap.get(vo.getId()));
                }
            }
        }
        
        total = entityList.size();
        if (total % pageSize > 0) {
            pages = (total / pageSize) + 1;
        } else if (total % pageSize == 0) {
            pages = total / pageSize;
        }
        
        JSONObject page = new JSONObject();
        page.put("records", voList);
        page.put("total", total);
        page.put("current", pageIndex);
        page.put("size", pageSize);
        page.put("pages", pages);
        
        return page;
    }

    @Override
    public List<ContractReviewVO> excelExport(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("supplementFlag",new Parameter(QueryParam.EQ, "0"));

        // 查出来非补充协议的合同
        List<ContractReviewEntity> entityList = this.queryList(param);
        List<ContractReviewVO> voList = BeanMapper.mapList(entityList, ContractReviewVO.class);
        List<Long> idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());

        // 根据合同查出来补充协议
        QueryParam childrenParam = Utils.deepCopy(param);
        childrenParam.getParams().put("mainContractId", new Parameter(QueryParam.IN, idList));
        childrenParam.getParams().remove("supplementFlag");
        List<ContractReviewEntity> childrenList = this.queryList(childrenParam);
        List<ContractReviewVO> childrenVoList = BeanMapper.mapList(childrenList, ContractReviewVO.class);
        Map<Long, List<ContractReviewVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(ContractReviewVO::getMainContractId));

        if (param.getSearchText() != null && ListUtil.isNotEmpty(childrenVoList)) {
            List<Long> childrenIdList = new ArrayList<>(childrenMap.keySet());
            param.getParams().put("id", new Parameter(QueryParam.IN, childrenIdList));
            // 搜索补充协议编码，主合同为空。清空搜索条件
            if (ListUtil.isEmpty(entityList)) {
                param.setSearchText(null);
            }
            List<ContractReviewEntity> newEntityList = this.queryList(param);
            // 搜索非补充协议编码，两个结果合并
            entityList.addAll(newEntityList);
            entityList = entityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                    new TreeSet<>(Comparator.comparing(ContractReviewEntity::getId))), ArrayList::new));
            entityList = entityList.stream().sorted(Comparator.comparing(ContractReviewEntity::getCreateTime).reversed()).collect(Collectors.toList());
            voList = BeanMapper.mapList(entityList, ContractReviewVO.class);
        }
        
        List<ContractReviewVO> resultList = new ArrayList<>();
        // 拼装数据
        for (ContractReviewVO vo : voList) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            resultList.add(vo);
            if (childrenMap.containsKey(vo.getId())) {
                for (ContractReviewVO reviewVO : childrenMap.get(vo.getId())) {
                    reviewVO.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                    resultList.add(reviewVO);
                }
            }
        }
        
        return resultList;
    }

    @Override
    public String relationProject(ContractReviewVO vo) {
        
        LambdaUpdateWrapper<ContractReviewEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(ContractReviewEntity::getProjectId, vo.getProjectId());
        wrapper.set(ContractReviewEntity::getProjectCode, vo.getProjectCode());
        wrapper.set(ContractReviewEntity::getProjectName, vo.getProjectName());
        wrapper.set(ContractReviewEntity::getOrgId, vo.getOrgId());
        wrapper.set(ContractReviewEntity::getOrgCode, vo.getOrgCode());
        wrapper.set(ContractReviewEntity::getOrgName, vo.getOrgName());
        wrapper.set(ContractReviewEntity::getParentOrgId, vo.getParentOrgId());
        wrapper.set(ContractReviewEntity::getParentOrgCode, vo.getParentOrgCode());
        wrapper.set(ContractReviewEntity::getParentOrgName, vo.getParentOrgName());
        wrapper.eq(ContractReviewEntity::getId, vo.getId());

        this.update(wrapper);

        return "关联项目成功！";
    }

    @Override
    public Boolean validateReview(Long projectId, Long id) {
        LambdaQueryWrapper<ContractReviewEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractReviewEntity::getProjectId, projectId);
        wrapper.eq(ContractReviewEntity::getTenantId, InvocationInfoProxy.getTenantid());
        if (id != null) {
            wrapper.ne(ContractReviewEntity::getId, id);
        }
        List<ContractReviewEntity> list = this.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("当前项目存在其他评审，不允许新增/修改!");
        }

        return true;
    }


}
