package com.ejianc.business.pro.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.business.pro.other.history.OtherContractRelieveHistoryVO;
import com.ejianc.business.pro.other.service.IOtherContractService;
import com.ejianc.business.pro.other.vo.OtherContractRelieveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.other.mapper.OtherContractRelieveMapper;
import com.ejianc.business.pro.other.bean.OtherContractRelieveEntity;
import com.ejianc.business.pro.other.service.IOtherContractRelieveService;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 其他收入合同解除
 * 
 * @author generator
 * 
 */
@Service("otherContractRelieveService")
public class OtherContractRelieveServiceImpl extends BaseServiceImpl<OtherContractRelieveMapper, OtherContractRelieveEntity> implements IOtherContractRelieveService{

    private static final String OTHER_CONTRACT_RELIEVE = "OTHER_CONTRACT_RELIEVE";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOtherContractService service;


    @Override
    public OtherContractRelieveVO saveOrUpdate(OtherContractRelieveVO saveorUpdateVO) {
        OtherContractRelieveEntity entity = BeanMapper.map(saveorUpdateVO, OtherContractRelieveEntity.class);
        validateContract(entity.getContractId(),entity.getId());
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(OTHER_CONTRACT_RELIEVE, InvocationInfoProxy.getTenantid(), saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);

        return BeanMapper.map(this.selectById(entity.getId()), OtherContractRelieveVO.class);
    }


    @Override
    public OtherContractRelieveHistoryVO queryRelieveRecord(Long id) {
        OtherContractEntity entity = service.selectById(id);
        OtherContractRelieveHistoryVO vo = new OtherContractRelieveHistoryVO();
        vo.setContractId(entity.getId());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        LambdaQueryWrapper<OtherContractRelieveEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OtherContractRelieveEntity::getContractId, id);
        wrapper.orderByDesc(OtherContractRelieveEntity::getRelieveDate);
        List<OtherContractRelieveEntity> list = super.list(wrapper);
        vo.setDetailList(BeanMapper.mapList(list, OtherContractRelieveVO.class));
        return vo;
    }

    public Boolean validateContract(Long contractId, Long id) {
        //同一个合同只能存在一个
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        //queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, "1,3"));
        if (!Objects.equals(null, id)) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<OtherContractRelieveEntity> list = super.queryList(queryParam, false);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在合同解除，不允许新增!");
        }
        return true;
    }
}
