package com.ejianc.business.pro.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.other.vo.OtherDetailVO;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.other.mapper.OtherDetailMapper;
import com.ejianc.business.pro.other.bean.OtherDetailEntity;
import com.ejianc.business.pro.other.service.IOtherDetailService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 其他收入合同清单
 * 
 * @author generator
 * 
 */
@Service("otherDetailService")
public class OtherDetailServiceImpl extends BaseServiceImpl<OtherDetailMapper, OtherDetailEntity> implements IOtherDetailService{

    @Override
    public void deleteByContractId(Long id) {
        QueryWrapper<OtherDetailEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("contract_id", id);
        baseMapper.delete(deleteWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<OtherDetailVO> successList = new ArrayList<>();
        List<OtherDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            if (mf == null) {
                throw new BusinessException("导入的文件中没有数据");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                List<OtherDetailVO> detailVoList = new ArrayList<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    OtherDetailVO vo = new OtherDetailVO();
                    String warnType = "";
                    if(StringUtils.isEmpty(datas.get(0))){// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType+"编码为空]";
                    }else{
                        vo.setCode(datas.get(0));
                    }

                    if (StringUtils.isEmpty(datas.get(1))) {//清单名称为空
                        vo.setName(null);
                        warnType =  warnType+"[名称为空]";
                    } else {
                        vo.setName(datas.get(1));
                    }

                    vo.setUnit(datas.get(2));//计量单位

                    if (StringUtils.isEmpty(datas.get(3))) {
                        vo.setDetailTaxRate(null);
                    } else {
                        try {
                            vo.setDetailTaxRate(new BigDecimal(datas.get(3)));
                        } catch (Exception e) {
                            vo.setDetailTaxRate(null);
                            warnType = warnType+"[税率只能为数字或小数]";
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(4))) {
                        vo.setNum(null);
                        warnType = warnType+"[数量为空]";
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType+"[数量只能为数字或小数]";
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setPrice(null);
                    } else {
                        try {
                            vo.setPrice(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType+"[单价(无税)只能为数字或小数]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(6))) {
                        vo.setDetailTaxPrice(null);
                    } else {
                        try {
                            vo.setDetailTaxPrice(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            vo.setDetailTaxPrice(null);
                            warnType = warnType+"[单价只能为数字或小数]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(7))) {
                        vo.setMny(null);
                    } else {
                        try {
                            vo.setMny(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            vo.setMny(null);
                            warnType = warnType+"[合价(无税)只能为数字或小数]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(8))) {
                        vo.setDetailTaxMny(null);
                    } else {
                        try {
                            vo.setDetailTaxMny(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            vo.setDetailTaxMny(null);
                            warnType = warnType+"[合价只能为数字或小数]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {
                        vo.setDetailTax(null);
                    } else {
                        try {
                            vo.setDetailTax(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            vo.setDetailTax(null);
                            warnType = warnType+"[税额只能为数字或小数]";
                        }
                    }

                    vo.setMemo(datas.get(10));
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setChangeType(3);//增补项
                    detailVoList.add(vo);
                }
                if(CollectionUtils.isNotEmpty(detailVoList)){
                    detailVoList.forEach(vo ->{
                        if(StringUtils.isEmpty(vo.getWarnType())){
                            successList.add(vo);
                        } else {
                            errorList.add(vo);
                        }
                    });
                }
                new TaxCalculateUtil<OtherDetailVO>().calculate(successList);
                resp.put("successList",successList);
                resp.put("errorList",errorList);
                resp.put("successNum",successList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }
    //清单参照
    @Override
    public List<OtherDetailVO> detailRef(Long contractId) {
        QueryWrapper<OtherDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId);
        wrapper.ne("change_type",5);//中止不显示
        wrapper.orderBy(true,true,"create_time");
        List<OtherDetailEntity> entities = baseMapper.selectList(wrapper);
        List<OtherDetailVO> detailVos = BeanMapper.mapList(entities, OtherDetailVO.class);
        return detailVos;
    }

}
