package com.ejianc.business.pro.recipetApply.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.pro.recipetApply.bean.RecipetApplyQuoteEntity;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyAccountEntity;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyAwardPunishEntity;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyOtherEntity;
/**
 * 收款申请单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_receipt_apply")
public class RecipetApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_id")
    private Long createUserId; // 创建者账号
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 项目部id
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部所属组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 合同类别id
    @TableField(value="contract_category_code")
    private String contractCategoryCode; // 合同类别编码
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 合同类别名称
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否主合同：0-主合同 1-补充协议
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="customer_id")
    private Long customerId; // 甲方id
    @TableField(value="customer_name")
    private String customerName; // 甲方名称
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="apply_date")
    private Date applyDate; // 申请日期 根据当前日期时间默认，可修改 前端显示 年月日 后台保持要时分秒
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id（申请人）
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称（申请人）
    @TableField(value="department_id")
    private Long departmentId; // 经办（申请人）部门id
    @TableField(value="department_name")
    private String departmentName; // 经办（申请人）部门名称
    @TableField(value="memo")
    private String memo; // 收款内容  非必填，0-500字
    @TableField(value="clause_property_id")
    private Long clausePropertyId; // 款项属性id
    @TableField(value="clause_property_name")
    private String clausePropertyName; // 款项属性名称
    @TableField(value="source_category_type")
    private String sourceCategoryType; // 合同大类id
    @TableField(value="source_category_type_name")
    private String sourceCategoryTypeName; // 合同大类名称
    @TableField(value="source_flag")
    private Integer sourceFlag; // 来源标识
    @TableField(value="receipt_apply_id")
    private String receiptApplyId; // 收款申请单号id
    @TableField(value="receipt_apply_name")
    private String receiptApplyName; // 收款申请单号名称
    @TableField(value="actual_received_mny")
    private BigDecimal actualReceivedMny; // 实际收款金额
    @TableField(value="total_apply_tax_mny")
    private BigDecimal totalApplyTaxMny; // 本期申请金额合计
    @TableField(value="total_apply_mny")
    private BigDecimal totalApplyMny; // 本期申请金额合计(无税)
    @TableField(value="total_quote_tax_mny")
    private BigDecimal totalQuoteTaxMny; // 本期工程进度款
    @TableField(value="total_quote_mny")
    private BigDecimal totalQuoteMny; // 本期工程进度款(无税)
    @TableField(value="total_award_punish_tax_mny")
    private BigDecimal totalAwardPunishTaxMny; // 本期甲方奖罚款
    @TableField(value="total_award_punish_mny")
    private BigDecimal totalAwardPunishMny; // 本期甲方奖罚款(无税)
    @TableField(value="total_account_tax_mny")
    private BigDecimal totalAccountTaxMny; // 本期材料扣款
    @TableField(value="total_account_mny")
    private BigDecimal totalAccountMny; // 本期材料扣款(无税)
    @TableField(value="total_other_tax_mny")
    private BigDecimal totalOtherTaxMny; // 本期其他费用
    @TableField(value="total_other_mny")
    private BigDecimal totalOtherMny; // 本期其他费用(无税)
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="recipetApplyQuoteService",pidName = "applyId")
    private List<RecipetApplyQuoteEntity> recipetApplyQuoteList = new ArrayList<>(); // 工程进度款
    @TableField(exist=false)
    @SubEntity(serviceName="recipetApplyAccountService",pidName = "applyId")
    private List<RecipetApplyAccountEntity> recipetApplyAccountList = new ArrayList<>(); // 材料扣款
    @TableField(exist=false)
    @SubEntity(serviceName="recipetApplyAwardPunishService",pidName = "applyId")
    private List<RecipetApplyAwardPunishEntity> recipetApplyAwardPunishList = new ArrayList<>(); // 甲方奖罚款
    @TableField(exist=false)
    @SubEntity(serviceName="recipetApplyOtherService",pidName = "applyId")
    private List<RecipetApplyOtherEntity> recipetApplyOtherList = new ArrayList<>(); // 其他费用
    

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryCode() {
        return contractCategoryCode;
    }

    public void setContractCategoryCode(String contractCategoryCode) {
        this.contractCategoryCode = contractCategoryCode;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getClausePropertyId() {
        return clausePropertyId;
    }

    public void setClausePropertyId(Long clausePropertyId) {
        this.clausePropertyId = clausePropertyId;
    }
    public String getClausePropertyName() {
        return clausePropertyName;
    }

    public void setClausePropertyName(String clausePropertyName) {
        this.clausePropertyName = clausePropertyName;
    }
    public String getSourceCategoryType() {
        return sourceCategoryType;
    }

    public void setSourceCategoryType(String sourceCategoryType) {
        this.sourceCategoryType = sourceCategoryType;
    }
    public String getSourceCategoryTypeName() {
        return sourceCategoryTypeName;
    }

    public void setSourceCategoryTypeName(String sourceCategoryTypeName) {
        this.sourceCategoryTypeName = sourceCategoryTypeName;
    }
    public Integer getSourceFlag() {
        return sourceFlag;
    }

    public void setSourceFlag(Integer sourceFlag) {
        this.sourceFlag = sourceFlag;
    }
    public String getReceiptApplyId() {
        return receiptApplyId;
    }

    public void setReceiptApplyId(String receiptApplyId) {
        this.receiptApplyId = receiptApplyId;
    }
    public String getReceiptApplyName() {
        return receiptApplyName;
    }

    public void setReceiptApplyName(String receiptApplyName) {
        this.receiptApplyName = receiptApplyName;
    }
    public BigDecimal getActualReceivedMny() {
        return actualReceivedMny;
    }

    public void setActualReceivedMny(BigDecimal actualReceivedMny) {
        this.actualReceivedMny = actualReceivedMny;
    }
    public BigDecimal getTotalApplyTaxMny() {
        return totalApplyTaxMny;
    }

    public void setTotalApplyTaxMny(BigDecimal totalApplyTaxMny) {
        this.totalApplyTaxMny = totalApplyTaxMny;
    }
    public BigDecimal getTotalApplyMny() {
        return totalApplyMny;
    }

    public void setTotalApplyMny(BigDecimal totalApplyMny) {
        this.totalApplyMny = totalApplyMny;
    }
    public BigDecimal getTotalQuoteTaxMny() {
        return totalQuoteTaxMny;
    }

    public void setTotalQuoteTaxMny(BigDecimal totalQuoteTaxMny) {
        this.totalQuoteTaxMny = totalQuoteTaxMny;
    }
    public BigDecimal getTotalQuoteMny() {
        return totalQuoteMny;
    }

    public void setTotalQuoteMny(BigDecimal totalQuoteMny) {
        this.totalQuoteMny = totalQuoteMny;
    }
    public BigDecimal getTotalAwardPunishTaxMny() {
        return totalAwardPunishTaxMny;
    }

    public void setTotalAwardPunishTaxMny(BigDecimal totalAwardPunishTaxMny) {
        this.totalAwardPunishTaxMny = totalAwardPunishTaxMny;
    }
    public BigDecimal getTotalAwardPunishMny() {
        return totalAwardPunishMny;
    }

    public void setTotalAwardPunishMny(BigDecimal totalAwardPunishMny) {
        this.totalAwardPunishMny = totalAwardPunishMny;
    }
    public BigDecimal getTotalAccountTaxMny() {
        return totalAccountTaxMny;
    }

    public void setTotalAccountTaxMny(BigDecimal totalAccountTaxMny) {
        this.totalAccountTaxMny = totalAccountTaxMny;
    }
    public BigDecimal getTotalAccountMny() {
        return totalAccountMny;
    }

    public void setTotalAccountMny(BigDecimal totalAccountMny) {
        this.totalAccountMny = totalAccountMny;
    }
    public BigDecimal getTotalOtherTaxMny() {
        return totalOtherTaxMny;
    }

    public void setTotalOtherTaxMny(BigDecimal totalOtherTaxMny) {
        this.totalOtherTaxMny = totalOtherTaxMny;
    }
    public BigDecimal getTotalOtherMny() {
        return totalOtherMny;
    }

    public void setTotalOtherMny(BigDecimal totalOtherMny) {
        this.totalOtherMny = totalOtherMny;
    }
    

    public List<RecipetApplyQuoteEntity> getRecipetApplyQuoteList() {
        return recipetApplyQuoteList;
    }

    public void setRecipetApplyQuoteList(List<RecipetApplyQuoteEntity> recipetApplyQuoteList) {
        this.recipetApplyQuoteList = recipetApplyQuoteList;
    }

    public List<RecipetApplyAccountEntity> getRecipetApplyAccountList() {
        return recipetApplyAccountList;
    }

    public void setRecipetApplyAccountList(List<RecipetApplyAccountEntity> recipetApplyAccountList) {
        this.recipetApplyAccountList = recipetApplyAccountList;
    }

    public List<RecipetApplyAwardPunishEntity> getRecipetApplyAwardPunishList() {
        return recipetApplyAwardPunishList;
    }

    public void setRecipetApplyAwardPunishList(List<RecipetApplyAwardPunishEntity> recipetApplyAwardPunishList) {
        this.recipetApplyAwardPunishList = recipetApplyAwardPunishList;
    }

    public List<RecipetApplyOtherEntity> getRecipetApplyOtherList() {
        return recipetApplyOtherList;
    }

    public void setRecipetApplyOtherList(List<RecipetApplyOtherEntity> recipetApplyOtherList) {
        this.recipetApplyOtherList = recipetApplyOtherList;
    }
}
