package com.ejianc.business.pro.recipetApply.controller.api;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyEntity;
import com.ejianc.business.pro.recipetApply.service.IRecipetApplyService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;

@RestController
@RequestMapping("/api/WbRecipetApplyApi")
public class WbRecipetApplyApi {

    @Autowired
    private IRecipetApplyService recaService;

    @GetMapping("/wbActualReceivedMny")
    public CommonResponse<String> wbActualReceivedMny(@RequestParam(value = "mny") BigDecimal mny,@RequestParam(value = "id") Long id,@RequestParam(value = "flag") boolean flag){
        LambdaUpdateWrapper<RecipetApplyEntity> recld = new LambdaUpdateWrapper<>();
        recld.eq(RecipetApplyEntity::getTenantId, InvocationInfoProxy.getTenantid());
        recld.eq(RecipetApplyEntity::getId,id);
        if (flag){
            recld.setSql("actual_received_mny = IFNULL(actual_received_mny,0) + IFNULL("+mny+",0)");
        }else {
            recld.setSql("actual_received_mny = IFNULL(actual_received_mny,0) - IFNULL("+mny+",0)");
        }
        recaService.update(recld);
        return CommonResponse.success("回写成功");
    }
}
