package com.ejianc.business.pro.recipetApply.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.AccountEntity;
import com.ejianc.business.pro.income.bean.AwardPunishEntity;
import com.ejianc.business.pro.income.bean.QuoteEntity;
import com.ejianc.business.pro.income.service.IAccountService;
import com.ejianc.business.pro.income.service.IAwardPunishService;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyAccountEntity;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyAwardPunishEntity;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyQuoteEntity;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.recipetApply.mapper.RecipetApplyMapper;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyEntity;
import com.ejianc.business.pro.recipetApply.service.IRecipetApplyService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 收款申请单
 * 
 * @author generator
 * 
 */
@Service("recipetApplyService")
public class RecipetApplyServiceImpl extends BaseServiceImpl<RecipetApplyMapper, RecipetApplyEntity> implements IRecipetApplyService{
    @Autowired
    private IAccountService accounts;

    @Autowired
    private IQuoteService quotes;

    @Autowired
    private IAwardPunishService answerPun;

    @Override
    public Map<String,BigDecimal> getTotalMny(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(IFNULL(total_apply_tax_mny,0)) as totalApplyTaxMny,sum(IFNULL(actual_received_mny,0)) as actualReceivedMny");
        wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        Map<String, BigDecimal> result = super.getMap(wrapper);
        if (result!=null){
            BigDecimal totalApplyTaxMny = result.get("totalApplyTaxMny")!=null?result.get("totalApplyTaxMny"):BigDecimal.ZERO;
            BigDecimal actualReceivedMny = result.get("actualReceivedMny")!=null?result.get("actualReceivedMny") : BigDecimal.ZERO;
            result.put("totalApplyTaxMny",totalApplyTaxMny);
            result.put("actualReceivedMny",actualReceivedMny);
        }else {
            result = new HashMap<>();
            result.put("totalApplyTaxMny",BigDecimal.ZERO);
            result.put("actualReceivedMny",BigDecimal.ZERO);
        }
        return result;
    }

    @Override
    public String wbActualReceivedMny(Long id,boolean flag) {
        RecipetApplyEntity entity = super.selectById(id);
        if (entity!=null){
            //回写产值报量
            List<RecipetApplyQuoteEntity> qvos = entity.getRecipetApplyQuoteList();
            if (CollectionUtils.isNotEmpty(qvos)){
                qvos.forEach(e->{
                    LambdaUpdateWrapper<QuoteEntity> qld = new LambdaUpdateWrapper<>();
                    qld.eq(QuoteEntity::getTenantId, InvocationInfoProxy.getTenantid());
                    qld.eq(QuoteEntity::getId,e.getSourceId());
                    if (flag){
                        qld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) + IFNULL("+e.getTheApplyTaxMny()+",0),applied_mny = IFNULL(applied_mny,0) + IFNULL("+e.getTheApplyMny()+",0)");
                    }else {
                        qld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) - IFNULL("+e.getTheApplyTaxMny()+",0),applied_mny = IFNULL(applied_mny,0) - IFNULL("+e.getTheApplyMny()+",0)");
                    }
                    quotes.update(qld);
                });
            }
            //回写甲方对账单
            List<RecipetApplyAccountEntity> accvos = entity.getRecipetApplyAccountList();
            if (CollectionUtils.isNotEmpty(accvos)){
                accvos.forEach(e->{
                    LambdaUpdateWrapper<AccountEntity> accld = new LambdaUpdateWrapper<>();
                    accld.eq(AccountEntity::getTenantId, InvocationInfoProxy.getTenantid());
                    accld.eq(AccountEntity::getId,e.getSourceId());
                    if (flag){
                        accld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) + IFNULL("+e.getTheApplyTaxMny()+",0),applied_mny = IFNULL(applied_mny,0) + IFNULL("+e.getTheApplyMny()+",0)");
                    }else {
                        accld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) - IFNULL("+e.getTheApplyTaxMny()+",0),applied_mny = IFNULL(applied_mny,0) - IFNULL("+e.getTheApplyMny()+",0)");
                    }
                    accounts.update(accld);
                });
            }
            //回写甲方奖罚单
            List<RecipetApplyAwardPunishEntity> awvos = entity.getRecipetApplyAwardPunishList();
            if (CollectionUtils.isNotEmpty(awvos)){
                awvos.forEach(e->{
                    LambdaUpdateWrapper<AwardPunishEntity> awld = new LambdaUpdateWrapper<>();
                    awld.eq(AwardPunishEntity::getTenantId, InvocationInfoProxy.getTenantid());
                    awld.eq(AwardPunishEntity::getId,e.getSourceId());
                    if (flag){
                        awld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) + IFNULL("+e.getTheApplyTaxMny()+",0),applied_mny = IFNULL(applied_mny,0) + IFNULL("+e.getTheApplyMny()+",0)");
                    }else {
                        awld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) - IFNULL("+e.getTheApplyTaxMny()+",0),applied_mny = IFNULL(applied_mny,0) - IFNULL("+e.getTheApplyMny()+",0)");
                    }
                    answerPun.update(awld);
                });
            }
        }
        return "回写成功";
    }

    @Override
    public String validateContract(Long contractId, Long id) {
        LambdaQueryWrapper<RecipetApplyEntity> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RecipetApplyEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(RecipetApplyEntity::getDr,0);
        queryWrapper.notIn(RecipetApplyEntity::getBillState, 1,3);
        if (id != null){
            queryWrapper.ne(RecipetApplyEntity::getId,id);
        }
        queryWrapper.eq(RecipetApplyEntity::getContractId,contractId);
        List<RecipetApplyEntity> list = this.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同下存在非审批通过态的收款申请单，不允许新增!");
        }
        return "校验成功！";
    }
}
