package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.ContractRegisterChangeEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.mapper.ContractRegisterChangeMapper;
import com.ejianc.business.pro.income.service.IContractRegisterChangeService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.ContractRegisterChangeVO;
import com.ejianc.business.pro.income.vo.RegisterChangeHistoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 合同登记变更
 * 
 * @author generator
 * 
 */
@Service("contractRegisterChangeService")
public class ContractRegisterChangeServiceImpl extends BaseServiceImpl<ContractRegisterChangeMapper, ContractRegisterChangeEntity> implements IContractRegisterChangeService{

    private static final String INCOME_CONTRACT_REGISTER_CHANGE = "INCOME_CONTRACT_REGISTER_CHANGE";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IContractRegisterService registerService;
    
    
    @Override
    public ContractRegisterChangeVO saveOrUpdate(ContractRegisterChangeVO saveorUpdateVO) {
        ContractRegisterChangeEntity entity = BeanMapper.map(saveorUpdateVO, ContractRegisterChangeEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(entity.getId() == null || entity.getId() == 0){
            // 新增
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                entity.setChangeVersion(1);//第一次变更
            } else {
                entity.setChangeVersion(entity.getChangeVersion() + 1);//版本号+1
            }
            if("2".equals(saveorUpdateVO.getChangeStatus())){
                throw new BusinessException("合同存在变更中单据，不允许保存!");
            }

//            BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_REGISTER_CHANGE, InvocationInfoProxy.getTenantid(),saveorUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }

            if(entity.getChangeVersion() < 10){
                entity.setBillCode(entity.getMainContractCode() + "-1-" + "0" + entity.getChangeVersion());
            } else {
                entity.setBillCode(entity.getMainContractCode() + "-1-" + entity.getChangeVersion());
            }

            //校验合同编号是否重复
            LambdaQueryWrapper<ContractRegisterChangeEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractRegisterChangeEntity::getTenantId, tenantId);
            lambda.eq(ContractRegisterChangeEntity::getBillCode, entity.getBillCode());
            lambda.ne(ContractRegisterChangeEntity::getRegisterId, entity.getRegisterId());
            List<ContractRegisterChangeEntity> entityList = super.list(lambda);
            if (ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else {
            // 修改
            if(StringUtils.isEmpty(entity.getBillCode())){
                entity.setBillCode(null);
            }

            // 校验合同编号是否重复
            LambdaQueryWrapper<ContractRegisterChangeEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractRegisterChangeEntity::getBillCode, entity.getBillCode());
            lambda.eq(ContractRegisterChangeEntity::getTenantId, tenantId);
            lambda.ne(ContractRegisterChangeEntity::getId, entity.getId());
            lambda.ne(ContractRegisterChangeEntity::getRegisterId, entity.getRegisterId());
            List<ContractRegisterChangeEntity> entityList = super.list(lambda);
            if (ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }

        entity.setContractTaxMny(ComputeUtil.safeAdd(entity.getContractTaxMny(), entity.getThisChangeTaxMny()));
        entity.setContractMny(ComputeUtil.safeAdd(entity.getContractMny(), entity.getThisChangeMny()));
        entity.setTaxMny(ComputeUtil.safeAdd(entity.getTaxMny(), entity.getThisChangeTax()));


        super.saveOrUpdate(entity, false);


        // 回写主表
        LambdaUpdateWrapper<ContractRegisterEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractRegisterEntity::getChangingTaxMny, entity.getContractTaxMny());
        updateWrapper.set(ContractRegisterEntity::getChangingMny, entity.getContractMny());
        updateWrapper.set(ContractRegisterEntity::getChangeId, entity.getId());
        updateWrapper.set(ContractRegisterEntity::getChangeStatus, "2");
        updateWrapper.set(ContractRegisterEntity::getChangeCode, entity.getBillCode());
        updateWrapper.eq(ContractRegisterEntity::getId, entity.getRegisterId());
        registerService.update(updateWrapper);

        return BeanMapper.map(this.selectById(entity.getId()), ContractRegisterChangeVO.class);
    }

    @Override
    public void deleteChange(List<ContractRegisterChangeVO> vos) {
        for (ContractRegisterChangeVO vo : vos) {
            ContractRegisterChangeEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(ContractRegisterEntity::getChangingTaxMny,BigDecimal.ZERO);
            wrapper.set(ContractRegisterEntity::getChangingMny,BigDecimal.ZERO);
            if (changeEntity.getChangeVersion() == 1) {
                wrapper.set(ContractRegisterEntity::getChangeStatus, 1);
            }else {
                wrapper.set(ContractRegisterEntity::getChangeStatus, 3);
            }
            wrapper.eq(ContractRegisterEntity::getId, changeEntity.getRegisterId());
            registerService.update(wrapper);
            super.removeById(vo, false);
        }
    }

    @Override
    public ContractRegisterChangeVO addChangeByConId(Long registerId) {
        ContractRegisterEntity entity = registerService.selectById(registerId);
        ContractRegisterChangeVO vo = BeanMapper.map(entity, ContractRegisterChangeVO.class);
        vo.setId(null);
        vo.setRegisterId(entity.getId());
        vo.setChangeTime(new Date());
        vo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        vo.setBeforeChangeMny(entity.getContractMny());
        vo.setMainContractId(entity.getId());
        vo.setMainContractCode(entity.getBillCode());
        vo.setMainContractName(entity.getContractName());
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setChangeReason(null);
        
        return vo;
    }

    @Override
    public RegisterChangeHistoryVO queryChangeRecord(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<ContractRegisterChangeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterChangeEntity::getRegisterId, id);
        wrapper.in(ContractRegisterChangeEntity::getBillState, billStatus);
        wrapper.orderByDesc(ContractRegisterChangeEntity::getUsedTime);
        List<ContractRegisterChangeEntity> changeEntityList = this.list(wrapper);

        // 原合同
        ContractRegisterEntity registerEntity = registerService.selectById(id);

        RegisterChangeHistoryVO vo = new RegisterChangeHistoryVO();
        vo.setRegisterId(registerEntity.getId());
        vo.setContractTaxMny(registerEntity.getContractTaxMny()== null ? BigDecimal.ZERO : registerEntity.getContractTaxMny());
        vo.setContractMny(registerEntity.getContractMny()== null ? BigDecimal.ZERO : registerEntity.getContractMny());
        vo.setBaseTaxMoney(registerEntity.getBaseTaxMoney()== null ? BigDecimal.ZERO : registerEntity.getBaseTaxMoney());
        vo.setBaseMoney(registerEntity.getBaseMoney()== null ? BigDecimal.ZERO : registerEntity.getBaseMoney());
        vo.setChangeStatus(registerEntity.getChangeStatus());
        vo.setIsFinish(registerEntity.getIsFinish());
        vo.setIsRelieve(registerEntity.getIsRelieve());
        vo.setIsSuspend(registerEntity.getIsSuspend());

        BigDecimal changeMny = ComputeUtil.safeSub(vo.getContractTaxMny(), vo.getBaseTaxMoney());
        vo.setSumChangeMny(changeMny);
        BigDecimal sumChangeRate = BigDecimal.ZERO;
        if (vo.getBaseTaxMoney().compareTo(BigDecimal.ZERO) != 0) {
            sumChangeRate = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getSumChangeMny(), vo.getBaseTaxMoney()), new BigDecimal("100"));
        }
        vo.setSumScale(sumChangeRate);

        List<ContractRegisterChangeVO> changeVOList = BeanMapper.mapList(changeEntityList, ContractRegisterChangeVO.class);
        int index = 1;
        for (ContractRegisterChangeVO changeVO : changeVOList) {
            changeVO.setHistoryBillCode(registerEntity.getBillCode() + "-" + index);
            BigDecimal subtract = ComputeUtil.safeSub(changeVO.getContractTaxMny(), changeVO.getBeforeChangeTaxMny());
            BigDecimal changeRate = BigDecimal.ZERO;
            if (changeVO.getBeforeChangeTaxMny() != null && changeVO.getBeforeChangeTaxMny().compareTo(BigDecimal.ZERO) != 0) {
                changeRate = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(subtract, changeVO.getBeforeChangeTaxMny()), new BigDecimal("100"));
            }
            changeVO.setScale(changeRate);
            index++;
        }
        vo.setChangeRecord(changeVOList);
        
        return vo;
    }
}
