package com.ejianc.business.pro.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 清单明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_budget_detail")
public class BudgetDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="budget_id")
    private Long budgetId; // 预算书主键
    @TableField(value="budget_bid")
    private Long budgetBid; // 清单项主键
    @TableField(value="detail_type")
    private Integer detailType; // 清单项类型:0-分部分项，1-措施项，2-其他项，3-费税
    @TableField(value="detail_code")
    private String detailCode; // 编码
    @TableField(value="detail_name")
    private String detailName; // 名称
    @TableField(value="detail_spec")
    private String detailSpec; // 规格
    @TableField(value="detail_unit")
    private String detailUnit; // 单位
    @TableField(value="detail_num")
    private java.math.BigDecimal detailNum; // 工程量
    @TableField(value="detail_tax_rate")
    private java.math.BigDecimal detailTaxRate; // 税率
    @TableField(value="detail_price")
    private java.math.BigDecimal detailPrice; // 综合单价(无税)
    @TableField(value="detail_tax_price")
    private java.math.BigDecimal detailTaxPrice; // 综合单价(含税)
    @TableField(value="detail_mny")
    private java.math.BigDecimal detailMny; // 合价(无税)
    @TableField(value="detail_tax_mny")
    private java.math.BigDecimal detailTaxMny; // 合价(含税)
    @TableField(value="detail_tax")
    private java.math.BigDecimal detailTax; // 税额
    @TableField(value="detail_memo")
    private String detailMemo; // 备注
    @TableField(exist = false)
    private String tbid;
    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;
    @TableField(value="parent_id")
    private Long parentId; // 父ID
    @TableField(value="detail_index")
    private String detailIndex; // 序号
    @TableField(value="leaf_flag")
    private Boolean leafFlag; // 是否末级
    @TableField(value="content")
    private java.math.BigDecimal content; // 含量
    @TableField(value="detail_subject_id")
    private Long detailSubjectId; // 成本科目id
    @TableField(value="detail_subject_name")
    private String detailSubjectName; // 成本科目名称

    @TableField(value = "detail_compositive_coefficient_name")
    private String detailCompositiveCoefficientName; //综合系数名称
    @TableField(value = "detail_compositive_coefficient_id")
    private Long detailCompositiveCoefficientId; //综合系数id
    @TableField(value = "detail_compositive_coefficient")
    private BigDecimal detailCompositiveCoefficient; //综合系数

    @TableField(value = "detail_item_type")
    private String detailItemType; //清单类型  用于导入数据区分

    @TableField(value = "detail_price_type")
    private Integer detailPriceType; //价税计算类型：0-无税优先， 1-含税优先

    public Integer getDetailPriceType() {
        return detailPriceType;
    }

    public void setDetailPriceType(Integer detailPriceType) {
        this.detailPriceType = detailPriceType;
    }

    public String getDetailItemType() {
        return detailItemType;
    }

    public void setDetailItemType(String detailItemType) {
        this.detailItemType = detailItemType;
    }

    public String getDetailCompositiveCoefficientName() {
        return detailCompositiveCoefficientName;
    }

    public void setDetailCompositiveCoefficientName(String detailCompositiveCoefficientName) {
        this.detailCompositiveCoefficientName = detailCompositiveCoefficientName;
    }

    public Long getDetailCompositiveCoefficientId() {
        return detailCompositiveCoefficientId;
    }

    public void setDetailCompositiveCoefficientId(Long detailCompositiveCoefficientId) {
        this.detailCompositiveCoefficientId = detailCompositiveCoefficientId;
    }

    public BigDecimal getDetailCompositiveCoefficient() {
        return detailCompositiveCoefficient;
    }

    public void setDetailCompositiveCoefficient(BigDecimal detailCompositiveCoefficient) {
        this.detailCompositiveCoefficient = detailCompositiveCoefficient;
    }

    public String getTbid() {
        return tbid;
    }

    public void setTbid(String tbid) {
        this.tbid = tbid;
    }

    public BigDecimal getContent() {
        return content;
    }

    public void setContent(BigDecimal content) {
        this.content = content;
    }

    public Long getDetailSubjectId() {
        return detailSubjectId;
    }

    public void setDetailSubjectId(Long detailSubjectId) {
        this.detailSubjectId = detailSubjectId;
    }

    public String getDetailSubjectName() {
        return detailSubjectName;
    }

    public void setDetailSubjectName(String detailSubjectName) {
        this.detailSubjectName = detailSubjectName;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 清单项主键
     */
    public Long getBudgetBid() {
        return budgetBid;
    }

    /**
     * 清单项主键
     */
    public void setBudgetBid(Long budgetBid) {
        this.budgetBid = budgetBid;
    }
    /**
     * 清单项类型:0-分部分项，1-措施项，2-其他项，3-费税
     */
    public Integer getDetailType() {
        return detailType;
    }

    /**
     * 清单项类型:0-分部分项，1-措施项，2-其他项，3-费税
     */
    public void setDetailType(Integer detailType) {
        this.detailType = detailType;
    }
    /**
     * 编码
     */
    public String getDetailCode() {
        return detailCode;
    }

    /**
     * 编码
     */
    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }
    /**
     * 名称
     */
    public String getDetailName() {
        return detailName;
    }

    /**
     * 名称
     */
    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }
    /**
     * 规格
     */
    public String getDetailSpec() {
        return detailSpec;
    }

    /**
     * 规格
     */
    public void setDetailSpec(String detailSpec) {
        this.detailSpec = detailSpec;
    }
    /**
     * 单位
     */
    public String getDetailUnit() {
        return detailUnit;
    }

    /**
     * 单位
     */
    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getDetailNum() {
        return detailNum;
    }

    /**
     * 工程量
     */
    public void setDetailNum(java.math.BigDecimal detailNum) {
        this.detailNum = detailNum;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    /**
     * 税率
     */
    public void setDetailTaxRate(java.math.BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    /**
     * 综合单价(无税)
     */
    public java.math.BigDecimal getDetailPrice() {
        return detailPrice;
    }

    /**
     * 综合单价(无税)
     */
    public void setDetailPrice(java.math.BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    /**
     * 综合单价(含税)
     */
    public java.math.BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    /**
     * 综合单价(含税)
     */
    public void setDetailTaxPrice(java.math.BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    /**
     * 合价(无税)
     */
    public java.math.BigDecimal getDetailMny() {
        return detailMny;
    }

    /**
     * 合价(无税)
     */
    public void setDetailMny(java.math.BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    /**
     * 合价(含税)
     */
    public java.math.BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setDetailTaxMny(java.math.BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    /**
     * 备注
     */
    public String getDetailMemo() {
        return detailMemo;
    }

    /**
     * 备注
     */
    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    
}
