package com.ejianc.business.pro.income.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author CJ
 * @Description:
 * @date 2023/8/10 10:06
 */
public class SX2JExcelImportHandlerUtil {

    private static final String INTEGER_PATTERN = "^[-+]?[0-9]+$";
    private static final String DECIMAL_PATTERN = "^[-+]?[0-9]*\\.?[0-9]+$";

    public static boolean validateDecimal(String number) {
        return valiateNumber(number, DECIMAL_PATTERN);
    }

    public static boolean validateInteger(String number) {
        return valiateNumber(number, INTEGER_PATTERN);
    }

    public static boolean valiateNumber(String num, String patternStr) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(num);
        return matcher.matches();
    }

}
