/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.CompositiveCoefficientCategoryEntity;
import com.ejianc.business.pro.income.service.ICompositiveCoefficientCategoryService;
import com.ejianc.business.pro.income.service.ICompositiveCoefficientService;
import com.ejianc.business.pro.income.vo.CompositiveCoefficientCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"compositiveCoefficientCategory"})
public class CompositiveCoefficientCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICompositiveCoefficientCategoryService service;
    @Autowired
    private ICompositiveCoefficientService compositiveCoefficientService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CompositiveCoefficientCategoryVO> saveOrUpdate(@RequestBody CompositiveCoefficientCategoryVO saveOrUpdateVO) {
        int count;
        CompositiveCoefficientCategoryEntity entity = (CompositiveCoefficientCategoryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CompositiveCoefficientCategoryEntity.class));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"code", (Object)saveOrUpdateVO.getCode());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        if (null != saveOrUpdateVO.getId()) {
            query.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if ((count = this.service.count((Wrapper)query)) > 0) {
            return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff0c\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        CompositiveCoefficientCategoryVO vo = (CompositiveCoefficientCategoryVO)BeanMapper.map((Object)((Object)entity), CompositiveCoefficientCategoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CompositiveCoefficientCategoryVO> queryDetail(Long id) {
        CompositiveCoefficientCategoryEntity entity = (CompositiveCoefficientCategoryEntity)((Object)this.service.selectById(id));
        CompositiveCoefficientCategoryVO vo = (CompositiveCoefficientCategoryVO)BeanMapper.map((Object)((Object)entity), CompositiveCoefficientCategoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CompositiveCoefficientCategoryVO> vos) {
        List categoryIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"pid", categoryIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        long count = this.compositiveCoefficientService.count((Wrapper)query);
        if (count > 0L) {
            return CommonResponse.error((String)"\u5206\u7c7b\u4e0b\u6709\u7efc\u5408\u7cfb\u6570\u9879\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.service.removeByIds(categoryIds, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CompositiveCoefficientCategoryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CompositiveCoefficientCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CompositiveCoefficientCategory-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCompositiveCoefficientCategoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CompositiveCoefficientCategoryVO>> refCompositiveCoefficientCategoryData(String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(1);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CompositiveCoefficientCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

