package com.ejianc.business.pro.arch.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * @author yqls
 * @date 2021-08-14 16:15:06
 */
public class DetailIndexExcelReader2 {
    public static List<List<List<String>>> readExcel(MultipartFile file) {
        String originalFileName = file.getOriginalFilename();
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
        extName = FileUtils.getFileExt(originalFileName, false);
        if ("xls".equals(extName)) {
            return read2003Excel(file);
        } else if ("xlsx".equals(extName)) {
            return read2007Excel(file);
        } else {
            throw new BusinessException("不支持的文件类型");
        }
    }

    private static List<List<List<String>>> read2003Excel(MultipartFile file) {
        LinkedList resList = new LinkedList();

        HSSFWorkbook hwb;
        try {
            hwb = new HSSFWorkbook(new BufferedInputStream(file.getInputStream()));
        } catch (IOException var17) {
            throw new BusinessException(var17.getMessage());
        }

        int size = hwb.getNumberOfSheets();

        for(int index = 0; index < size; ++index) {
            LinkedList list = new LinkedList();
            HSSFSheet sheet = hwb.getSheetAt(index);
            String value = null;
            HSSFRow row = null;
            HSSFCell cell = null;
            boolean isEmpty = true;
            int rowFirstCellNum = 0;
            int num = 1;
            if(index == 5){
                num=4;
            }
            if(index == 6){
                num=4;
            }
            if(index == 8){
                num=4;
            }
            if(index == 10){
                num=4;
            }
            if(index == 11){
                num=4;
            }
            if(index == 12){
                num=4;
            }
            if(index == 13){
                num=4;
            }
            if(index == 14){
                num=4;
            }
            if(index == 15){
                num=4;
            }
            if(index == 16){
                num=4;
            }
            if(index == 17){
                num=4;
            }
            if(index == 18){
                num=4;
            }
            if(index == 19){
                num=4;
            }
            if(index == 20){
                num=4;
            }
            if(index == 21){
                num=4;
            }
            for(int i = num; i < sheet.getPhysicalNumberOfRows(); ++i) {
                isEmpty = true;
                row = sheet.getRow(i);
                if (row != null) {
                    int rowLastCellNum = sheet.getRow(num).getLastCellNum();
                    List<String> linked = new LinkedList();

                    int headLength;
                    for(headLength = rowFirstCellNum; headLength < rowLastCellNum; ++headLength) {
                        cell = row.getCell(headLength);
                        if (cell == null) {
                            linked.add("");
                        } else if (headLength == 0) {
                            // 首列树形编码直接转成文本处理
                            linked.add(get2003DetailIndex(cell));
                        } else {
                            if (null!=cell){
                                value = formatCell(cell);
                            }
                            linked.add(value);
                        }
                    }

                    if (list.size() > 0) {
                        headLength = ((List)list.get(0)).size();
                        int nowLinkLength = linked.size();
                        if (nowLinkLength < headLength) {
                            for(int k = nowLinkLength; k < headLength; ++k) {
                                linked.add(null);
                            }
                        }
                    }

                    if (isEmpty) {
                        Iterator var19 = linked.iterator();

                        while(var19.hasNext()) {
                            Object object = var19.next();
                            if (object != null && StringUtils.isNotBlank(String.valueOf(object))) {
                                isEmpty = false;
                                break;
                            }
                        }
                    }

                    if (isEmpty) {
                        break;
                    }

                    list.add(linked);
                }
            }
            resList.add(list);
        }

        return resList;
    }
    public static String formatCell(Cell cell){
        String ret =null;
        switch (cell.getCellType()) {
            case Cell.CELL_TYPE_STRING:
                ret = cell.getStringCellValue();
                break;
            case Cell.CELL_TYPE_FORMULA:
                Workbook wb = cell.getSheet().getWorkbook();
                wb.setForceFormulaRecalculation(true);
                CreationHelper crateHelper = wb.getCreationHelper();
                FormulaEvaluator evaluator = crateHelper.createFormulaEvaluator();
                evaluator.setIgnoreMissingWorkbooks(true);

                if (null!=cell){
                    Cell cell1 = evaluator.evaluateInCell(cell);
                    ret = formatCell(cell1);
                }
                break;
            case Cell.CELL_TYPE_NUMERIC:
                if (HSSFDateUtil.isCellDateFormatted(cell)) {// 处理日期格式、时间格式
                    SimpleDateFormat sdf = null;
                    if (cell.getCellStyle().getDataFormat() == HSSFDataFormat
                            .getBuiltinFormat("h:mm")) {
                        sdf = new SimpleDateFormat("HH:mm");
                    } else {// 日期
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                    }
                    Date date = cell.getDateCellValue();
                    ret = sdf.format(date);
                } else if (cell.getCellStyle().getDataFormat() == 58) {
                    // 处理自定义日期格式：m月d日(通过判断单元格的格式id解决，id的值是58)
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    double value = cell.getNumericCellValue();
                    Date date = org.apache.poi.ss.usermodel.DateUtil
                            .getJavaDate(value);
                    ret = sdf.format(date);
                } else {
                    ret = NumberToTextConverter.toText(cell.getNumericCellValue());
                }
                break;
            case Cell.CELL_TYPE_BLANK:
                ret = "";
                break;
            case Cell.CELL_TYPE_BOOLEAN:
                ret = String.valueOf(cell.getBooleanCellValue());
                break;
            case Cell.CELL_TYPE_ERROR:
                ret = null;
                break;
            default:
                ret = null;
        }
        return ret; //有必要自行trim
    }
    private static List<List<List<String>>> read2007Excel(MultipartFile file) {

        LinkedList resList = new LinkedList();

        XSSFWorkbook xwb;
        try {
            xwb = new XSSFWorkbook(new BufferedInputStream(file.getInputStream()));
        } catch (IOException var17) {
            throw new BusinessException(var17.getMessage());
        }

        int size = xwb.getNumberOfSheets();

        for(int index = 0; index < size; ++index) {
            LinkedList list = new LinkedList();
            XSSFSheet sheet = xwb.getSheetAt(index);
            String value = null;
            XSSFRow row = null;
            XSSFCell cell = null;
            boolean isEmpty = true;
            int rowFirstCellNum = 0;
            int num = 1;
            if(index == 0){
                num=13;
            }

            System.out.println("index--index：" + JSONObject.toJSONString(index));
            for(int i = num; i < sheet.getPhysicalNumberOfRows(); ++i) {
                isEmpty = true;
                row = sheet.getRow(i);
                int rowLastCellNum = sheet.getRow(num).getLastCellNum();
                if (row != null) {
                    List<String> linked = new LinkedList();

                    int headLength;
                    for(headLength = rowFirstCellNum; headLength < rowLastCellNum; ++headLength) {
                        cell = row.getCell(headLength);
                        if (cell == null) {
                            linked.add("");
                        } else if (headLength == 0) {
                            // 首列树形编码直接转成文本处理
                            linked.add(get2007DetailIndex(cell));
                        } else {
                            if (null!=cell){
                                value = formatCell(cell);
                            }
                            linked.add(value);
                        }
                    }

                    if (list.size() > 0) {
                        headLength = ((List)list.get(0)).size();
                        int nowLinkLength = linked.size();
                        if (nowLinkLength < headLength) {
                            for(int k = nowLinkLength; k < headLength; ++k) {
                                linked.add(null);
                            }
                        }
                    }

                    if (isEmpty) {
                        Iterator var19 = linked.iterator();

                        while(var19.hasNext()) {
                            Object object = var19.next();
                            if (object != null && StringUtils.isNotBlank(String.valueOf(object))) {
                                isEmpty = false;
                                break;
                            }
                        }
                    }

                    if (isEmpty) {
                        break;
                    }

                    list.add(linked);
                }
            }
            resList.add(list);
        }

        return resList;
    }

    /**
     * 2003默认转成文本处理
     * @param cell
     * @return
     */
    private static String get2003DetailIndex(HSSFCell cell) {
        String val = "";
        try {
            val = cell.getStringCellValue();
        } catch (Exception e) {
            try {
                val = String.valueOf(new BigDecimal(String.valueOf(cell.getNumericCellValue())).stripTrailingZeros());
            } catch (Exception e1) {
                val = " " + cell.getBooleanCellValue();
            }
        }
        return val;
    }

    /**
     * 2007默认转成文本处理
     * @param cell
     * @return
     */
    private static String get2007DetailIndex(XSSFCell cell) {
        String val = "";
        try {
            val = cell.getStringCellValue();
        } catch (Exception e) {
            try {
                val = String.valueOf(new BigDecimal(String.valueOf(cell.getNumericCellValue())).stripTrailingZeros());
            } catch (Exception e1) {
                val = " " + cell.getBooleanCellValue();
            }
        }
        return val;
    }

    /**
     * 获取excel文件页签数
     * @param file
     * @return
     */
    public static Integer getNumberOfSheets(MultipartFile file){
        String originalFileName = new String(file.getOriginalFilename());
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
        extName = FileUtils.getFileExt(originalFileName, false);
        if ("xls".equals(extName)) {
            HSSFWorkbook hwb;
            try {
                hwb = new HSSFWorkbook(new BufferedInputStream(file.getInputStream()));
            } catch (IOException var17) {
                throw new BusinessException(var17.getMessage());
            }
            return hwb.getNumberOfSheets();
        } else if ("xlsx".equals(extName)) {
            XSSFWorkbook xwb;
            try {
                xwb = new XSSFWorkbook(new BufferedInputStream(file.getInputStream()));
            } catch (IOException var17) {
                throw new BusinessException(var17.getMessage());
            }
            return xwb.getNumberOfSheets();
        } else {
            throw new BusinessException("不支持的文件类型");
        }
    }
}
